/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.model;

import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.openhft.chronicle.releasenotes.model.IssueComment;
import net.openhft.chronicle.releasenotes.model.Label;

public final class Issue {
    private final int number;
    private final String title;
    private final List<Label> labels;
    private final List<IssueComment> comments;
    private final URL url;

    public Issue(int number, String title, List<Label> labels, List<IssueComment> comments, URL url) {
        this.number = number;
        this.title = Objects.requireNonNull(title);
        this.labels = Objects.requireNonNull(labels);
        this.comments = Objects.requireNonNull(comments);
        this.url = Objects.requireNonNull(url);
    }

    public int getNumber() {
        return this.number;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Label> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public List<IssueComment> getComments() {
        return Collections.unmodifiableList(this.comments);
    }

    public URL getUrl() {
        return this.url;
    }

    public static Comparator<Issue> compareByLabel(String missingLabel) {
        return (o1, o2) -> {
            String l1 = o1.getLabels().stream().map(Label::getName).findFirst().orElse(missingLabel);
            String l2 = o2.getLabels().stream().map(Label::getName).findFirst().orElse(missingLabel);
            return l1.compareTo(l2);
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        return this.number == issue.number && this.title.equals(issue.title) && this.labels.equals(issue.labels) && this.comments.equals(issue.comments) && this.url.equals(issue.url);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.title, this.labels, this.comments, this.url);
    }

    public String toString() {
        return "Issue{number=" + this.number + ", title='" + this.title + '\'' + ", labels=" + this.labels + ", comments=" + this.comments + ", url=" + this.url.toString() + '}';
    }
}

