/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.connector.github;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.openhft.chronicle.releasenotes.connector.ConnectorProviderKey;
import net.openhft.chronicle.releasenotes.connector.ReleaseConnector;
import net.openhft.chronicle.releasenotes.connector.github.GitHubConnectorProviderKey;
import net.openhft.chronicle.releasenotes.connector.github.graphql.GitHubGraphQLClient;
import net.openhft.chronicle.releasenotes.connector.github.graphql.model.Tag;
import net.openhft.chronicle.releasenotes.creator.ReleaseNoteCreator;
import net.openhft.chronicle.releasenotes.model.AggregatedReleaseNotes;
import net.openhft.chronicle.releasenotes.model.FullIssue;
import net.openhft.chronicle.releasenotes.model.Issue;
import net.openhft.chronicle.releasenotes.model.IssueComment;
import net.openhft.chronicle.releasenotes.model.ReleaseNotes;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCommitQueryBuilder;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTag;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.RateLimitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitHubReleaseConnector
implements ReleaseConnector {
    private static final int REQUEST_PAGE_SIZE = 100;
    private static final List<String> CLOSING_KEYWORDS = Arrays.asList("close", "closes", "closed", "fix", "fixes", "fixed", "resolve", "resolves", "resolved");
    private final GitHub github;
    private final GitHubGraphQLClient graphQLClient;
    private final ReleaseNoteCreator releaseNoteCreator;
    private final Logger logger;

    public GitHubReleaseConnector(String token) throws IOException {
        this(token, LoggerFactory.getLogger(GitHubReleaseConnector.class));
    }

    public GitHubReleaseConnector(String token, Logger logger) throws IOException {
        Objects.requireNonNull(token);
        Objects.requireNonNull(logger);
        this.github = new GitHubBuilder().withOAuthToken(token).withRateLimitHandler(new RateLimitHandler(){

            public void onError(IOException e, HttpURLConnection uc) throws IOException {
                throw e;
            }
        }).build();
        this.graphQLClient = new GitHubGraphQLClient(token);
        this.releaseNoteCreator = ReleaseNoteCreator.markdown();
        this.logger = logger;
    }

    public ReleaseConnector.ReleaseResult<ReleaseNotes> createReleaseFromBranch(String repository, String tag, String branch, ReleaseConnector.BranchReleaseOptions releaseOptions) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(branch);
        this.logger.info("Creating release in repository '{}' for tag '{}' on branch '{}'", new Object[]{repository, tag, branch});
        this.logger.debug("{}", (Object)releaseOptions);
        try {
            GHRepository repositoryRef = this.getRepository(repository);
            return this.getOrCreateRelease(repositoryRef, tag, releaseOptions.getTitle() != null ? releaseOptions.getTitle() : tag, () -> this.getIssuesForBranch(repositoryRef, branch, tag, releaseOptions.includeIssuesWithoutClosingKeyword(), releaseOptions.includePullRequests()), releaseOptions.getIgnoredLabels(), releaseOptions.overrideRelease() ? ReleaseAction.CREATE_OR_UPDATE : ReleaseAction.CREATE, releaseOptions.includeAdditionalContext());
        }
        catch (RuntimeException e) {
            return ReleaseConnector.ReleaseResult.fail((Throwable)e);
        }
    }

    public ReleaseConnector.ReleaseResult<ReleaseNotes> createReleaseFromBranch(String repository, String tag, String endTag, String branch, ReleaseConnector.BranchReleaseOptions releaseOptions) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(endTag);
        Objects.requireNonNull(branch);
        this.logger.info("Creating release in repository '{}' for tag '{}' until tag '{}' on branch '{}'", new Object[]{repository, tag, endTag, branch});
        this.logger.debug("{}", (Object)releaseOptions);
        try {
            GHRepository repositoryRef = this.getRepository(repository);
            return this.getOrCreateRelease(repositoryRef, tag, releaseOptions.getTitle() != null ? releaseOptions.getTitle() : tag, () -> this.getIssuesForBranch(repositoryRef, branch, tag, endTag, releaseOptions.includeIssuesWithoutClosingKeyword(), releaseOptions.includePullRequests()), releaseOptions.getIgnoredLabels(), releaseOptions.overrideRelease() ? ReleaseAction.CREATE_OR_UPDATE : ReleaseAction.CREATE, releaseOptions.includeAdditionalContext());
        }
        catch (RuntimeException e) {
            return ReleaseConnector.ReleaseResult.fail((Throwable)e);
        }
    }

    public ReleaseConnector.ReleaseResult<ReleaseNotes> createReleaseFromMilestone(String repository, String tag, String milestone, ReleaseConnector.MilestoneReleaseOptions releaseOptions) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(milestone);
        this.logger.info("Creating release in repository '{}' for tag '{}' from milestone '{}'", new Object[]{repository, tag, milestone});
        this.logger.debug("{}", (Object)releaseOptions);
        try {
            GHRepository repositoryRef = this.getRepository(repository);
            return this.getOrCreateRelease(repositoryRef, tag, tag, () -> this.getClosedMilestoneIssues(repositoryRef, milestone), releaseOptions.getIgnoredLabels(), releaseOptions.overrideRelease() ? ReleaseAction.CREATE_OR_UPDATE : ReleaseAction.CREATE, releaseOptions.includeAdditionalContext());
        }
        catch (RuntimeException e) {
            return ReleaseConnector.ReleaseResult.fail((Throwable)e);
        }
    }

    public ReleaseConnector.ReleaseResult<AggregatedReleaseNotes> createAggregatedRelease(String repository, String tag, Map<String, List<String>> releases, ReleaseConnector.AggregateReleaseOptions releaseOptions) {
        GHRepository repositoryRef;
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(releases);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Creating aggregated release in repository '{}' for tag '{}'", (Object)repository, (Object)tag);
            StringBuilder formattedReleases = new StringBuilder();
            releases.forEach((k, v) -> {
                formattedReleases.append((String)k).append(":\n");
                v.forEach(release -> formattedReleases.append("\t- ").append((String)release).append('\n'));
                formattedReleases.append('\n');
            });
            this.logger.info("Releases: \n{}", (Object)formattedReleases);
        }
        try {
            repositoryRef = this.getRepository(repository);
        }
        catch (RuntimeException e) {
            return ReleaseConnector.ReleaseResult.fail((Throwable)e);
        }
        try {
            if (!this.checkTagExists(repositoryRef, tag)) {
                return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException("Tag '" + tag + "' not found"));
            }
            GHRelease remoteRelease = repositoryRef.getReleaseByTagName(tag);
            StringJoiner missingRepositoriesJoiner = new StringJoiner(", ");
            StringJoiner missingReleasesJoiner = new StringJoiner(", ");
            Map<String, Map> sourceReleases = releases.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                GHRepository sourceRepository;
                try {
                    sourceRepository = this.getRepository((String)entry.getKey());
                }
                catch (RuntimeException e) {
                    missingRepositoriesJoiner.add((CharSequence)entry.getKey());
                    return new HashMap();
                }
                return ((List)entry.getValue()).stream().collect(HashMap::new, (m, v) -> {
                    GHRelease release;
                    try {
                        release = this.getRelease(sourceRepository, (String)v);
                    }
                    catch (RuntimeException e) {
                        missingReleasesJoiner.add(sourceRepository.getName() + ":" + v);
                        return;
                    }
                    m.put(v, release);
                }, HashMap::putAll);
            }));
            String missingRepositories = missingRepositoriesJoiner.toString();
            String missingReleases = missingReleasesJoiner.toString();
            if (!missingRepositories.isEmpty() || !missingReleases.isEmpty()) {
                StringBuilder exceptionMessage = new StringBuilder();
                if (!missingRepositories.isEmpty()) {
                    exceptionMessage.append("Repositories [").append(missingRepositories).append("] not found");
                }
                if (!missingReleases.isEmpty()) {
                    if (exceptionMessage.length() != 0) {
                        exceptionMessage.append('\n');
                    }
                    exceptionMessage.append("Releases [").append(missingReleases).append("] not found");
                }
                return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException(exceptionMessage.toString()));
            }
            List normalizedReleaseNotes = sourceReleases.values().stream().map(stringGHReleaseMap -> stringGHReleaseMap.entrySet().stream().map(entry -> {
                GHRelease release = (GHRelease)entry.getValue();
                if (release == null) {
                    return new ReleaseNotes((String)entry.getKey(), (String)entry.getKey(), Collections.emptyList());
                }
                return new ReleaseNotes(release.getTagName(), release.getName(), Collections.emptyList());
            }).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
            AggregatedReleaseNotes aggregatedReleaseNotes = new AggregatedReleaseNotes(tag, tag, normalizedReleaseNotes);
            String body = this.releaseNoteCreator.formatAggregatedReleaseNotes(aggregatedReleaseNotes);
            if (remoteRelease != null) {
                if (!releaseOptions.overrideRelease()) {
                    return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException("Release for tag '" + tag + "' already exists"));
                }
                GHRelease release = remoteRelease.update().name(tag).body(body).update();
                return ReleaseConnector.ReleaseResult.success((Object)aggregatedReleaseNotes, (URL)release.getHtmlUrl());
            }
            GHRelease release = repositoryRef.createRelease(tag).name(tag).body(body).create();
            return ReleaseConnector.ReleaseResult.success((Object)aggregatedReleaseNotes, (URL)release.getHtmlUrl());
        }
        catch (IOException e) {
            return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException("Failed to create release for tag '" + tag + "'"));
        }
    }

    public ReleaseConnector.ReleaseResult<AggregatedReleaseNotes> createAggregatedRelease(String repository, String tag, List<ReleaseNotes> releaseNotes, ReleaseConnector.AggregateReleaseOptions releaseOptions) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(releaseNotes);
        GHRepository repositoryRef = this.getRepository(repository);
        try {
            if (!this.checkTagExists(repositoryRef, tag)) {
                return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException("Tag '" + tag + "' not found"));
            }
            GHRelease remoteRelease = repositoryRef.getReleaseByTagName(tag);
            AggregatedReleaseNotes aggregatedReleaseNotes = new AggregatedReleaseNotes(tag, tag, releaseNotes);
            String body = this.releaseNoteCreator.formatAggregatedReleaseNotes(aggregatedReleaseNotes);
            if (remoteRelease != null) {
                if (!releaseOptions.overrideRelease()) {
                    return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException("Release for tag '" + tag + "' already exists"));
                }
                GHRelease release = remoteRelease.update().name(tag).body(body).update();
                return ReleaseConnector.ReleaseResult.success((Object)aggregatedReleaseNotes, (URL)release.getHtmlUrl());
            }
            GHRelease release = repositoryRef.createRelease(tag).name(tag).body(body).create();
            return ReleaseConnector.ReleaseResult.success((Object)aggregatedReleaseNotes, (URL)release.getHtmlUrl());
        }
        catch (IOException e) {
            return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException("Failed to create release for tag '" + tag + "'"));
        }
    }

    public ReleaseConnector.ReleaseResult<ReleaseNotes> queryReleaseFromBranch(String repository, String tag, String branch, ReleaseConnector.BranchReleaseOptions releaseOptions) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(branch);
        this.logger.info("Querying release in repository '{}' for tag '{}' on branch '{}'", new Object[]{repository, tag, branch});
        this.logger.debug("{}", (Object)releaseOptions);
        try {
            GHRepository repositoryRef = this.getRepository(repository);
            return this.getOrCreateRelease(repositoryRef, tag, releaseOptions.getTitle() != null ? releaseOptions.getTitle() : tag, () -> this.getIssuesForBranch(repositoryRef, branch, tag, releaseOptions.includeIssuesWithoutClosingKeyword(), releaseOptions.includePullRequests()), releaseOptions.getIgnoredLabels(), ReleaseAction.QUERY, releaseOptions.includeAdditionalContext());
        }
        catch (RuntimeException e) {
            return ReleaseConnector.ReleaseResult.fail((Throwable)e);
        }
    }

    public Issue getIssue(String repository, int number) throws IOException {
        GHRepository repositoryRef = this.getRepository(repository);
        return this.mapIssue(repositoryRef.getIssue(number), true);
    }

    public ReleaseConnector.ReleaseResult<Issue> createIssueComment(String repository, int number, String message) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(message);
        this.logger.info("Commenting issue #{} in repository '{}'", (Object)number, (Object)repository);
        try {
            GHRepository repositoryRef = this.getRepository(repository);
            GHIssue issue = repositoryRef.getIssue(number);
            issue.comment(message);
            return ReleaseConnector.ReleaseResult.success((Object)this.mapIssue(issue, false), (URL)issue.getHtmlUrl());
        }
        catch (IOException e) {
            return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException("Failed to comment issue #" + number));
        }
    }

    public Class<? extends ConnectorProviderKey> getKey() {
        return GitHubConnectorProviderKey.class;
    }

    public void close() throws Exception {
        super.close();
        this.graphQLClient.close();
    }

    private ReleaseConnector.ReleaseResult<ReleaseNotes> getOrCreateRelease(GHRepository repository, String tag, String title, Supplier<List<GHIssue>> issueSupplier, List<String> ignoredLabels, ReleaseAction action, boolean includeAdditionalContext) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(issueSupplier);
        try {
            if (!this.checkTagExists(repository, tag)) {
                return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException("Tag '" + tag + "' not found"));
            }
            List issues = this.filterIssueLabels(issueSupplier.get(), ignoredLabels).stream().map(issue -> this.mapIssue((GHIssue)issue, includeAdditionalContext)).collect(Collectors.toList());
            ReleaseNotes releaseNotes = new ReleaseNotes(tag, title, issues);
            String body = this.releaseNoteCreator.formatReleaseNotes(releaseNotes);
            GHRelease remoteRelease = repository.getReleaseByTagName(tag);
            if (remoteRelease != null) {
                URL htmlUrl;
                if (action == ReleaseAction.CREATE) {
                    return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException("Release for tag '" + tag + "' already exists"));
                }
                if (action == ReleaseAction.CREATE_OR_UPDATE) {
                    GHRelease release = remoteRelease.update().name(title).body(body).update();
                    htmlUrl = release.getHtmlUrl();
                } else {
                    htmlUrl = remoteRelease.getHtmlUrl();
                }
                return ReleaseConnector.ReleaseResult.success((Object)releaseNotes, (URL)htmlUrl);
            }
            if (action == ReleaseAction.QUERY) {
                return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException("Release for tag '" + tag + "' does not exists"));
            }
            GHRelease release = repository.createRelease(releaseNotes.getTag()).name(title).body(body).create();
            return ReleaseConnector.ReleaseResult.success((Object)releaseNotes, (URL)release.getHtmlUrl());
        }
        catch (IOException e) {
            return ReleaseConnector.ReleaseResult.fail((Throwable)new RuntimeException("Failed to " + action.displayName() + " release for tag '" + tag + "'"));
        }
    }

    private GHRepository getRepository(String repository) {
        Objects.requireNonNull(repository);
        this.logger.debug("Fetching repository '{}'", (Object)repository);
        try {
            return this.github.getRepository(repository);
        }
        catch (IOException e) {
            throw new RuntimeException("Repository '" + repository + "' not found");
        }
    }

    private GHBranch getBranch(GHRepository repository, String branch) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        this.logger.debug("Fetching branch '{}' in repository '{}'", (Object)branch, (Object)repository.getFullName());
        try {
            return repository.getBranch(branch);
        }
        catch (IOException e) {
            throw new RuntimeException("Branch '" + branch + "' not found in repository '" + repository + "'");
        }
    }

    private GHRelease getRelease(GHRepository repository, String tag) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        this.logger.debug("Fetching release for tag '{}' in repository '{}'", (Object)tag, (Object)repository.getFullName());
        try {
            return repository.getReleaseByTagName(tag);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to find release for tag '" + tag + "' in repository '" + repository.getName() + "'");
        }
    }

    private Map<String, GHTag> getTags(GHRepository repository, String ... tags) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tags);
        this.logger.debug("Fetching tags [{}] in repository '{}'", (Object)String.join((CharSequence)", ", tags), (Object)repository.getFullName());
        List<String> tagSet = Arrays.asList(tags);
        try {
            HashMap<String, GHTag> collectedTags = new HashMap<String, GHTag>();
            for (GHTag tag2 : repository.listTags().withPageSize(100)) {
                if (tagSet.contains(tag2.getName())) {
                    collectedTags.put(tag2.getName(), tag2);
                }
                if (collectedTags.size() != tagSet.size()) continue;
                return collectedTags;
            }
            String missingTags = Arrays.stream(tags).filter(tag -> !collectedTags.containsKey(tag)).collect(Collectors.joining(", "));
            throw new RuntimeException("Failed to find tag(s) [" + missingTags + "] in repository '" + repository.getFullName() + "'");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch tags for repository '" + repository.getFullName() + "'");
        }
    }

    private Optional<GHTag> getPreviousTag(GHRepository repository, GHBranch branch, GHTag tag) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        Objects.requireNonNull(tag);
        this.logger.debug("Fetching tag before tag '{}' in repository '{}' on branch '{}'", new Object[]{tag.getName(), repository.getFullName(), branch.getName()});
        List commits = this.getCommitsForBranchFromTag(repository, branch, tag).stream().map(GHCommit::getSHA1).collect(Collectors.toList());
        String tagName = this.graphQLClient.getTags(repository.getOwnerName(), repository.getName()).stream().filter(t -> commits.contains(t.getCommitSHA1()) && !t.getName().equals(tag.getName())).limit(1L).findFirst().map(Tag::getName).orElse(null);
        if (tagName == null) {
            return Optional.empty();
        }
        return Optional.of(this.getTags(repository, tagName).get(tagName));
    }

    private boolean checkTagExists(GHRepository repository, String tag) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        this.logger.debug("Checking if tag '{}' exists in repository '{}'", (Object)tag, (Object)repository.getFullName());
        try {
            return this.stream((Iterable)repository.listTags().withPageSize(100)).anyMatch(ghTag -> ghTag.getName().equals(tag));
        }
        catch (IOException e) {
            return false;
        }
    }

    private List<GHCommit> getCommitsForBranchFromTag(GHRepository repository, GHBranch branch, GHTag tag) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        Objects.requireNonNull(tag);
        this.logger.debug("Fetching commits for branch '{}' from tag '{}' in repository '{}'", new Object[]{branch.getName(), tag.getName(), repository.getFullName()});
        try {
            PagedIterable commits = repository.queryCommits().from(branch.getName()).until(this.getCommitDate(tag.getCommit())).pageSize(100).list();
            return commits.toList();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch commits for branch '" + branch.getName() + "' in repository '" + repository.getName() + "'");
        }
    }

    private List<GHIssue> getIssuesForBranch(GHRepository repository, String branch, String startTag, boolean includeIssuesWithoutClosingKeyword, boolean includePullRequests) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        Objects.requireNonNull(startTag);
        return this.getIssuesForBranch(repository, branch, startTag, null, includeIssuesWithoutClosingKeyword, includePullRequests);
    }

    private List<GHIssue> getIssuesForBranch(GHRepository repository, String branch, String startTag, String endTag, boolean includeIssuesWithoutClosingKeyword, boolean includePullRequests) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        Objects.requireNonNull(startTag);
        this.logger.debug("Fetching issues on branch '{}' between tags '{}' and '{}' in repository '{}'", new Object[]{branch, startTag, endTag, repository.getFullName()});
        List<GHCommit> commits = this.getCommitsForBranch(repository, branch, startTag, endTag);
        List<Integer> issueIds = this.extractIssueIdsFromCommits(commits, includeIssuesWithoutClosingKeyword);
        return this.getIssuesFromIds(repository, issueIds, includePullRequests);
    }

    private List<GHCommit> getCommitsForBranch(GHRepository repository, String branch, String startTag, String endTag) {
        GHCommit endCommit;
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        Objects.requireNonNull(startTag);
        this.logger.debug("Fetching commits for branch '{}' between tags '{}' and '{}' in repository '{}'", new Object[]{branch, startTag, endTag, repository.getFullName()});
        GHBranch branchRef = this.getBranch(repository, branch);
        Map<String, GHTag> tags = endTag == null ? this.getTags(repository, startTag) : this.getTags(repository, startTag, endTag);
        GHTag endTagRef = endTag == null ? (GHTag)this.getPreviousTag(repository, branchRef, tags.get(startTag)).orElse(null) : tags.get(endTag);
        GHCommit startCommit = tags.get(startTag).getCommit();
        GHCommit gHCommit = endCommit = endTagRef == null ? null : endTagRef.getCommit();
        if (endCommit != null && this.getCommitDate(startCommit).before(this.getCommitDate(endCommit))) {
            throw new RuntimeException("Start tag '" + startTag + "' has a commit date before end tag '" + endTag + "'");
        }
        try {
            List commits;
            GHCommitQueryBuilder commitQueryBuilder = branchRef.getOwner().queryCommits().from(branchRef.getSHA1()).until(this.getCommitDate(startCommit)).pageSize(100);
            if (endCommit != null) {
                commitQueryBuilder.since(this.getCommitDate(endCommit));
            }
            if ((commits = commitQueryBuilder.list().withPageSize(100).toList()).stream().noneMatch(commit -> commit.getSHA1().equals(startCommit.getSHA1()))) {
                throw new RuntimeException("Tag '" + startTag + "' not found on branch '" + branch + "'");
            }
            if (endCommit != null && commits.stream().noneMatch(commit -> commit.getSHA1().equals(endCommit.getSHA1()))) {
                throw new RuntimeException("Tag '" + endTagRef.getName() + "' not found on branch '" + branch + "'");
            }
            if (endCommit == null) {
                return commits;
            }
            return commits.stream().filter(ghCommit -> this.getCommitDate((GHCommit)ghCommit).after(this.getCommitDate(endCommit))).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch commits for branch '" + branchRef.getName() + "' in repository '" + branchRef.getOwner().getName() + "'");
        }
    }

    private List<Integer> extractIssueIdsFromCommits(List<GHCommit> commits, boolean includeIssuesWithoutClosingKeyword) {
        this.logger.debug("Extracting issue ids from {} commits", (Object)commits.size());
        return commits.stream().map(commit -> this.extractIssueIdsFromCommit((GHCommit)commit, includeIssuesWithoutClosingKeyword)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private List<Integer> extractIssueIdsFromCommit(GHCommit commit, boolean includeIssuesWithoutClosingKeyword) {
        Objects.requireNonNull(commit);
        this.logger.debug("Extracting issue ids from commit '{}' in repository '{}'", (Object)commit.getSHA1(), (Object)commit.getOwner().getFullName());
        try {
            String commitMessage = commit.getCommitShortInfo().getMessage().replaceAll("\n", " ").replaceAll("\r", "").replaceAll(" +", " ").replaceAll(",", "");
            String[] tokens = commitMessage.split(" ");
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (int i = 0; i < tokens.length; ++i) {
                String tokenToCheck;
                String token = tokens[i];
                if (!includeIssuesWithoutClosingKeyword && (!this.isClosingKeyword(token) || i == tokens.length - 1)) continue;
                String string = tokenToCheck = includeIssuesWithoutClosingKeyword ? token : tokens[i + 1];
                if (this.isLocalIssueReference(tokenToCheck)) {
                    ids.add(Integer.valueOf(tokenToCheck.substring(1)));
                    if (includeIssuesWithoutClosingKeyword) continue;
                    ++i;
                    continue;
                }
                if (!this.isUrlIssueReference(commit.getOwner(), tokenToCheck)) continue;
                ids.add(Integer.valueOf(tokenToCheck.substring(tokenToCheck.lastIndexOf("/") + 1)));
                if (includeIssuesWithoutClosingKeyword) continue;
                ++i;
            }
            return ids;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch commit info for commit '" + commit.getSHA1() + "'");
        }
    }

    private boolean isClosingKeyword(String token) {
        return CLOSING_KEYWORDS.contains(token.toLowerCase());
    }

    private boolean isLocalIssueReference(String token) {
        Objects.requireNonNull(token);
        if (!token.startsWith("#")) {
            return false;
        }
        String issueId = token.substring(1);
        if (!issueId.chars().allMatch(Character::isDigit)) {
            return false;
        }
        return issueId.charAt(0) != '0';
    }

    private boolean isUrlIssueReference(GHRepository repository, String token) {
        Objects.requireNonNull(token);
        if (!token.startsWith(repository.getHtmlUrl().toString())) {
            return false;
        }
        String[] split = token.split("/");
        if (!split[split.length - 2].equals("issues")) {
            return false;
        }
        String issueId = split[split.length - 1];
        if (!issueId.chars().allMatch(Character::isDigit)) {
            return false;
        }
        return issueId.charAt(0) != '0';
    }

    private List<GHIssue> getIssuesFromIds(GHRepository repository, List<Integer> ids, boolean includePullRequests) {
        Objects.requireNonNull(repository);
        if (ids.isEmpty()) {
            return new ArrayList<GHIssue>();
        }
        this.logger.debug("Fetching {} issues from repository '{}'", (Object)ids.size(), (Object)repository.getFullName());
        return this.stream((Iterable)repository.listIssues(GHIssueState.CLOSED).withPageSize(100)).filter(ghIssue -> ids.contains(ghIssue.getNumber()) && (includePullRequests || !ghIssue.isPullRequest())).collect(Collectors.toList());
    }

    private List<GHIssue> filterIssueLabels(List<GHIssue> issues, List<String> ignoredLabels) {
        Objects.requireNonNull(issues);
        if (ignoredLabels == null) {
            return issues;
        }
        return issues.stream().filter(issue -> issue.getLabels().stream().noneMatch(ghLabel -> ignoredLabels.contains(ghLabel.getName()))).collect(Collectors.toList());
    }

    private FullIssue mapIssue(GHIssue issue, boolean includeAdditionalContext) {
        return new FullIssue(issue.getNumber(), issue.getTitle(), issue.getLabels().stream().map(GHLabel::getName).collect(Collectors.toList()), this.mapIssueComments(issue, includeAdditionalContext), issue.getHtmlUrl());
    }

    private List<IssueComment> mapIssueComments(GHIssue issue, boolean includeAdditionalContext) {
        if (!includeAdditionalContext) {
            return Collections.emptyList();
        }
        try {
            return issue.getComments().stream().map(this::mapIssueComment).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch comments for issue #" + issue.getNumber());
        }
    }

    private IssueComment mapIssueComment(GHIssueComment issueComment) {
        try {
            return new IssueComment(issueComment.getBody(), issueComment.getCreatedAt());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to map issue comment to internal model");
        }
    }

    private List<GHIssue> getClosedMilestoneIssues(GHRepository repository, String milestone) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(milestone);
        GHMilestone milestoneRef = this.getMilestone(repository, milestone);
        return this.stream((Iterable)repository.listIssues(GHIssueState.CLOSED).withPageSize(100)).filter(ghIssue -> ghIssue.getMilestone() != null && ghIssue.getMilestone().getNumber() == milestoneRef.getNumber()).collect(Collectors.toList());
    }

    private GHMilestone getMilestone(GHRepository repository, String milestone) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(milestone);
        return this.stream((Iterable)repository.listMilestones(GHIssueState.ALL).withPageSize(100)).filter(ghMilestone -> ghMilestone.getTitle().equals(milestone)).findAny().orElseThrow(() -> new RuntimeException("Milestone '" + milestone + "' not found"));
    }

    private Date getCommitDate(GHCommit commit) {
        try {
            return commit.getCommitDate();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch commit date for commit '" + commit.getSHA1() + "'");
        }
    }

    private <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private static enum ReleaseAction {
        CREATE,
        CREATE_OR_UPDATE,
        QUERY;


        public String displayName() {
            return this.name().toLowerCase().replace('_', ' ');
        }
    }
}

