/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.connector.github;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.openhft.chronicle.releasenotes.connector.ConnectorProviderKey;
import net.openhft.chronicle.releasenotes.connector.MigrateConnector;
import net.openhft.chronicle.releasenotes.connector.github.GitHubConnectorProviderKey;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;

public final class GitHubMigrateConnector
implements MigrateConnector {
    private final GitHub github;

    public GitHubMigrateConnector(String token) throws IOException {
        this.github = new GitHubBuilder().withOAuthToken(Objects.requireNonNull(token)).build();
    }

    public MigrateConnector.MigrateResult migrateMilestones(String repository, Set<String> fromMilestones, String toMilestone, Set<String> ignoredLabels) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(fromMilestones);
        Objects.requireNonNull(toMilestone);
        GHRepository repositoryRef = this.getRepository(repository);
        Map<String, GHMilestone> milestonesRef = this.getMilestones(repositoryRef, fromMilestones);
        GHMilestone toMilestoneRef = this.getMilestone(repositoryRef, toMilestone);
        List<GHIssue> issues = this.getMilestoneIssues(repositoryRef, (List)milestonesRef.values(), ignoredLabels);
        AtomicReference<MigrateConnector.MigrateResult> migrateResult = new AtomicReference<MigrateConnector.MigrateResult>(MigrateConnector.MigrateResult.success());
        issues.forEach(ghIssue -> {
            try {
                ghIssue.setMilestone(toMilestoneRef);
            }
            catch (IOException e) {
                migrateResult.set(MigrateConnector.MigrateResult.fail((RuntimeException)new RuntimeException("Failed to assign issue #" + ghIssue.getNumber() + " to milestone '" + toMilestone + "'")));
            }
        });
        return migrateResult.get();
    }

    public Class<? extends ConnectorProviderKey> getKey() {
        return GitHubConnectorProviderKey.class;
    }

    private GHRepository getRepository(String repository) {
        Objects.requireNonNull(repository);
        try {
            return this.github.getRepository(repository);
        }
        catch (IOException e) {
            throw new RuntimeException("Repository '" + repository + "' not found");
        }
    }

    private Map<String, GHMilestone> getMilestones(GHRepository repository, Set<String> milestones) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(milestones);
        Map<String, GHMilestone> collectedMilestones = this.stream((Iterable)repository.listMilestones(GHIssueState.ALL)).filter(milestone -> milestones.contains(milestone.getTitle())).collect(Collectors.toMap(GHMilestone::getTitle, Function.identity()));
        if (collectedMilestones.size() == milestones.size()) {
            return collectedMilestones;
        }
        String missingMilestones = milestones.stream().filter(tag -> !collectedMilestones.containsKey(tag)).collect(Collectors.joining(", "));
        throw new RuntimeException("Failed to find milestones(s) [" + missingMilestones + "] in repository '" + repository.getFullName() + "'");
    }

    private GHMilestone getMilestone(GHRepository repository, String milestone) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(milestone);
        return this.stream((Iterable)repository.listMilestones(GHIssueState.ALL)).filter(ghMilestone -> ghMilestone.getTitle().equals(milestone)).findAny().orElseThrow(() -> new RuntimeException("Milestone '" + milestone + "' not found"));
    }

    private List<GHIssue> getMilestoneIssues(GHRepository repository, List<GHMilestone> milestones, Set<String> ignoredLabels) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(milestones);
        List milestoneNumbers = milestones.stream().map(GHMilestone::getNumber).collect(Collectors.toList());
        Stream<GHIssue> stream = this.stream((Iterable)repository.listIssues(GHIssueState.ALL)).filter(issue -> issue.getMilestone() != null && milestoneNumbers.contains(issue.getMilestone().getNumber()));
        if (ignoredLabels != null) {
            stream = stream.filter(issue -> issue.getLabels().stream().noneMatch(label -> ignoredLabels.contains(label.getName())));
        }
        return stream.collect(Collectors.toList());
    }

    private <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

