/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;
import net.openhft.chronicle.core.threads.ThreadLocalHelper;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.single.Indexing;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SCQIndexing
extends AbstractCloseable
implements Indexing,
Demarshallable,
WriteMarshallable,
Closeable {
    private static final boolean IGNORE_INDEXING_FAILURE = Jvm.getBoolean((String)"queue.ignoreIndexingFailure");
    private static final boolean REPORT_LINEAR_SCAN = Jvm.getBoolean((String)"chronicle.queue.report.linear.scan.latency");
    private static final long LINEAR_SCAN_WARN_THRESHOLD_NS = Long.getLong("linear.scan.warn.ns", 100000L);
    final LongValue nextEntryToBeIndexed;
    private final int indexCount;
    private final int indexCountBits;
    private final int indexSpacing;
    private final int indexSpacingBits;
    private final LongValue index2Index;
    private final Supplier<LongArrayValues> longArraySupplier;
    @NotNull
    private final ThreadLocal<WeakReference<LongArrayValuesHolder>> index2indexArray;
    @NotNull
    private final ThreadLocal<WeakReference<LongArrayValuesHolder>> indexArray;
    @NotNull
    private final WriteMarshallable index2IndexTemplate;
    @NotNull
    private final WriteMarshallable indexTemplate;
    private final Function<Supplier<LongArrayValues>, LongArrayValuesHolder> arrayValuesSupplierCall = this::newLogArrayValuesHolder;
    LongValue writePosition;
    Sequence sequence;
    int linearScanCount;
    int linearScanByPositionCount;
    Collection<Closeable> closeables = new ArrayList<Closeable>();
    private long lastScannedIndex = -1L;

    @UsedViaReflection
    private SCQIndexing(@NotNull WireIn wire) {
        this(wire.read((WireKey)IndexingFields.indexCount).int32(), wire.read((WireKey)IndexingFields.indexSpacing).int32(), wire.read((WireKey)IndexingFields.index2Index).int64ForBinding(null), wire.read((WireKey)IndexingFields.lastIndex).int64ForBinding(null), () -> ((WireIn)wire).newLongArrayReference());
    }

    SCQIndexing(@NotNull WireType wireType, int indexCount, int indexSpacing) {
        this(indexCount, indexSpacing, (LongValue)wireType.newLongReference().get(), (LongValue)wireType.newLongReference().get(), wireType.newLongArrayReference());
    }

    private SCQIndexing(int indexCount, int indexSpacing, LongValue index2Index, LongValue nextEntryToBeIndexed, Supplier<LongArrayValues> longArraySupplier) {
        this.indexCount = indexCount;
        this.indexCountBits = Maths.intLog2((long)indexCount);
        this.indexSpacing = indexSpacing;
        this.indexSpacingBits = Maths.intLog2((long)indexSpacing);
        this.index2Index = index2Index;
        this.nextEntryToBeIndexed = nextEntryToBeIndexed;
        this.longArraySupplier = longArraySupplier;
        this.index2indexArray = CleaningThreadLocal.withCleanup(wr -> Closeable.closeQuietly(wr.get()));
        this.indexArray = CleaningThreadLocal.withCleanup(wr -> Closeable.closeQuietly(wr.get()));
        this.index2IndexTemplate = w -> w.writeEventName((CharSequence)"index2index").int64array((long)indexCount);
        this.indexTemplate = w -> w.writeEventName((CharSequence)"index").int64array((long)indexCount);
        this.singleThreadedCheckDisabled(true);
    }

    private LongArrayValuesHolder newLogArrayValuesHolder(Supplier<LongArrayValues> las) {
        LongArrayValues values = las.get();
        LongArrayValuesHolder longArrayValuesHolder = new LongArrayValuesHolder(values);
        this.closeables.add((Closeable)values);
        return longArrayValuesHolder;
    }

    @NotNull
    private LongArrayValuesHolder getIndex2IndexArray() {
        return (LongArrayValuesHolder)ThreadLocalHelper.getTL(this.index2indexArray, this.longArraySupplier, this.arrayValuesSupplierCall);
    }

    @NotNull
    private LongArrayValuesHolder getIndexArray() {
        return (LongArrayValuesHolder)ThreadLocalHelper.getTL(this.indexArray, this.longArraySupplier, this.arrayValuesSupplierCall);
    }

    public long toAddress0(long index) {
        this.throwExceptionIfClosed();
        long siftedIndex = index >> this.indexSpacingBits + this.indexCountBits;
        long mask = (long)this.indexCount - 1L;
        return mask & siftedIndex;
    }

    long toAddress1(long index) {
        long siftedIndex = index >> this.indexSpacingBits;
        long mask = (long)this.indexCount - 1L;
        return mask & siftedIndex;
    }

    protected void performClose() {
        Closeable.closeQuietly((Object[])new Object[]{this.index2Index, this.nextEntryToBeIndexed});
        Closeable.closeQuietly(this.closeables);
        this.closeables.clear();
        this.closeTL(this.indexArray);
        this.closeTL(this.index2indexArray);
    }

    private void closeTL(ThreadLocal<WeakReference<LongArrayValuesHolder>> tl) {
        WeakReference<LongArrayValuesHolder> weakReference = tl.get();
        if (weakReference == null) {
            return;
        }
        LongArrayValuesHolder holder = (LongArrayValuesHolder)weakReference.get();
        if (holder != null) {
            Closeable.closeQuietly((Object)holder.values());
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)IndexingFields.indexCount).int64((long)this.indexCount).write((WireKey)IndexingFields.indexSpacing).int64((long)this.indexSpacing).write((WireKey)IndexingFields.index2Index).int64forBinding(0L, this.index2Index).write((WireKey)IndexingFields.lastIndex).int64forBinding(0L, this.nextEntryToBeIndexed);
    }

    @NotNull
    private LongArrayValues arrayForAddress(@NotNull Wire wire, long secondaryAddress) {
        LongArrayValuesHolder holder = this.getIndexArray();
        if (holder.address() == secondaryAddress) {
            return holder.values();
        }
        holder.address(secondaryAddress);
        wire.bytes().readPositionRemaining(secondaryAddress, 4L);
        wire.readMetaDataHeader();
        return this.array((WireIn)wire, holder.values(), false);
    }

    @NotNull
    private LongArrayValues array(@NotNull WireIn w, @NotNull LongArrayValues using, boolean index2index) {
        @NotNull ValueIn valueIn = this.readIndexValue(w, index2index ? "index2index" : "index");
        valueIn.int64array(using, (Object)this, (o1, o2) -> {});
        return using;
    }

    private ValueIn readIndexValue(@NotNull WireIn w, @NotNull String expectedName) {
        try (ScopedResource stlSb = Wires.acquireStringBuilderScoped();){
            StringBuilder sb = (StringBuilder)stlSb.get();
            long readPos = w.bytes().readPosition();
            @NotNull ValueIn valueIn = w.readEventName(sb);
            if (!expectedName.contentEquals(sb)) {
                throw new IllegalStateException("expecting " + expectedName + ", was " + sb + ", bytes: " + ((Bytes)w.bytes().readPosition(readPos)).toHexString());
            }
            ValueIn valueIn2 = valueIn;
            return valueIn2;
        }
    }

    long newIndex(@NotNull WireOut wire, boolean index2index) throws StreamCorruptedException {
        long writePosition = this.writePosition.getVolatileValue();
        Bytes bytes = wire.bytes();
        bytes.writePosition(writePosition);
        long position = wire.enterHeader((long)this.indexCount * 8L + 128L);
        WriteMarshallable writer = index2index ? this.index2IndexTemplate : this.indexTemplate;
        writer.writeMarshallable(wire);
        wire.updateHeader(position, true, 0);
        return position;
    }

    long newIndex(@NotNull Wire wire, @NotNull LongArrayValues index2Index, long index2) throws StreamCorruptedException {
        long pos = this.newIndex((WireOut)wire, false);
        if (!index2Index.compareAndSet(index2, 0L, pos)) {
            throw new IllegalStateException("Index " + index2 + " in index2index was altered while we hold the write lock!");
        }
        index2Index.setMaxUsed(index2 + 1L);
        return pos;
    }

    @NotNull
    ScanResult moveToIndex(@NotNull ExcerptContext ec, long index) {
        ScanResult value = this.moveToIndex0(ec, index);
        if (value == null) {
            return this.moveToIndexFromTheStart(ec, index);
        }
        return value;
    }

    @NotNull
    private ScanResult moveToIndexFromTheStart(@NotNull ExcerptContext ec, long index) {
        try {
            Wire wire = ec.wire();
            if (wire == null) {
                return ScanResult.END_OF_FILE;
            }
            wire.bytes().readPositionUnlimited(0L);
            if (wire.readDataHeader()) {
                return this.linearScan(wire, index, 0L, wire.bytes().readPosition());
            }
        }
        catch (EOFException fallback) {
            return ScanResult.END_OF_FILE;
        }
        return ScanResult.NOT_FOUND;
    }

    @Nullable
    ScanResult moveToIndex0(@NotNull ExcerptContext ec, long index) {
        if (this.index2Index.getVolatileValue() == 0L) {
            return null;
        }
        Wire wireForIndex = ec.wireForIndex();
        LongArrayValues index2index = this.getIndex2index(wireForIndex);
        long secondaryAddress = 0L;
        long startIndex = index & (long)(-this.indexSpacing);
        for (long primaryOffset = this.toAddress0(index); primaryOffset >= 0L; --primaryOffset) {
            LongArrayValues array1;
            ScanResult result;
            secondaryAddress = index2index.getValueAt(primaryOffset);
            if (secondaryAddress != 0L && (result = this.scanSecondaryIndexBackwards(ec, array1 = this.arrayForAddress(wireForIndex, secondaryAddress), startIndex, index)) != null) {
                return result;
            }
            startIndex -= (long)this.indexCount * (long)this.indexSpacing;
        }
        return null;
    }

    private ScanResult scanSecondaryIndexBackwards(@NotNull ExcerptContext ec, LongArrayValues array1, long startIndex, long index) {
        long secondaryOffset = this.toAddress1(index);
        do {
            long fromAddress;
            if ((fromAddress = array1.getValueAt(secondaryOffset)) == 0L) {
                startIndex -= (long)this.indexSpacing;
                continue;
            }
            Wire wire = ec.wire();
            if (wire == null) break;
            if (index == startIndex) {
                wire.bytes().readPositionUnlimited(fromAddress);
                return ScanResult.FOUND;
            }
            return this.linearScan(wire, index, startIndex, fromAddress);
        } while (--secondaryOffset >= 0L);
        return null;
    }

    @NotNull
    private ScanResult linearScan(@NotNull Wire wire, long toIndex, long fromKnownIndex, long knownAddress) {
        if (toIndex == fromKnownIndex) {
            return ScanResult.FOUND;
        }
        long start = REPORT_LINEAR_SCAN ? System.nanoTime() : 0L;
        ScanResult scanResult = this.linearScan0(wire, toIndex, fromKnownIndex, knownAddress);
        if (REPORT_LINEAR_SCAN) {
            this.printLinearScanTime(this.lastScannedIndex, fromKnownIndex, start, "linearScan by index");
        }
        return scanResult;
    }

    private void printLinearScanTime(long toIndex, long fromKnownIndex, long start, String desc) {
        if (toIndex <= 1L) {
            return;
        }
        long end = System.nanoTime();
        if (end < start + LINEAR_SCAN_WARN_THRESHOLD_NS) {
            return;
        }
        this.doPrintLinearScanTime(toIndex, fromKnownIndex, start, desc, end);
    }

    private void doPrintLinearScanTime(long toIndex, long fromKnownIndex, long start, String desc, long end) {
        StackTrace st = null;
        if (Jvm.isDebugEnabled(this.getClass())) {
            int time;
            int n = time = Jvm.isArm() ? 20000000 : 250000;
            if (toIndex > 0L && end > start + (long)time) {
                st = new StackTrace("This is a profile stack trace, not an ERROR");
            }
        }
        long tookUS = (end - start) / 1000L;
        String message = "Took " + tookUS + " us to " + desc + " " + fromKnownIndex + " to index " + toIndex;
        Jvm.perf().on(this.getClass(), message, (Throwable)st);
    }

    @NotNull
    private ScanResult linearScan0(@NotNull Wire wire, long toIndex, long fromKnownIndex, long knownAddress) {
        ++this.linearScanCount;
        @NotNull Bytes bytes = wire.bytes();
        long lastAddress = this.writePosition.getVolatileValue();
        long lastIndex = this.sequence.getSequence(lastAddress);
        if (toIndex == lastIndex) {
            assert (lastAddress >= knownAddress && lastIndex >= fromKnownIndex);
            knownAddress = lastAddress;
            fromKnownIndex = lastIndex;
        }
        bytes.readPositionUnlimited(knownAddress);
        long i = fromKnownIndex;
        while (true) {
            block8: {
                block7: {
                    try {
                        if (!wire.readDataHeader()) break block7;
                        if (i == toIndex) {
                            this.lastScannedIndex = i;
                            return ScanResult.FOUND;
                        }
                        int header = bytes.readVolatileInt();
                        if (Wires.isNotComplete((int)header)) {
                            this.lastScannedIndex = i;
                            return ScanResult.NOT_REACHED;
                        }
                        bytes.readSkip((long)Wires.lengthOf((int)header));
                        break block8;
                    }
                    catch (EOFException fallback) {
                        if (i != toIndex) break block7;
                        return ScanResult.END_OF_FILE;
                    }
                }
                this.lastScannedIndex = i;
                return i == toIndex ? ScanResult.NOT_FOUND : ScanResult.NOT_REACHED;
            }
            ++i;
        }
    }

    ScanResult linearScanTo(long toIndex, long knownIndex, ExcerptContext ec, long knownAddress) {
        return this.linearScan(ec.wire(), toIndex, knownIndex, knownAddress);
    }

    long linearScanByPosition(@NotNull Wire wire, long toPosition, long indexOfNext, long startAddress, boolean inclusive) throws EOFException {
        long start = REPORT_LINEAR_SCAN ? System.nanoTime() : 0L;
        long index = this.linearScanByPosition0(wire, toPosition, indexOfNext, startAddress, inclusive);
        if (REPORT_LINEAR_SCAN) {
            this.printLinearScanTime(index, startAddress, start, "linearScan by position");
        }
        return index;
    }

    long linearScanByPosition0(@NotNull Wire wire, long toPosition, long indexOfNext, long startAddress, boolean inclusive) throws EOFException {
        ++this.linearScanByPositionCount;
        assert (toPosition >= 0L);
        Bytes bytes = wire.bytes();
        long lastAddress = this.writePosition.getVolatileValue();
        long lastIndex = this.sequence.getSequence(lastAddress);
        long i = this.calculateInitialValue(toPosition, indexOfNext, startAddress, bytes, lastAddress, lastIndex);
        while (bytes.readPosition() <= toPosition) {
            int header;
            WireIn.HeaderType headerType = wire.readDataHeader(true);
            if (headerType == WireIn.HeaderType.EOF) {
                if (toPosition == Long.MAX_VALUE) {
                    return i;
                }
                throw new EOFException();
            }
            if (!inclusive && toPosition == bytes.readPosition()) {
                return i;
            }
            switch (headerType) {
                case NONE: {
                    if (toPosition == Long.MAX_VALUE) {
                        return i;
                    }
                    header = bytes.readVolatileInt(bytes.readPosition());
                    this.throwIndexNotWritten(toPosition, startAddress, bytes, header);
                    break;
                }
                case META_DATA: {
                    break;
                }
                case DATA: {
                    ++i;
                    break;
                }
                case EOF: {
                    throw new AssertionError((Object)"EOF should have been handled");
                }
            }
            if (bytes.readPosition() == toPosition) {
                return i;
            }
            header = bytes.readVolatileInt();
            int len = Wires.lengthOf((int)header);
            assert (Wires.isReady((int)header));
            bytes.readSkip((long)len);
        }
        return this.throwPositionNotAtStartOfMessage(toPosition, bytes);
    }

    private long calculateInitialValue(long toPosition, long indexOfNext, long startAddress, Bytes<?> bytes, long lastAddress, long lastIndex) {
        if (lastAddress > 0L && toPosition == lastAddress && lastIndex != -1L && lastIndex != Long.MIN_VALUE) {
            bytes.readPositionUnlimited(toPosition);
            return lastIndex - 1L;
        }
        bytes.readPositionUnlimited(startAddress);
        return indexOfNext - 1L;
    }

    private void throwIndexNotWritten(long toPosition, long startAddress, Bytes<?> bytes, int header) {
        throw new IllegalArgumentException("You can't know the index for an entry which hasn't been written. start: " + startAddress + ", at: " + bytes.readPosition() + ", header: " + Integer.toHexString(header) + ", toPos: " + toPosition);
    }

    private long throwPositionNotAtStartOfMessage(long toPosition, Bytes<?> bytes) {
        throw new IllegalArgumentException("position not the start of a message, bytes.readPosition()=" + bytes.readPosition() + ",toPosition=" + toPosition);
    }

    @Override
    public long nextEntryToBeIndexed() {
        return this.nextEntryToBeIndexed.getVolatileValue();
    }

    long sequenceForPosition(@NotNull ExcerptContext ec, long position, boolean inclusive) throws StreamCorruptedException {
        Wire wire;
        long lastKnownAddress;
        long indexOfNext;
        block8: {
            indexOfNext = 0L;
            lastKnownAddress = 0L;
            wire = ec.wireForIndex();
            try {
                LongArrayValues index2indexArr = this.getIndex2index(wire);
                int used2 = SCQIndexing.getUsedAsInt(index2indexArr);
                for (int index2 = used2 - 1; index2 >= 0; --index2) {
                    LongArrayValues indexValues;
                    int used;
                    long secondaryAddress = this.getSecondaryAddress(wire, index2indexArr, index2);
                    if (secondaryAddress == 0L || (used = SCQIndexing.getUsedAsInt(indexValues = this.arrayForAddress(wire, secondaryAddress))) == 0) continue;
                    long posN = indexValues.getVolatileValueAt(0L);
                    assert (posN >= 0L);
                    if (posN > position) continue;
                    for (int index1 = used - 1; index1 >= 0; --index1) {
                        long pos = indexValues.getVolatileValueAt((long)index1);
                        if (pos == 0L || pos > position) continue;
                        lastKnownAddress = pos;
                        indexOfNext = ((long)index2 << this.indexCountBits + this.indexSpacingBits) + ((long)index1 << this.indexSpacingBits);
                        if (lastKnownAddress == position) {
                            return indexOfNext;
                        }
                        break block8;
                    }
                }
            }
            catch (IllegalStateException e) {
                if (!Jvm.isDebugEnabled(this.getClass())) break block8;
                Jvm.debug().on(this.getClass(), "Attempt to find " + Long.toHexString(position), (Throwable)e);
            }
        }
        try {
            return this.linearScanByPosition(wire, position, indexOfNext, lastKnownAddress, inclusive);
        }
        catch (EOFException e) {
            throw new UncheckedIOException(e);
        }
    }

    static int getUsedAsInt(LongArrayValues index2indexArr) {
        if (((Byteable)index2indexArr).bytesStore() == null) {
            return 0;
        }
        long used = index2indexArr.getUsed();
        if (used < 0L || used > 32768L) {
            throw new IllegalStateException("Used: " + used);
        }
        return (int)used;
    }

    void initIndex(@NotNull Wire wire) throws StreamCorruptedException {
        long index2Index = this.index2Index.getVolatileValue();
        if (index2Index != 0L) {
            throw new IllegalStateException("Who wrote the index2index?");
        }
        long oldPos = wire.bytes().writePosition();
        if (!this.writePosition.compareAndSwapValue(0L, oldPos)) {
            throw new IllegalStateException("Who updated the position?");
        }
        long index = this.newIndex((WireOut)wire, true);
        this.index2Index.compareAndSwapValue(0L, index);
        LongArrayValues index2index = this.getIndex2index(wire);
        this.newIndex(wire, index2index, 0L);
        if (!this.writePosition.compareAndSwapValue(oldPos, 0L)) {
            throw new IllegalStateException("Who reset the position?");
        }
    }

    private LongArrayValues getIndex2index(@NotNull Wire wire) {
        LongArrayValuesHolder holder = this.getIndex2IndexArray();
        LongArrayValues values = holder.values();
        if (((Byteable)values).bytesStore() != null) {
            return values;
        }
        long indexToIndex = this.index2Index.getVolatileValue();
        try (DocumentContext ignored = wire.readingDocument(indexToIndex);){
            LongArrayValues longArrayValues = this.array((WireIn)wire, values, true);
            return longArrayValues;
        }
    }

    private long getSecondaryAddress(@NotNull Wire wire, @NotNull LongArrayValues index2indexArr, int index2) throws StreamCorruptedException {
        long secondaryAddress = index2indexArr.getVolatileValueAt((long)index2);
        if (secondaryAddress == 0L) {
            secondaryAddress = this.newIndex(wire, index2indexArr, index2);
            long sa = index2indexArr.getValueAt((long)index2);
            if (sa != secondaryAddress) {
                throw new AssertionError();
            }
        }
        return secondaryAddress;
    }

    void setPositionForSequenceNumber(@NotNull ExcerptContext ec, long sequenceNumber, long position) throws StreamCorruptedException {
        long secondaryAddress;
        if (!this.indexable(sequenceNumber)) {
            return;
        }
        Wire wire = ec.wireForIndex();
        Bytes bytes = wire.bytes();
        if (position > bytes.capacity()) {
            throw new IllegalArgumentException("pos: " + position);
        }
        LongArrayValues index2indexArr = this.getIndex2index(wire);
        if (((Byteable)index2indexArr).bytesStore() == null) {
            assert (false);
            return;
        }
        int index2 = (int)(sequenceNumber >>> this.indexCountBits + this.indexSpacingBits);
        if (index2 >= this.indexCount) {
            if (IGNORE_INDEXING_FAILURE) {
                return;
            }
            this.throwNumEntriesExceededForRollCycle(sequenceNumber);
        }
        if ((secondaryAddress = this.getSecondaryAddress(wire, index2indexArr, index2)) > bytes.capacity()) {
            this.throwSecondaryAddressError(secondaryAddress);
        }
        bytes.readLimitToCapacity();
        LongArrayValues indexValues = this.arrayForAddress(wire, secondaryAddress);
        int index3 = (int)(sequenceNumber >>> this.indexSpacingBits & (long)(this.indexCount - 1));
        long posN = indexValues.getValueAt((long)index3);
        if (posN != 0L) {
            indexValues.setValueAt((long)index3, position);
            return;
        }
        indexValues.setValueAt((long)index3, position);
        indexValues.setMaxUsed((long)index3 + 1L);
        this.nextEntryToBeIndexed.setMaxValue(sequenceNumber + (long)this.indexSpacing);
    }

    private void throwSecondaryAddressError(long secondaryAddress) {
        throw new IllegalStateException("sa2: " + secondaryAddress);
    }

    private void throwNumEntriesExceededForRollCycle(long sequenceNumber) {
        throw new IllegalStateException("Unable to index " + sequenceNumber + ", the number of entries exceeds max number for the current rollcycle");
    }

    @Override
    public boolean indexable(long index) {
        this.throwExceptionIfClosed();
        return (index & (long)(this.indexSpacing - 1)) == 0L;
    }

    @Override
    public long lastSequenceNumber(@NotNull ExcerptContext ec) throws StreamCorruptedException {
        this.throwExceptionIfClosed();
        Sequence sequence1 = this.sequence;
        if (sequence1 != null) {
            for (int i = 0; i < 128; ++i) {
                long address = this.writePosition.getVolatileValue(0L);
                if (address == 0L) {
                    return -1L;
                }
                long sequence = sequence1.getSequence(address);
                if (sequence == Long.MIN_VALUE) continue;
                if (sequence == -1L) break;
                try {
                    Wire wireForIndex = ec.wireForIndex();
                    return wireForIndex == null ? sequence : this.linearScanByPosition(wireForIndex, Long.MAX_VALUE, sequence, address, true);
                }
                catch (EOFException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return this.sequenceForPosition(ec, Long.MAX_VALUE, false);
    }

    @Override
    public int indexCount() {
        return this.indexCount;
    }

    @Override
    public int indexSpacing() {
        return this.indexSpacing;
    }

    public long moveToEnd(Wire wire) {
        Sequence sequence1 = this.sequence;
        if (sequence1 != null) {
            for (int i = 0; i < 128; ++i) {
                long endAddress = this.writePosition.getVolatileValue(0L);
                if (endAddress == 0L) {
                    return -1L;
                }
                long sequence = sequence1.getSequence(endAddress);
                if (sequence == Long.MIN_VALUE) continue;
                if (sequence == -1L) {
                    return -1L;
                }
                Bytes bytes = wire.bytes();
                if (wire.usePadding()) {
                    endAddress += BytesUtil.padOffset((long)endAddress);
                }
                bytes.readPosition(endAddress);
                int header;
                while ((header = bytes.readVolatileInt(endAddress)) != 0 && !Wires.isNotComplete((int)header)) {
                    int len = Wires.lengthOf((int)header) + 4;
                    len += (int)BytesUtil.padOffset((long)len);
                    bytes.readSkip((long)len);
                    endAddress += (long)len;
                    if (!Wires.isData((int)header)) continue;
                    ++sequence;
                }
                return sequence;
            }
        }
        return -1L;
    }

    @Override
    public int linearScanCount() {
        return this.linearScanCount;
    }

    @Override
    public int linearScanByPositionCount() {
        return this.linearScanByPositionCount;
    }

    static class LongArrayValuesHolder {
        private final LongArrayValues values;
        private long address;

        LongArrayValuesHolder(LongArrayValues values) {
            this.values = values;
            this.address = Long.MIN_VALUE;
        }

        public long address() {
            return this.address;
        }

        public void address(long address) {
            this.address = address;
        }

        public LongArrayValues values() {
            return this.values;
        }
    }

    static enum IndexingFields implements WireKey
    {
        indexCount,
        indexSpacing,
        index2Index,
        lastIndex;

    }
}

