/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.rollcycles;

import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.rollcycles.RollCycleArithmetic;

public enum LargeRollCycles implements RollCycle
{
    LARGE_HOURLY("yyyyMMdd-HH'L'", 3600000, 8192, 64),
    LARGE_DAILY("yyyyMMdd'L'", 86400000, 32768, 128),
    XLARGE_DAILY("yyyyMMdd'X'", 86400000, 32768, 256),
    HUGE_DAILY("yyyyMMdd'H'", 86400000, 32768, 1024);

    private final String format;
    private final int lengthInMillis;
    private final RollCycleArithmetic arithmetic;

    private LargeRollCycles(String format, int lengthInMillis, int indexCount, int indexSpacing) {
        this.format = format;
        this.lengthInMillis = lengthInMillis;
        this.arithmetic = RollCycleArithmetic.of(indexCount, indexSpacing);
    }

    @Override
    public long maxMessagesPerCycle() {
        return this.arithmetic.maxMessagesPerCycle();
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public int lengthInMillis() {
        return this.lengthInMillis;
    }

    @Override
    public int defaultIndexCount() {
        return this.arithmetic.indexCount();
    }

    @Override
    public int defaultIndexSpacing() {
        return this.arithmetic.indexSpacing();
    }

    @Override
    public long toIndex(int cycle, long sequenceNumber) {
        return this.arithmetic.toIndex(cycle, sequenceNumber);
    }

    @Override
    public long toSequenceNumber(long index) {
        return this.arithmetic.toSequenceNumber(index);
    }

    @Override
    public int toCycle(long index) {
        return this.arithmetic.toCycle(index);
    }
}

