/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.WeekFields;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.queue.RollCycle;
import org.jetbrains.annotations.NotNull;

public class RollingResourcesCache {
    public static final ParseCount NO_PARSE_COUNT = new ParseCount("", Integer.MIN_VALUE);
    private static final int CACHE_SIZE = Jvm.getInteger((String)"chronicle.queue.rollingResourceCache.size", (Integer)128);
    private static final int ONE_DAY_IN_MILLIS = 86400000;
    private static final int MAX_TIMESTAMP_CACHE_SIZE = 32;
    @NotNull
    private final Function<String, File> fileFactory;
    @NotNull
    private final DateTimeFormatter formatter;
    @NotNull
    private final Resource[] values;
    private final int length;
    @NotNull
    private final Function<File, String> fileToName;
    private final String format;
    private final ConcurrentMap<File, Long> filenameToTimestampCache = new ConcurrentHashMap<File, Long>(32);
    private final long epoch;
    private ParseCount lastParseCount = NO_PARSE_COUNT;

    public RollingResourcesCache(@NotNull RollCycle cycle, long epoch, @NotNull Function<String, File> nameToFile, @NotNull Function<File, String> fileToName) {
        this(cycle.lengthInMillis(), cycle.format(), epoch, nameToFile, fileToName);
    }

    private RollingResourcesCache(int length, @NotNull String format, long epoch, @NotNull Function<String, File> nameToFile, @NotNull Function<File, String> fileToName) {
        this.length = length;
        this.fileToName = fileToName;
        this.values = new Resource[CACHE_SIZE];
        long millisInDay = epoch % 86400000L;
        this.epoch = millisInDay >= 0L ? epoch - millisInDay : -86400000L;
        this.format = format;
        this.formatter = DateTimeFormatter.ofPattern(this.format).withZone(ZoneId.of("UTC"));
        this.fileFactory = nameToFile;
    }

    @NotNull
    public Resource resourceFor(long cycle) {
        int hash;
        Resource dv;
        long millisSinceBeginningOfEpoch = cycle * (long)this.length;
        long h = Maths.hash64((long)millisSinceBeginningOfEpoch);
        if ((dv = this.values[hash = (int)(h ^= h >> 32) & CACHE_SIZE - 1]) == null || dv.millis != millisSinceBeginningOfEpoch) {
            Instant instant = Instant.ofEpochMilli(millisSinceBeginningOfEpoch + this.epoch);
            @NotNull String text = this.formatter.format(instant);
            this.values[hash] = dv = new Resource(millisSinceBeginningOfEpoch, text, this.fileFactory.apply(text));
        }
        return dv;
    }

    public int parseCount(@NotNull String name) {
        ParseCount last = this.lastParseCount;
        if (name.equals(last.name)) {
            return last.count;
        }
        int count = this.parseCount0(name);
        this.lastParseCount = new ParseCount(name, count);
        return count;
    }

    private int parseCount0(@NotNull String name) {
        try {
            TemporalAccessor parse = this.formatter.parse(name);
            if (!parse.isSupported(ChronoField.EPOCH_DAY)) {
                WeekFields weekFields = WeekFields.of(this.formatter.getLocale());
                if (parse.isSupported(weekFields.weekBasedYear()) && parse.isSupported(weekFields.weekOfWeekBasedYear())) {
                    int year = Math.toIntExact(parse.getLong(weekFields.weekBasedYear()));
                    int week = Math.toIntExact(parse.getLong(weekFields.weekOfWeekBasedYear()));
                    LocalDate ld = LocalDate.now().withYear(year).with(weekFields.weekOfYear(), week).with(weekFields.dayOfWeek(), 1L);
                    return Math.toIntExact(ld.toEpochDay());
                }
                throw new UnsupportedOperationException("Unable to parse " + name + " using format " + this.format);
            }
            long epochDay = parse.getLong(ChronoField.EPOCH_DAY) * 86400L;
            if (parse.isSupported(ChronoField.SECOND_OF_DAY)) {
                epochDay += parse.getLong(ChronoField.SECOND_OF_DAY);
            }
            return Maths.toInt32((long)((epochDay - this.epoch / 1000L) / (long)(this.length / 1000)));
        }
        catch (DateTimeParseException e) {
            throw new RuntimeException(String.format("Unable to parse %s using format %s", name, this.format), e);
        }
    }

    public Long toLong(File file) {
        long value;
        Long cachedValue = (Long)this.filenameToTimestampCache.get(file);
        if (cachedValue != null) {
            return cachedValue;
        }
        TemporalAccessor parse = this.formatter.parse(this.fileToName.apply(file));
        if (this.length == 86400000) {
            value = parse.getLong(ChronoField.EPOCH_DAY);
        } else if (this.length < 86400000) {
            value = Instant.from(parse).toEpochMilli() / (long)this.length;
        } else {
            long daysSinceEpoch = parse.getLong(ChronoField.EPOCH_DAY);
            long adjShift = daysSinceEpoch < 0L ? -1L : 0L;
            value = adjShift + daysSinceEpoch * 86400L / (long)(this.length / 1000);
        }
        if (this.filenameToTimestampCache.size() >= 32) {
            this.filenameToTimestampCache.clear();
        }
        this.filenameToTimestampCache.put(file, value);
        return value;
    }

    public static final class Resource {
        public final long millis;
        public final String text;
        public final File path;
        public final File parentPath;
        public boolean pathExists;

        Resource(long millis, String text, File path) {
            this.millis = millis;
            this.text = text;
            this.path = path;
            this.parentPath = path.getParentFile();
        }
    }

    static final class ParseCount {
        final String name;
        final int count;

        public ParseCount(String name, int count) {
            this.name = name;
            this.count = count;
        }
    }
}

