/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.writer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WriteMarshallable;

public class ChronicleWriter {
    private Path basePath;
    private String methodName;
    private List<String> files;
    private Class<?> writeTo;

    public void execute() throws IOException {
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder(this.basePath).build();
             ExcerptAppender appender = queue.createAppender();){
            for (String file : this.files) {
                Object payload = Marshallable.fromFile(Object.class, (String)file);
                DocumentContext dc = appender.writingDocument();
                Throwable throwable = null;
                try {
                    if (this.writeTo != null) {
                        dc.wire().write((CharSequence)this.methodName).marshallable((WriteMarshallable)payload);
                        continue;
                    }
                    dc.wire().write((CharSequence)this.methodName).object(payload);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                }
            }
        }
    }

    public ChronicleWriter withBasePath(Path path) {
        this.basePath = path;
        return this;
    }

    public ChronicleWriter asMethodWriter(String interfaceName) {
        try {
            this.writeTo = Class.forName(interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw Jvm.rethrow((Throwable)e);
        }
        return this;
    }

    public ChronicleWriter withMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public ChronicleWriter withFiles(List<String> files) {
        this.files = files;
        return this;
    }
}

