/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.rollcycles.LargeRollCycles;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.queue.rollcycles.RollCycleArithmetic;
import net.openhft.chronicle.queue.rollcycles.SparseRollCycles;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;

public enum RollCycles implements RollCycle
{
    FIVE_MINUTELY("yyyyMMdd-HHmm'V'", 300000, 2048, 256),
    TEN_MINUTELY("yyyyMMdd-HHmm'X'", 600000, 2048, 256),
    TWENTY_MINUTELY("yyyyMMdd-HHmm'XX'", 1200000, 2048, 256),
    HALF_HOURLY("yyyyMMdd-HHmm'H'", 1800000, 2048, 256),
    FAST_HOURLY("yyyyMMdd-HH'F'", 3600000, 4096, 256),
    TWO_HOURLY("yyyyMMdd-HH'II'", 0x6DDD00, 4096, 256),
    FOUR_HOURLY("yyyyMMdd-HH'IV'", 14400000, 4096, 256),
    SIX_HOURLY("yyyyMMdd-HH'VI'", 21600000, 4096, 256),
    FAST_DAILY("yyyyMMdd'F'", 86400000, 4096, 256),
    MINUTELY("yyyyMMdd-HHmm", 60000, 2048, 16),
    HOURLY("yyyyMMdd-HH", 3600000, 4096, 16),
    DAILY("yyyyMMdd", 86400000, 8192, 64),
    LARGE_HOURLY("yyyyMMdd-HH'L'", 3600000, 8192, 64),
    LARGE_DAILY("yyyyMMdd'L'", 86400000, 32768, 128),
    XLARGE_DAILY("yyyyMMdd'X'", 86400000, 32768, 256),
    HUGE_DAILY("yyyyMMdd'H'", 86400000, 32768, 1024),
    SMALL_DAILY("yyyyMMdd'S'", 86400000, 8192, 8),
    LARGE_HOURLY_SPARSE("yyyyMMdd-HH'LS'", 3600000, 4096, 1024),
    LARGE_HOURLY_XSPARSE("yyyyMMdd-HH'LX'", 3600000, 2048, 0x100000),
    HUGE_DAILY_XSPARSE("yyyyMMdd'HX'", 86400000, 16384, 0x100000),
    TEST_SECONDLY("yyyyMMdd-HHmmss'T'", 1000, 32768, 4),
    TEST4_SECONDLY("yyyyMMdd-HHmmss'T4'", 1000, 32, 4),
    TEST_HOURLY("yyyyMMdd-HH'T'", 3600000, 16, 4),
    TEST_DAILY("yyyyMMdd'T1'", 86400000, 8, 1),
    TEST2_DAILY("yyyyMMdd'T2'", 86400000, 16, 2),
    TEST4_DAILY("yyyyMMdd'T4'", 86400000, 32, 4),
    TEST8_DAILY("yyyyMMdd'T8'", 86400000, 128, 8);

    public static final RollCycles DEFAULT;
    private static final Map<RollCycle, Enum<?>> DEPRECATED_MAPPINGS;
    private static final Iterable<RollCycle> VALUES;
    private final String format;
    private final int lengthInMillis;
    private final RollCycleArithmetic arithmetic;

    private RollCycles(String format, int lengthInMillis, int indexCount, int indexSpacing) {
        this.format = format;
        this.lengthInMillis = lengthInMillis;
        this.arithmetic = RollCycleArithmetic.of(indexCount, indexSpacing);
    }

    public static Iterable<RollCycle> all() {
        return VALUES;
    }

    @Deprecated
    public static long maxMessagesPerCycle(long indexCount0, int indexSpacing0) {
        long indexCount = Maths.nextPower2((long)indexCount0, (long)8L);
        int indexSpacing = Maths.nextPower2((int)indexSpacing0, (int)1);
        int cycleShift = Math.max(32, Maths.intLog2((long)indexCount) * 2 + Maths.intLog2((long)indexSpacing));
        long sequenceMask0 = (1L << cycleShift) - 1L;
        return Math.min(sequenceMask0, indexCount * indexCount * (long)indexSpacing);
    }

    @Override
    public long maxMessagesPerCycle() {
        return this.arithmetic.maxMessagesPerCycle();
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public int lengthInMillis() {
        return this.lengthInMillis;
    }

    @Override
    public int defaultIndexCount() {
        return this.arithmetic.indexCount();
    }

    @Override
    public int defaultIndexSpacing() {
        return this.arithmetic.indexSpacing();
    }

    @Override
    public long toIndex(int cycle, long sequenceNumber) {
        return this.arithmetic.toIndex(cycle, sequenceNumber);
    }

    @Override
    public long toSequenceNumber(long index) {
        return this.arithmetic.toSequenceNumber(index);
    }

    @Override
    public int toCycle(long index) {
        return this.arithmetic.toCycle(index);
    }

    public static RollCycle warnIfDeprecated(RollCycle rollCycle) {
        Enum<?> replacementEnum = DEPRECATED_MAPPINGS.get(rollCycle);
        if (replacementEnum != null) {
            Jvm.warn().on(RollCycles.class, "You've configured your queue to use a deprecated RollCycle (" + RollCycles.renderEnum((Enum)((Object)rollCycle)) + ") please consider switching to " + RollCycles.renderEnum(replacementEnum) + ", as the RollCycle constant you've nominated will be removed in a future release!");
        }
        return rollCycle;
    }

    static boolean isDeprecated(RollCycle rollCycle) {
        return DEPRECATED_MAPPINGS.containsKey(rollCycle);
    }

    private static String renderEnum(Enum<?> enumVal) {
        return enumVal.getClass().getName() + "." + enumVal.name();
    }

    private static Map<RollCycle, Enum<?>> initialiseDeprecatedMappings() {
        HashMap<RollCycles, Enum> mappings = new HashMap<RollCycles, Enum>();
        mappings.put(TEST_SECONDLY, TestRollCycles.TEST_SECONDLY);
        mappings.put(TEST4_SECONDLY, TestRollCycles.TEST4_SECONDLY);
        mappings.put(TEST_HOURLY, TestRollCycles.TEST_HOURLY);
        mappings.put(TEST_DAILY, TestRollCycles.TEST_DAILY);
        mappings.put(TEST2_DAILY, TestRollCycles.TEST2_DAILY);
        mappings.put(TEST4_DAILY, TestRollCycles.TEST4_DAILY);
        mappings.put(TEST8_DAILY, TestRollCycles.TEST8_DAILY);
        mappings.put(SMALL_DAILY, SparseRollCycles.SMALL_DAILY);
        mappings.put(LARGE_HOURLY_SPARSE, SparseRollCycles.LARGE_HOURLY_SPARSE);
        mappings.put(LARGE_HOURLY_XSPARSE, SparseRollCycles.LARGE_HOURLY_XSPARSE);
        mappings.put(HUGE_DAILY_XSPARSE, SparseRollCycles.HUGE_DAILY_XSPARSE);
        mappings.put(MINUTELY, LegacyRollCycles.MINUTELY);
        mappings.put(HOURLY, LegacyRollCycles.HOURLY);
        mappings.put(DAILY, LegacyRollCycles.DAILY);
        mappings.put(LARGE_HOURLY, LargeRollCycles.LARGE_HOURLY);
        mappings.put(LARGE_DAILY, LargeRollCycles.LARGE_DAILY);
        mappings.put(XLARGE_DAILY, LargeRollCycles.XLARGE_DAILY);
        mappings.put(HUGE_DAILY, LargeRollCycles.HUGE_DAILY);
        return Collections.unmodifiableMap(mappings);
    }

    static {
        DEFAULT = FAST_DAILY;
        DEPRECATED_MAPPINGS = RollCycles.initialiseDeprecatedMappings();
        ArrayList<Enum> allCycles = new ArrayList<Enum>();
        allCycles.addAll(Arrays.stream(RollCycles.values()).filter(rc -> !RollCycles.isDeprecated(rc)).collect(Collectors.toList()));
        allCycles.addAll(Arrays.asList(LegacyRollCycles.values()));
        allCycles.addAll(Arrays.asList(LargeRollCycles.values()));
        allCycles.addAll(Arrays.asList(SparseRollCycles.values()));
        allCycles.addAll(Arrays.asList(TestRollCycles.values()));
        VALUES = Collections.unmodifiableList(allCycles);
    }
}

