/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.threads.InterruptedRuntimeException;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.queue.impl.table.AbstractTSQueueLock;
import net.openhft.chronicle.queue.impl.table.UnlockMode;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import org.jetbrains.annotations.NotNull;

public class TableStoreWriteLock
extends AbstractTSQueueLock
implements WriteLock {
    public static final String APPEND_LOCK_KEY = "chronicle.append.lock";
    private static final String LOCK_KEY = "chronicle.write.lock";
    private final long timeout;
    private Thread lockedByThread = null;
    private StackTrace lockedHere;

    public TableStoreWriteLock(TableStore<?> tableStore, Supplier<TimingPauser> pauser, Long timeoutMs, String lockKey) {
        super(lockKey, tableStore, pauser);
        this.timeout = timeoutMs;
    }

    public TableStoreWriteLock(TableStore<?> tableStore, Supplier<TimingPauser> pauser, Long timeoutMs) {
        this(tableStore, pauser, timeoutMs, LOCK_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void lock() {
        this.throwExceptionIfClosed();
        assert (this.checkNotAlreadyLocked());
        long currentLockValue = 0L;
        TimingPauser tlPauser = (TimingPauser)this.pauser.get();
        try {
            currentLockValue = this.lock.getVolatileValue();
            while (!this.lock.compareAndSwapValue(Long.MIN_VALUE, PID)) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedRuntimeException("Interrupted for the lock file:" + this.path);
                }
                tlPauser.pause(this.timeout, TimeUnit.MILLISECONDS);
                currentLockValue = this.lock.getVolatileValue();
            }
            assert ((this.lockedByThread = Thread.currentThread()) != null && (this.lockedHere = new StackTrace()) != null);
            return;
        }
        catch (TimeoutException e) {
            String lockedBy = this.getLockedBy(currentLockValue);
            String warningMsg = "Couldn't acquire write lock after " + this.timeout + " ms for the lock file:" + this.path + ". Lock was held by " + lockedBy;
            if (this.forceUnlockOnTimeoutWhen == UnlockMode.NEVER) {
                throw new UnrecoverableTimeoutException((Exception)new IllegalStateException(warningMsg + ". You can manually unlock with net.openhft.chronicle.queue.main.UnlockMain"));
            }
            if (this.forceUnlockOnTimeoutWhen == UnlockMode.LOCKING_PROCESS_DEAD) {
                if (!this.forceUnlockIfProcessIsDead()) throw new UnrecoverableTimeoutException((Exception)new IllegalStateException(warningMsg + ". You can manually unlock with net.openhft.chronicle.queue.main.UnlockMain"));
                this.lock();
                return;
            } else {
                Jvm.warn().on(this.getClass(), warningMsg + ". Unlocking forcibly. Note that this feature is designed to recover if another process died while holding a lock. If the other process is still alive, you may see queue corruption.");
                this.forceUnlock(currentLockValue);
                this.lock();
            }
            return;
        }
        finally {
            tlPauser.reset();
        }
    }

    @NotNull
    protected String getLockedBy(long value) {
        return value == Long.MIN_VALUE ? "unknown" : (value == PID ? "me" : Long.toString((int)value));
    }

    private boolean checkNotAlreadyLocked() {
        if (!this.locked()) {
            return true;
        }
        if (this.lockedByThread == null) {
            return true;
        }
        if (this.lockedByThread == Thread.currentThread()) {
            throw new AssertionError("Lock is already acquired by current thread and is not reentrant - nested document context?", (Throwable)this.lockedHere);
        }
        return true;
    }

    @Override
    public void unlock() {
        this.throwExceptionIfClosed();
        if (!this.lock.compareAndSwapValue(PID, Long.MIN_VALUE)) {
            long value = this.lock.getVolatileValue();
            if (value == Long.MIN_VALUE) {
                Jvm.warn().on(this.getClass(), "Write lock was already unlocked. For the lock file:" + this.path);
            } else {
                Jvm.warn().on(this.getClass(), "Write lock was locked by someone else! For the lock file:" + this.path + " by PID: " + this.getLockedBy(value));
            }
        }
        this.lockedByThread = null;
        this.lockedHere = null;
    }

    @Override
    public boolean locked() {
        this.throwExceptionIfClosed();
        return this.lock.getVolatileValue(Long.MIN_VALUE) != Long.MIN_VALUE;
    }

    public void forceUnlock() {
        this.throwExceptionIfClosed();
        if (this.locked()) {
            this.forceUnlock(this.lockedBy());
        }
    }

    public void forceUnlockQuietly() {
        this.lock.setValue(Long.MIN_VALUE);
    }
}

