/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.File;
import java.io.StreamCorruptedException;
import java.text.ParseException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.util.DecoratedBufferUnderflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueSystemProperties;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.TailerState;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.single.MissingStoreFileException;
import net.openhft.chronicle.queue.impl.single.NotReachedException;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.NoDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SourceContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StoreTailer
extends AbstractCloseable
implements ExcerptTailer,
SourceContext,
ExcerptContext {
    static final int INDEXING_LINEAR_SCAN_THRESHOLD = 70;
    static final StringBuilderPool SBP = new StringBuilderPool();
    static final EOFException EOF_EXCEPTION = new EOFException();
    @NotNull
    private final SingleChronicleQueue queue;
    private final WireStorePool storePool;
    private final LongValue indexValue;
    private final StoreTailerContext context = new StoreTailerContext();
    private final MoveToState moveToState = new MoveToState();
    private final Finalizer finalizer;
    long index;
    long lastReadIndex;
    @Nullable
    SingleChronicleQueueStore store;
    private int cycle;
    private TailerDirection direction = TailerDirection.FORWARD;
    private Wire wireForIndex;
    private boolean readAfterReplicaAcknowledged;
    @NotNull
    private TailerState state = TailerState.UNINITIALISED;
    private long indexAtCreation = Long.MIN_VALUE;
    private boolean readingDocumentFound = false;
    private long address = NoBytesStore.NO_PAGE;
    private boolean striding = false;

    public StoreTailer(@NotNull SingleChronicleQueue queue, WireStorePool storePool) {
        this(queue, storePool, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreTailer(@NotNull SingleChronicleQueue queue, WireStorePool storePool, LongValue indexValue) {
        boolean error = true;
        try {
            this.queue = queue;
            this.storePool = storePool;
            this.indexValue = indexValue;
            this.setCycle(Integer.MIN_VALUE);
            this.index = 0L;
            if (indexValue == null) {
                this.toStart();
            } else {
                this.moveToIndex(indexValue.getVolatileValue());
            }
            this.finalizer = Jvm.isResourceTracing() ? new Finalizer() : null;
            error = false;
        }
        finally {
            if (error) {
                this.close();
            }
        }
        queue.addCloseListener(this);
    }

    @Override
    @NotNull
    public StoreTailer disableThreadSafetyCheck(boolean disableThreadSafetyCheck) {
        this.singleThreadedCheckDisabled(disableThreadSafetyCheck);
        return this;
    }

    public void singleThreadedCheckDisabled(boolean singleThreadedCheckDisabled) {
        Wire privateWire = this.privateWire();
        if (privateWire != null) {
            privateWire.bytes().singleThreadedCheckDisabled(singleThreadedCheckDisabled);
        }
        super.singleThreadedCheckDisabled(singleThreadedCheckDisabled);
    }

    public void singleThreadedCheckReset() {
        super.singleThreadedCheckReset();
        Wire privateWire = this.privateWire();
        if (privateWire != null) {
            ((MappedBytes)privateWire.bytes()).singleThreadedCheckReset();
        }
    }

    public boolean readDocument(@NotNull ReadMarshallable reader) {
        this.throwExceptionIfClosed();
        try (@NotNull DocumentContext dc = this.readingDocument(false);){
            if (!dc.isPresent()) {
                boolean bl = false;
                return bl;
            }
            reader.readMarshallable((WireIn)dc.wire());
        }
        return true;
    }

    @Override
    @NotNull
    public DocumentContext readingDocument() {
        long index = this.index();
        if (!(this.direction != TailerDirection.NONE || index != this.indexAtCreation && index != 0L || this.readingDocumentFound)) {
            return NoDocumentContext.INSTANCE;
        }
        return this.readingDocument(false);
    }

    protected void performClose() {
        Closeable.closeQuietly((Object)this.indexValue);
        this.context.wire(null);
        Wire w0 = this.wireForIndex;
        if (w0 != null) {
            w0.bytes().release(INIT);
        }
        this.wireForIndex = null;
        this.releaseStore();
    }

    @Override
    public Wire wire() {
        this.throwExceptionIfClosed();
        return this.privateWire();
    }

    @Nullable
    public Wire privateWire() {
        return this.context.wire();
    }

    @Override
    public Wire wireForIndex() {
        this.throwExceptionIfClosed();
        return this.wireForIndex;
    }

    @Override
    public long timeoutMS() {
        return this.queue.timeoutMS;
    }

    @Override
    public int sourceId() {
        return this.queue.sourceId;
    }

    @NotNull
    public String toString() {
        long index = this.index();
        return "StoreTailer{index sequence=" + this.queue.rollCycle().toSequenceNumber(index) + ", index cycle=" + this.queue.rollCycle().toCycle(index) + ", store=" + this.store + ", queue=" + this.queue + '}';
    }

    @Override
    @NotNull
    public DocumentContext readingDocument(boolean includeMetaData) {
        DocumentContext documentContext = this.readingDocument0(includeMetaData);
        if (documentContext.wire() != null && documentContext.wire().bytes().readRemaining() >= 0x40000000L) {
            throw new AssertionError((Object)("readRemaining " + documentContext.wire().bytes().readRemaining()));
        }
        return documentContext;
    }

    DocumentContext readingDocument0(boolean includeMetaData) {
        this.throwExceptionIfClosed();
        try {
            Wire wire;
            boolean next = false;
            boolean tryAgain = true;
            if (this.state == TailerState.FOUND_IN_CYCLE) {
                try {
                    next = this.inACycle(includeMetaData);
                    tryAgain = false;
                }
                catch (EOFException eof) {
                    this.state = TailerState.END_OF_CYCLE;
                }
            }
            if (tryAgain) {
                next = this.next0(includeMetaData);
            }
            if ((wire = this.context.wire()) != null && this.context.present(next)) {
                Bytes bytes = wire.bytes();
                this.context.setStart(bytes.readPosition() - 4L);
                this.readingDocumentFound = true;
                this.address = bytes.addressForRead(bytes.readPosition(), 4);
                this.lastReadIndex = this.index();
                return this.context;
            }
            RollCycle rollCycle = this.queue.rollCycle();
            if (this.state == TailerState.CYCLE_NOT_FOUND && this.direction == TailerDirection.FORWARD) {
                int firstCycle = this.queue.firstCycle();
                if (rollCycle.toCycle(this.index()) < firstCycle) {
                    this.toStart();
                }
            } else if (!next && this.state == TailerState.CYCLE_NOT_FOUND && this.cycle != this.queue.cycle()) {
                this.state = TailerState.END_OF_CYCLE;
            }
            this.setAddress(wire != null);
        }
        catch (StreamCorruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (UnrecoverableTimeoutException e) {
        }
        catch (DecoratedBufferUnderflowException e) {
            if (this.queue.isReadOnly()) {
                Jvm.warn().on(StoreTailer.class, "Tried to read past the end of a read-only view. Underlying data store may have grown since this tailer was created.", (Throwable)e);
            }
            throw e;
        }
        return NoDocumentContext.INSTANCE;
    }

    private boolean next0(boolean includeMetaData) throws StreamCorruptedException {
        block10: for (int i = 0; i < 1000; ++i) {
            switch (this.state) {
                case UNINITIALISED: {
                    long firstIndex = this.queue.firstIndex();
                    if (firstIndex == Long.MAX_VALUE) {
                        return false;
                    }
                    if (includeMetaData) {
                        if (!this.moveToCycle(this.queue.rollCycle().toCycle(firstIndex))) continue block10;
                        this.inACycleFound(this.wire().bytes());
                        return true;
                    }
                    if (this.moveToIndexInternal(firstIndex)) continue block10;
                    return false;
                }
                case NOT_REACHED_IN_CYCLE: {
                    if (this.moveToIndexInternal(this.index)) continue block10;
                    return false;
                }
                case FOUND_IN_CYCLE: {
                    try {
                        return this.inACycle(includeMetaData);
                    }
                    catch (EOFException eof) {
                        this.state = TailerState.END_OF_CYCLE;
                        continue block10;
                    }
                }
                case END_OF_CYCLE: {
                    if (this.endOfCycle()) continue block10;
                    return false;
                }
                case BEYOND_START_OF_CYCLE: {
                    if (this.beyondStartOfCycle()) continue block10;
                    return false;
                }
                case CYCLE_NOT_FOUND: {
                    if (this.nextCycleNotFound()) continue block10;
                    return false;
                }
                default: {
                    throw new AssertionError((Object)("state=" + (Object)((Object)this.state)));
                }
            }
        }
        throw new IllegalStateException("Unable to progress to the next cycle, state=" + (Object)((Object)this.state));
    }

    private boolean endOfCycle() {
        long oldIndex = this.index();
        int currentCycle = this.queue.rollCycle().toCycle(oldIndex);
        long nextIndex = this.nextIndexWithNextAvailableCycle(currentCycle);
        if (nextIndex != Long.MIN_VALUE) {
            return this.nextEndOfCycle(this.queue.rollCycle().toCycle(nextIndex));
        }
        this.state = TailerState.END_OF_CYCLE;
        return false;
    }

    private boolean beyondStartOfCycle() throws StreamCorruptedException {
        if (this.direction == TailerDirection.FORWARD) {
            this.state = TailerState.UNINITIALISED;
            return true;
        }
        if (this.direction == TailerDirection.BACKWARD) {
            return this.beyondStartOfCycleBackward();
        }
        throw new AssertionError((Object)("direction not set, direction=" + (Object)((Object)this.direction)));
    }

    private boolean nextEndOfCycle(int nextCycle) {
        if (this.moveToCycle(nextCycle)) {
            this.state = TailerState.FOUND_IN_CYCLE;
            return true;
        }
        if (this.state == TailerState.END_OF_CYCLE) {
            return true;
        }
        if (this.cycle < this.queue.lastCycle()) {
            this.state = TailerState.END_OF_CYCLE;
            return true;
        }
        this.cycle(nextCycle);
        this.state = TailerState.CYCLE_NOT_FOUND;
        return false;
    }

    @Override
    public long lastReadIndex() {
        return this.lastReadIndex;
    }

    private boolean beyondStartOfCycleBackward() throws StreamCorruptedException {
        boolean foundCycle = this.cycle(this.queue.rollCycle().toCycle(this.index()));
        if (foundCycle && this.cycle >= 0) {
            long lastSequenceNumberInThisCycle = this.store().sequenceForPosition(this, Long.MAX_VALUE, false);
            long nextIndex = this.queue.rollCycle().toIndex(this.cycle, lastSequenceNumberInThisCycle);
            this.moveToIndexInternal(nextIndex);
            this.state = TailerState.FOUND_IN_CYCLE;
            return true;
        }
        int cycle = this.queue.rollCycle().toCycle(this.index());
        long nextIndex = this.nextIndexWithNextAvailableCycle(cycle);
        if (nextIndex != Long.MIN_VALUE) {
            this.moveToIndexInternal(nextIndex);
            this.state = TailerState.FOUND_IN_CYCLE;
            return true;
        }
        this.state = TailerState.BEYOND_START_OF_CYCLE;
        return false;
    }

    private boolean nextCycleNotFound() {
        if (this.index() == Long.MIN_VALUE) {
            if (this.store != null) {
                this.queue.closeStore(this.store);
            }
            this.store = null;
            return false;
        }
        if (this.moveToIndexInternal(this.index())) {
            this.state = TailerState.FOUND_IN_CYCLE;
            return true;
        }
        return false;
    }

    private boolean inACycle(boolean includeMetaData) throws EOFException {
        if (this.readAfterReplicaAcknowledged && this.inACycleCheckRep()) {
            return false;
        }
        if (this.direction != TailerDirection.FORWARD && !this.inACycleNotForward()) {
            return false;
        }
        Wire wire = this.privateWire();
        if (wire == null) {
            this.throwExceptionIfClosed();
            return false;
        }
        Bytes bytes = wire.bytes();
        return this.inACycle2(includeMetaData, wire, bytes);
    }

    private boolean inACycle2(boolean includeMetaData, Wire wire, Bytes<?> bytes) throws EOFException {
        bytes.readLimitToCapacity();
        switch (wire.readDataHeader(includeMetaData)) {
            case NONE: {
                return false;
            }
            case META_DATA: {
                this.context.metaData(true);
                break;
            }
            case DATA: {
                this.context.metaData(false);
                break;
            }
            case EOF: {
                throw EOF_EXCEPTION;
            }
        }
        this.inACycleFound(bytes);
        return true;
    }

    private boolean inACycleCheckRep() {
        long lastSequenceAck = this.queue.lastAcknowledgedIndexReplicated();
        long index = this.index();
        return index > lastSequenceAck;
    }

    private boolean inACycleNotForward() {
        if (!this.moveToIndexInternal(this.index())) {
            try {
                if ((int)this.queue.rollCycle().toSequenceNumber(this.index()) < 0) {
                    long lastSeqNum = this.store.lastSequenceNumber(this);
                    if (lastSeqNum == -1L) {
                        this.windBackCycle(this.cycle);
                        return this.moveToIndexInternal(this.index());
                    }
                    return this.moveToIndexInternal(this.queue.rollCycle().toIndex(this.cycle, lastSeqNum));
                }
                if (!this.moveToIndexInternal(this.index() - 1L)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private void inACycleFound(@NotNull Bytes<?> bytes) {
        this.context.closeReadLimit(bytes.capacity());
        this.privateWire().readAndSetLength(bytes.readPosition());
        long end = bytes.readLimit();
        this.context.closeReadPosition(end);
    }

    private long nextIndexWithNextAvailableCycle(int cycle) {
        try {
            return this.nextIndexWithNextAvailableCycle0(cycle);
        }
        catch (MissingStoreFileException e) {
            this.queue.refreshDirectoryListing();
            return this.nextIndexWithNextAvailableCycle0(cycle);
        }
    }

    private long nextIndexWithNextAvailableCycle0(int cycle) {
        long nextIndex;
        assert (cycle != Integer.MIN_VALUE) : "cycle == Integer.MIN_VALUE";
        if (cycle > this.queue.lastCycle() || this.direction == TailerDirection.NONE) {
            return Long.MIN_VALUE;
        }
        int nextCycle = cycle + this.direction.add();
        boolean found = this.cycle(nextCycle);
        if (found) {
            nextIndex = this.nextIndexWithinFoundCycle(nextCycle);
        } else {
            try {
                int nextCycle0 = this.queue.nextCycle(this.cycle, this.direction);
                if (nextCycle0 == -1) {
                    return Long.MIN_VALUE;
                }
                nextIndex = this.nextIndexWithinFoundCycle(nextCycle0);
            }
            catch (ParseException e) {
                throw new IllegalStateException(e);
            }
        }
        if (Jvm.isResourceTracing()) {
            int nextIndexCycle = this.queue.rollCycle().toCycle(nextIndex);
            if (nextIndex != Long.MIN_VALUE && nextIndexCycle - 1 != cycle) {
                Jvm.debug().on(this.getClass(), "Rolled " + (nextIndexCycle - cycle) + " times to find the next cycle file. This can occur if your appenders have not written anything for a while, leaving the cycle files with a gap.");
            }
        }
        return nextIndex;
    }

    private long nextIndexWithinFoundCycle(int nextCycle) {
        this.state = TailerState.FOUND_IN_CYCLE;
        if (this.direction == TailerDirection.FORWARD) {
            return this.queue.rollCycle().toIndex(nextCycle, 0L);
        }
        if (this.direction == TailerDirection.BACKWARD) {
            try {
                long lastSequenceNumber0 = this.store().lastSequenceNumber(this);
                return this.queue.rollCycle().toIndex(nextCycle, lastSequenceNumber0);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        throw new IllegalStateException("direction=" + (Object)((Object)this.direction));
    }

    @Override
    public long index() {
        return this.indexValue == null ? this.index : this.indexValue.getValue();
    }

    @Override
    public int cycle() {
        return this.cycle;
    }

    @Override
    public boolean moveToIndex(long index) {
        this.throwExceptionIfClosed();
        if (this.moveToState.canReuseLastIndexMove(index, this.state, this.direction, this.queue, this.privateWire())) {
            return this.setAddress(true);
        }
        if (this.moveToState.indexIsCloseToAndAheadOfLastIndexMove(index, this.state, this.direction, this.queue)) {
            boolean found;
            long knownIndex = this.moveToState.lastMovedToIndex;
            boolean bl = found = this.store.linearScanTo(index, knownIndex, this, this.moveToState.readPositionAtLastMove) == ScanResult.FOUND;
            if (found) {
                this.index(index);
                this.moveToState.onSuccessfulScan(index, this.direction, this.privateWire().bytes().readPosition());
            }
            return this.setAddress(found);
        }
        return this.moveToIndexInternal(index);
    }

    @Override
    public boolean moveToCycle(int cycle) {
        this.throwExceptionIfClosed();
        this.moveToState.indexMoveCount++;
        ScanResult scanResult = this.moveToCycleResult0(cycle);
        this.setAddress(scanResult == ScanResult.FOUND);
        return scanResult == ScanResult.FOUND;
    }

    private boolean setAddress(boolean found) {
        Wire wire = this.privateWire();
        if (wire == null) {
            this.address = NoBytesStore.NO_PAGE;
            return false;
        }
        Bytes bytes = wire.bytes();
        this.address = found ? bytes.addressForRead(bytes.readPosition(), 4) : NoBytesStore.NO_PAGE;
        return found;
    }

    private ScanResult moveToCycleResult0(int cycle) {
        if (cycle < 0) {
            return ScanResult.NOT_REACHED;
        }
        RollCycle rollCycle = this.queue.rollCycle();
        if (!this.cycle(cycle)) {
            return ScanResult.NOT_REACHED;
        }
        long index = rollCycle.toIndex(cycle, 0L);
        this.index(index);
        this.store().moveToStartForRead(this);
        Bytes bytes = this.privateWire().bytes();
        this.state = TailerState.FOUND_IN_CYCLE;
        this.moveToState.onSuccessfulLookup(index, this.direction, bytes.readPosition());
        return ScanResult.FOUND;
    }

    private ScanResult moveToIndexResult0(long index) {
        if (index < 0L) {
            return ScanResult.NOT_REACHED;
        }
        RollCycle rollCycle = this.queue.rollCycle();
        int cycle = rollCycle.toCycle(index);
        long sequenceNumber = rollCycle.toSequenceNumber(index);
        if (!this.cycle(cycle)) {
            return ScanResult.NOT_REACHED;
        }
        this.index(index);
        ScanResult scanResult = this.store().moveToIndexForRead(this, sequenceNumber);
        switch (scanResult) {
            case FOUND: {
                Wire privateWire = this.privateWire();
                if (privateWire == null) {
                    this.state = TailerState.END_OF_CYCLE;
                    break;
                }
                this.state = TailerState.FOUND_IN_CYCLE;
                this.moveToState.onSuccessfulLookup(index, this.direction, privateWire.bytes().readPosition());
                break;
            }
            case NOT_REACHED: {
                this.state = TailerState.NOT_REACHED_IN_CYCLE;
                break;
            }
            case NOT_FOUND: {
                if (this.cycle >= this.queue.lastCycle()) break;
                this.state = TailerState.END_OF_CYCLE;
                return ScanResult.END_OF_FILE;
            }
            case END_OF_FILE: {
                this.state = TailerState.END_OF_CYCLE;
            }
        }
        return scanResult;
    }

    ScanResult moveToIndexResult(long index) {
        ScanResult scanResult = this.moveToIndexResult0(index);
        this.setAddress(scanResult == ScanResult.FOUND);
        return scanResult;
    }

    private ExcerptTailer doToStart() {
        assert (this.direction != TailerDirection.BACKWARD);
        int firstCycle = this.queue.firstCycle();
        if (firstCycle == Integer.MAX_VALUE) {
            this.state = TailerState.UNINITIALISED;
            this.address = NoBytesStore.NO_PAGE;
            return this;
        }
        if (firstCycle != this.cycle) {
            boolean found = this.cycle(firstCycle);
            if (found) {
                this.state = TailerState.FOUND_IN_CYCLE;
            } else if (this.store != null) {
                throw new MissingStoreFileException("Missing first store file cycle=" + firstCycle);
            }
        }
        this.index(this.queue.rollCycle().toIndex(this.cycle, 0L));
        this.state = TailerState.FOUND_IN_CYCLE;
        Wire wire = this.privateWire();
        if (wire != null) {
            wire.bytes().readPosition(0L);
            this.address = wire.bytes().addressForRead(0L);
        }
        return this;
    }

    @Override
    @NotNull
    public final ExcerptTailer toStart() {
        try {
            return this.doToStart();
        }
        catch (MissingStoreFileException e) {
            this.queue.refreshDirectoryListing();
            return this.doToStart();
        }
    }

    private boolean moveToIndexInternal(long index) {
        this.moveToState.indexMoveCount++;
        ScanResult scanResult = this.moveToIndexResult0(index);
        this.setAddress(scanResult == ScanResult.FOUND);
        return scanResult == ScanResult.FOUND;
    }

    private long approximateLastIndex() {
        int lastCycle = this.queue.lastCycle();
        try {
            if (lastCycle == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return this.approximateLastCycle2(lastCycle);
        }
        catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    private long approximateLastCycle2(int lastCycle) throws StreamCorruptedException {
        long sequenceNumber;
        RollCycle rollCycle = this.queue.rollCycle();
        SingleChronicleQueueStore wireStore = this.cycle == lastCycle ? this.store : this.queue.storeForCycle(lastCycle, this.queue.epoch(), false, this.store);
        this.setCycle(lastCycle);
        if (wireStore == null) {
            throw new MissingStoreFileException("Store not found for cycle " + Long.toHexString(lastCycle) + ". Probably the files were removed? queue=" + this.queue.fileAbsolutePath());
        }
        if (this.store != wireStore) {
            this.releaseStore();
            this.store = wireStore;
            this.resetWires();
        }
        if ((sequenceNumber = this.store.lastSequenceNumber(this)) == -1L) {
            long prevCycle = this.queue.firstCycle();
            while (prevCycle < (long)lastCycle) {
                --lastCycle;
                try {
                    return this.approximateLastCycle2(lastCycle);
                }
                catch (MissingStoreFileException missingStoreFileException) {
                }
            }
            return rollCycle.toIndex(lastCycle, 0L);
        }
        return rollCycle.toIndex(lastCycle, sequenceNumber);
    }

    private boolean headerNumberCheck(@NotNull AbstractWire wire) {
        wire.headNumberCheck((actual, position) -> {
            try {
                long expecting = this.store.sequenceForPosition(this, position, false);
                if (actual == expecting) {
                    return true;
                }
                Jvm.warn().on(this.getClass(), (Throwable)((Object)new AssertionError((Object)("header number check failed expecting=" + expecting + "  !=  actual=" + actual))));
                return false;
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), "", (Throwable)e);
                return false;
            }
        });
        return true;
    }

    private void resetWires() {
        WireType wireType = this.queue.wireType();
        SingleChronicleQueueStore s = this.store;
        if (s == null) {
            return;
        }
        MappedBytes bytes = s.bytes();
        bytes.disableThreadSafetyCheck(this.disableThreadSafetyCheck());
        Wire wire2 = (Wire)wireType.apply((Object)bytes);
        wire2.usePadding(s.dataVersion() > 0);
        AbstractWire wire = (AbstractWire)this.readAnywhere(wire2);
        assert (!QueueSystemProperties.CHECK_INDEX || this.headerNumberCheck(wire));
        this.context.wire(wire);
        wire.parent((Object)this);
        Wire wireForIndexOld = this.wireForIndex;
        this.wireForIndex = this.readAnywhere((Wire)wireType.apply((Object)s.bytes()));
        assert (!QueueSystemProperties.CHECK_INDEX || this.headerNumberCheck((AbstractWire)this.wireForIndex));
        assert (wire != wireForIndexOld);
        if (wireForIndexOld != null) {
            wireForIndexOld.bytes().releaseLast();
        }
    }

    @NotNull
    private Wire readAnywhere(@NotNull Wire wire) {
        Bytes bytes = wire.bytes();
        bytes.readLimitToCapacity();
        SingleChronicleQueueStore s = this.store;
        if (s != null) {
            wire.usePadding(s.dataVersion() > 0);
        }
        return wire;
    }

    @Override
    @NotNull
    public ExcerptTailer toEnd() {
        this.throwExceptionIfClosed();
        if (this.direction.equals((Object)TailerDirection.BACKWARD)) {
            return this.callOriginalToEnd();
        }
        return this.callOptimizedToEnd();
    }

    private ExcerptTailer callOptimizedToEnd() {
        try {
            return this.optimizedToEnd();
        }
        catch (MissingStoreFileException e) {
            this.queue.refreshDirectoryListing();
            return this.optimizedToEnd();
        }
    }

    @NotNull
    private ExcerptTailer callOriginalToEnd() {
        try {
            return this.originalToEnd();
        }
        catch (NotReachedException e) {
            this.queue.refreshDirectoryListing();
            try {
                return this.originalToEnd();
            }
            catch (Exception ex) {
                Jvm.warn().on(this.getClass(), "Unable to find toEnd() so winding to the start " + ex);
                return this.toStart();
            }
        }
    }

    @Override
    public ExcerptTailer striding(boolean striding) {
        this.throwExceptionIfClosedInSetter();
        this.striding = striding;
        return this;
    }

    @Override
    public boolean striding() {
        return this.striding;
    }

    @NotNull
    private ExcerptTailer optimizedToEnd() {
        RollCycle rollCycle = this.queue.rollCycle();
        int lastCycle = this.queue.lastCycle();
        try {
            Wire w;
            if (lastCycle == Integer.MIN_VALUE) {
                if (this.state() == TailerState.CYCLE_NOT_FOUND) {
                    this.state = TailerState.UNINITIALISED;
                }
                this.setAddress(this.state == TailerState.FOUND_IN_CYCLE);
                return this;
            }
            SingleChronicleQueueStore wireStore = this.queue.storeForCycle(lastCycle, this.queue.epoch(), false, this.store);
            this.setCycle(lastCycle);
            if (wireStore == null) {
                throw new MissingStoreFileException("Store not found for cycle " + Long.toHexString(lastCycle) + ". Probably the files were removed? queue=" + this.queue.fileAbsolutePath());
            }
            if (this.store != wireStore) {
                this.releaseStore();
                this.store = wireStore;
                this.resetWires();
            }
            if ((w = this.privateWire()) == null) {
                return this.callOriginalToEnd();
            }
            long sequenceNumber = wireStore.moveToEndForRead(w);
            if (sequenceNumber == -1L) {
                return this.callOriginalToEnd();
            }
            Bytes bytes = w.bytes();
            this.state = Wires.isEndOfFile((int)bytes.readVolatileInt(bytes.readPosition())) ? TailerState.END_OF_CYCLE : TailerState.FOUND_IN_CYCLE;
            this.index(rollCycle.toIndex(lastCycle, sequenceNumber));
            this.setAddress(this.state == TailerState.FOUND_IN_CYCLE);
        }
        catch (UnrecoverableTimeoutException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @NotNull
    public ExcerptTailer originalToEnd() {
        this.throwExceptionIfClosed();
        long index = this.approximateLastIndex();
        if (index == Long.MIN_VALUE) {
            if (this.state() == TailerState.CYCLE_NOT_FOUND) {
                this.state = TailerState.UNINITIALISED;
            }
            return this;
        }
        ScanResult scanResult = this.moveToIndexResult(index);
        block0 : switch (scanResult) {
            case NOT_FOUND: {
                if (this.moveToIndexResult(index - 1L) != ScanResult.FOUND) break;
                this.state = TailerState.FOUND_IN_CYCLE;
                break;
            }
            case FOUND: {
                if (this.direction != TailerDirection.FORWARD) break;
                ScanResult result = this.moveToIndexResult(++index);
                switch (result) {
                    case NOT_REACHED: {
                        throw new NotReachedException("NOT_REACHED after FOUND");
                    }
                    case FOUND: 
                    case NOT_FOUND: {
                        this.state = TailerState.FOUND_IN_CYCLE;
                        break block0;
                    }
                    case END_OF_FILE: {
                        this.state = TailerState.END_OF_CYCLE;
                        break block0;
                    }
                }
                throw new IllegalStateException("Unknown ScanResult: " + (Object)((Object)result));
            }
            case NOT_REACHED: {
                throw new NotReachedException("NOT_REACHED index: " + Long.toHexString(index));
            }
            case END_OF_FILE: {
                this.state = TailerState.END_OF_CYCLE;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ScanResult: " + (Object)((Object)scanResult));
            }
        }
        return this;
    }

    @Override
    public TailerDirection direction() {
        return this.direction;
    }

    @Override
    @NotNull
    public ExcerptTailer direction(@NotNull TailerDirection direction) {
        this.throwExceptionIfClosedInSetter();
        TailerDirection oldDirection = this.direction();
        this.direction = direction;
        if (oldDirection == TailerDirection.BACKWARD && direction == TailerDirection.FORWARD) {
            this.moveToIndexInternal(this.index());
        }
        return this;
    }

    @Override
    @NotNull
    public ChronicleQueue queue() {
        return this.queue;
    }

    void incrementIndex() {
        RollCycle rollCycle = this.queue.rollCycle();
        long index = this.index();
        if (index == -1L && this.direction == TailerDirection.FORWARD) {
            this.index0(0L);
            return;
        }
        long seq = rollCycle.toSequenceNumber(index);
        int cycle = rollCycle.toCycle(index);
        seq += (long)this.direction.add();
        switch (this.direction) {
            case NONE: {
                break;
            }
            case FORWARD: {
                if (rollCycle.toSequenceNumber(seq) >= seq) break;
                if (this.cycle != cycle + 1) {
                    this.cycle(cycle + 1);
                    Jvm.warn().on(this.getClass(), "we have run out of sequence numbers, so will start to write to the next .cq4 file, the new cycle=" + cycle);
                }
                seq = 0L;
                break;
            }
            case BACKWARD: {
                if (seq < 0L) {
                    this.windBackCycle(cycle);
                    return;
                }
                if (seq <= 0L || !this.striding) break;
                seq -= seq % (long)rollCycle.defaultIndexSpacing();
            }
        }
        this.index0(rollCycle.toIndex(cycle, seq));
    }

    private void windBackCycle(int cycle) {
        long first = this.queue.firstCycle();
        while ((long)(--cycle) >= first) {
            if (!this.tryWindBack(cycle)) continue;
            return;
        }
        this.index(this.queue.rollCycle().toIndex(cycle, -1L));
        this.state = TailerState.BEYOND_START_OF_CYCLE;
    }

    private boolean tryWindBack(int cycle) {
        long count = this.queue.exactExcerptsInCycle(cycle);
        if (count <= 0L) {
            return false;
        }
        RollCycle rollCycle = this.queue.rollCycle();
        this.moveToIndexInternal(rollCycle.toIndex(cycle, count - 1L));
        this.state = TailerState.FOUND_IN_CYCLE;
        return true;
    }

    void index0(long index) {
        if (this.indexValue == null) {
            this.index = index;
        } else {
            this.indexValue.setValue(index);
        }
    }

    void index(long index) {
        this.index0(index);
        if (this.indexAtCreation == Long.MIN_VALUE) {
            this.indexAtCreation = index;
        }
        this.moveToState.reset();
    }

    private boolean cycle(int cycle) {
        if (this.cycle == cycle && (this.state == TailerState.FOUND_IN_CYCLE || this.state == TailerState.NOT_REACHED_IN_CYCLE)) {
            return true;
        }
        SingleChronicleQueueStore nextStore = this.queue.storeForCycle(cycle, this.queue.epoch(), false, this.store);
        if (nextStore == null && this.store == null) {
            return false;
        }
        if (nextStore == null) {
            this.state = this.direction == TailerDirection.BACKWARD ? TailerState.BEYOND_START_OF_CYCLE : TailerState.CYCLE_NOT_FOUND;
            return false;
        }
        if (nextStore == this.store) {
            return true;
        }
        this.releaseStore();
        this.context.wire(null);
        this.store = nextStore;
        this.state = TailerState.FOUND_IN_CYCLE;
        this.setCycle(cycle);
        this.resetWires();
        Wire wire = this.privateWire();
        wire.parent((Object)this);
        wire.pauser((Pauser)this.queue.pauserSupplier.get());
        return true;
    }

    void releaseStore() {
        if (this.store != null) {
            this.storePool.closeStore(this.store);
            this.store = null;
        }
        this.state = TailerState.UNINITIALISED;
    }

    @Override
    public void readAfterReplicaAcknowledged(boolean readAfterReplicaAcknowledged) {
        this.throwExceptionIfClosed();
        this.readAfterReplicaAcknowledged = readAfterReplicaAcknowledged;
    }

    @Override
    public boolean readAfterReplicaAcknowledged() {
        this.throwExceptionIfClosed();
        return this.readAfterReplicaAcknowledged;
    }

    @Override
    @NotNull
    public TailerState state() {
        return this.state;
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public ExcerptTailer afterLastWritten(@NotNull ChronicleQueue queue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String extraInfo(@NotNull ExcerptTailer tailer, @NotNull VanillaMessageHistory messageHistory) {
        return String.format(". That sourceIndex was determined fom the last entry written to queue %s (message index %s, message history %s). If source queue is replicated then sourceIndex may not have been replicated yet", tailer.queue().fileAbsolutePath(), Long.toHexString(tailer.index()), WireType.TEXT.asString((Object)messageHistory));
    }

    public void setCycle(int cycle) {
        this.cycle = cycle;
    }

    int getIndexMoveCount() {
        return this.moveToState.indexMoveCount;
    }

    @Deprecated
    @NotNull
    WireStore store() {
        if (this.store == null) {
            this.setCycle(this.cycle());
        }
        return this.store;
    }

    @Override
    public File currentFile() {
        SingleChronicleQueueStore store = this.store;
        return store == null ? null : store.currentFile();
    }

    class StoreTailerContext
    extends BinaryReadDocumentContext {
        StoreTailerContext() {
            super(null);
        }

        public long index() {
            return StoreTailer.this.index();
        }

        public int sourceId() {
            return StoreTailer.this.sourceId();
        }

        public void close() {
            if (this.rollbackIfNeeded()) {
                return;
            }
            if (this.isPresent() && !this.isMetaData()) {
                StoreTailer.this.incrementIndex();
            }
            super.close();
            if (StoreTailer.this.direction == TailerDirection.FORWARD) {
                StoreTailer.this.setAddress(StoreTailer.this.context.wire() != null);
            } else if (StoreTailer.this.direction == TailerDirection.BACKWARD) {
                StoreTailer.this.setAddress(false);
            }
        }

        boolean present(boolean present) {
            this.present = present;
            return this.present;
        }

        public void wire(@Nullable AbstractWire wire) {
            if (wire == this.wire) {
                return;
            }
            AbstractWire oldWire = this.wire;
            this.wire = wire;
            if (oldWire != null) {
                oldWire.bytes().release(ReferenceOwner.INIT);
            }
        }

        public void metaData(boolean metaData) {
            this.metaData = metaData;
        }
    }

    private class Finalizer {
        private Finalizer() {
        }

        protected void finalize() throws Throwable {
            super.finalize();
            StoreTailer.this.warnAndCloseIfNotClosed();
        }
    }

    static final class MoveToState {
        private long lastMovedToIndex = Long.MIN_VALUE;
        private TailerDirection directionAtLastMoveTo = TailerDirection.NONE;
        private long readPositionAtLastMove = Long.MIN_VALUE;
        private int indexMoveCount = 0;

        MoveToState() {
        }

        void onSuccessfulLookup(long movedToIndex, TailerDirection direction, long readPosition) {
            this.lastMovedToIndex = movedToIndex;
            this.directionAtLastMoveTo = direction;
            this.readPositionAtLastMove = readPosition;
        }

        void onSuccessfulScan(long movedToIndex, TailerDirection direction, long readPosition) {
            this.lastMovedToIndex = movedToIndex;
            this.directionAtLastMoveTo = direction;
            this.readPositionAtLastMove = readPosition;
        }

        void reset() {
            this.lastMovedToIndex = Long.MIN_VALUE;
            this.directionAtLastMoveTo = TailerDirection.NONE;
            this.readPositionAtLastMove = Long.MIN_VALUE;
        }

        private boolean indexIsCloseToAndAheadOfLastIndexMove(long index, TailerState state, TailerDirection direction, ChronicleQueue queue) {
            return this.lastMovedToIndex != Long.MIN_VALUE && index - this.lastMovedToIndex < 70L && state == TailerState.FOUND_IN_CYCLE && direction == this.directionAtLastMoveTo && queue.rollCycle().toCycle(index) == queue.rollCycle().toCycle(this.lastMovedToIndex) && index > this.lastMovedToIndex;
        }

        private boolean canReuseLastIndexMove(long index, TailerState state, TailerDirection direction, ChronicleQueue queue, Wire wire) {
            return (wire == null || wire.bytes().readPosition() == this.readPositionAtLastMove) && index == this.lastMovedToIndex && index != 0L && state == TailerState.FOUND_IN_CYCLE && direction == this.directionAtLastMoveTo && queue.rollCycle().toCycle(index) == queue.rollCycle().toCycle(this.lastMovedToIndex);
        }
    }
}

