/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.channel.impl;

import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.NoDocumentContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.channel.AbstractHandler;
import net.openhft.chronicle.wire.channel.ChannelHeader;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.converter.NanoTime;

public class SubscribeQueueChannel
implements ChronicleChannel {
    private final ChronicleChannelCfg channelCfg;
    private final AbstractHandler pipeHandler;
    private final ChannelHeader headerOut;
    private final ChronicleQueue subscribeQueue;
    private final ExcerptTailer tailer;
    private long lastTestMessage;

    public SubscribeQueueChannel(ChronicleChannelCfg channelCfg, AbstractHandler pipeHandler, ChronicleQueue subscribeQueue) {
        this.channelCfg = channelCfg;
        this.pipeHandler = pipeHandler;
        this.headerOut = pipeHandler.responseHeader(null);
        this.subscribeQueue = subscribeQueue;
        this.tailer = subscribeQueue.createTailer();
    }

    public ChronicleChannelCfg channelCfg() {
        return this.channelCfg;
    }

    public ChannelHeader headerOut() {
        return this.headerOut;
    }

    public ChannelHeader headerIn() {
        return this.pipeHandler;
    }

    public void close() {
        Closeable.closeQuietly((Object[])new Object[]{this.tailer, this.subscribeQueue});
    }

    public boolean isClosed() {
        return this.subscribeQueue.isClosed();
    }

    public DocumentContext readingDocument() {
        DocumentContext dc = this.tailer.readingDocument(true);
        if (dc.isMetaData()) {
            Wire wire = dc.wire();
            long pos = wire.bytes().readPosition();
            String event = (String)wire.readEvent(String.class);
            if ("testMessage".equals(event)) {
                long testMessage;
                this.lastTestMessage = testMessage = wire.getValueIn().readLong(NanoTime.INSTANCE);
                try (DocumentContext dc2 = this.writingDocument(true);){
                    dc2.wire().write((CharSequence)"testMessage").writeLong(NanoTime.INSTANCE, testMessage);
                }
                wire.bytes().readPosition(pos);
                return dc;
            }
            dc.close();
            return this.readingDocument();
        }
        return dc;
    }

    public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        return NoDocumentContext.INSTANCE;
    }

    public DocumentContext acquireWritingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        return NoDocumentContext.INSTANCE;
    }

    public void testMessage(long now) {
    }

    public long lastTestMessage() {
        return this.lastTestMessage;
    }
}

