/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceCountedCache<K, T extends ReferenceCounted & Closeable, V, E extends Throwable>
extends AbstractCloseable {
    private final Map<K, T> cache = new LinkedHashMap<K, T>();
    private final Function<T, V> transformer;
    private final ThrowingFunction<K, T, E> creator;
    private final Runnable bgCleanup = this::bgCleanup;

    public ReferenceCountedCache(Function<T, V> transformer, ThrowingFunction<K, T, E> creator) {
        this.transformer = transformer;
        this.creator = creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    V get(@NotNull K key) throws E {
        V rv;
        this.throwExceptionIfClosed();
        Map<K, T> map = this.cache;
        synchronized (map) {
            @Nullable ReferenceCounted value = (ReferenceCounted)this.cache.get(key);
            if (value == null) {
                value = (ReferenceCounted)this.creator.apply(key);
                value.reserveTransfer(INIT, (ReferenceOwner)this);
                this.cache.put(key, value);
            }
            rv = this.transformer.apply(value);
        }
        BackgroundResourceReleaser.run((Runnable)this.bgCleanup);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performClose() {
        this.bgCleanup();
        if (!this.cache.isEmpty()) {
            Jvm.warn().on(((Object)((Object)this)).getClass(), "Cache should have been cleaned");
            Map<K, T> map = this.cache;
            synchronized (map) {
                for (ReferenceCounted value : this.cache.values()) {
                    try {
                        value.release((ReferenceOwner)this);
                    }
                    catch (Exception e) {
                        Jvm.debug().on(((Object)((Object)this)).getClass(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bgCleanup() {
        Map<K, T> map = this.cache;
        synchronized (map) {
            this.cache.entrySet().removeIf(entry -> {
                boolean noOtherReferencers;
                ReferenceCounted value = (ReferenceCounted)entry.getValue();
                boolean bl = noOtherReferencers = value.refCount() == 1;
                if (noOtherReferencers) {
                    try {
                        value.release((ReferenceOwner)this);
                        ((Closeable)value).close();
                    }
                    catch (ClosedIllegalStateException closedIllegalStateException) {
                        // empty catch block
                    }
                }
                return noOtherReferencers;
            });
        }
    }
}

