/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.function.Consumer;
import net.openhft.chronicle.queue.reader.ChronicleReader;
import net.openhft.chronicle.wire.WireType;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class ChronicleReaderMain {
    public static void main(@NotNull String[] args) {
        new ChronicleReaderMain().run(args);
    }

    public static void addOption(Options options, String opt, String argName, boolean hasArg, String description, boolean isRequired) {
        Option option = new Option(opt, hasArg, description);
        option.setArgName(argName);
        option.setRequired(isRequired);
        options.addOption(option);
    }

    protected void run(@NotNull String[] args) {
        Options options = this.options();
        CommandLine commandLine = this.parseCommandLine(args, options);
        ChronicleReader chronicleReader = this.chronicleReader();
        this.configureReader(chronicleReader, commandLine);
        chronicleReader.execute();
    }

    protected ChronicleReader chronicleReader() {
        return new ChronicleReader();
    }

    protected CommandLine parseCommandLine(@NotNull String[] args, Options options) {
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
            if (commandLine.hasOption('h')) {
                this.printHelpAndExit(options, 0);
            }
            if (!commandLine.hasOption('d')) {
                System.out.println("Please specify the directory with -d\n");
                this.printHelpAndExit(options, 1);
            }
        }
        catch (ParseException e) {
            this.printHelpAndExit(options, 1);
        }
        return commandLine;
    }

    protected void printHelpAndExit(Options options, int status) {
        PrintWriter writer = new PrintWriter(System.out);
        new HelpFormatter().printHelp(writer, 180, this.getClass().getSimpleName(), null, options, 1, 3, null, true);
        writer.flush();
        System.exit(status);
    }

    protected void configureReader(ChronicleReader chronicleReader, CommandLine commandLine) {
        Consumer<String> messageSink = commandLine.hasOption('l') ? s -> System.out.println(s.replaceAll("\n", "")) : System.out::println;
        chronicleReader.withMessageSink(messageSink).withBasePath(Paths.get(commandLine.getOptionValue('d'), new String[0]));
        if (commandLine.hasOption('i')) {
            Arrays.stream(commandLine.getOptionValues('i')).forEach(chronicleReader::withInclusionRegex);
        }
        if (commandLine.hasOption('e')) {
            Arrays.stream(commandLine.getOptionValues('e')).forEach(chronicleReader::withExclusionRegex);
        }
        if (commandLine.hasOption('f')) {
            chronicleReader.tail();
        }
        if (commandLine.hasOption('m')) {
            chronicleReader.historyRecords(Long.parseLong(commandLine.getOptionValue('m')));
        }
        if (commandLine.hasOption('n')) {
            chronicleReader.withStartIndex(Long.decode(commandLine.getOptionValue('n')));
        }
        if (commandLine.hasOption('r')) {
            chronicleReader.asMethodReader(commandLine.getOptionValue('r'));
        }
        if (commandLine.hasOption('w')) {
            chronicleReader.withWireType(WireType.valueOf((String)commandLine.getOptionValue('w')));
        }
        if (commandLine.hasOption('s')) {
            chronicleReader.suppressDisplayIndex();
        }
    }

    @NotNull
    protected Options options() {
        Options options = new Options();
        ChronicleReaderMain.addOption(options, "d", "directory", true, "Directory containing chronicle queue files", false);
        ChronicleReaderMain.addOption(options, "i", "include-regex", true, "Display records containing this regular expression", false);
        ChronicleReaderMain.addOption(options, "e", "exclude-regex", true, "Do not display records containing this regular expression", false);
        ChronicleReaderMain.addOption(options, "f", "follow", false, "Tail behaviour - wait for new records to arrive", false);
        ChronicleReaderMain.addOption(options, "m", "max-history", true, "Show this many records from the end of the data set", false);
        ChronicleReaderMain.addOption(options, "n", "from-index", true, "Start reading from this index (e.g. 0x123ABE)", false);
        ChronicleReaderMain.addOption(options, "r", "as-method-reader", false, "Use when reading from a queue generated using a MethodWriter", false);
        ChronicleReaderMain.addOption(options, "w", "wire-type", true, "Control output i.e. JSON", false);
        ChronicleReaderMain.addOption(options, "s", "suppress-index", false, "Display index", false);
        ChronicleReaderMain.addOption(options, "l", "single-line", false, "Squash each output message into a single line", false);
        ChronicleReaderMain.addOption(options, "h", "help-message", false, "Print this help and exit", false);
        return options;
    }
}

