/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.RollCycle;
import org.jetbrains.annotations.NotNull;

public enum RollCycles implements RollCycle
{
    TEST_SECONDLY("yyyyMMdd-HHmmss", 1000, 32768, 4),
    MINUTELY("yyyyMMdd-HHmm", 60000, 2048, 16),
    TEST_HOURLY("yyyyMMdd-HH", 3600000, 16, 4),
    HOURLY("yyyyMMdd-HH", 3600000, 4096, 16),
    LARGE_HOURLY("yyyyMMdd-HH", 3600000, 8192, 64),
    LARGE_HOURLY_SPARSE("yyyyMMdd-HH", 3600000, 4096, 1024),
    LARGE_HOURLY_XSPARSE("yyyyMMdd-HH", 3600000, 2048, 0x100000),
    TEST_DAILY("yyyyMMdd", 86400000, 8, 1),
    TEST2_DAILY("yyyyMMdd", 86400000, 16, 2),
    TEST4_DAILY("yyyyMMdd", 86400000, 32, 4),
    SMALL_DAILY("yyyyMMdd", 86400000, 8192, 8),
    DAILY("yyyyMMdd", 86400000, 8192, 64),
    LARGE_DAILY("yyyyMMdd", 86400000, 32768, 128),
    XLARGE_DAILY("yyyyMMdd", 86400000, 131072, 256),
    HUGE_DAILY("yyyyMMdd", 86400000, 524288, 1024),
    HUGE_DAILY_XSPARSE("yyyyMMdd", 86400000, 16384, 0x100000);

    public static final RollCycles[] VALUES;
    final String format;
    final int length;
    final int cycleShift;
    final int indexCount;
    final int indexSpacing;
    final long sequenceMask;

    private RollCycles(String format, int length, int indexCount, int indexSpacing) {
        this.format = format;
        this.length = length;
        this.indexCount = Maths.nextPower2((int)indexCount, (int)8);
        this.indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        this.cycleShift = Math.max(32, Maths.intLog2((long)indexCount) * 2 + Maths.intLog2((long)indexSpacing));
        this.sequenceMask = (1L << this.cycleShift) - 1L;
    }

    public static void main(String[] args) {
        for (RollCycles r : RollCycles.values()) {
            System.out.println(r + ": cycleShift=" + r.cycleShift + " sequenceMask=" + Long.toHexString(r.sequenceMask) + " format=" + r.format + " indexSpacing=" + r.indexSpacing);
        }
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int defaultIndexCount() {
        return this.indexCount;
    }

    @Override
    public int defaultIndexSpacing() {
        return this.indexSpacing;
    }

    @Override
    public int current(@NotNull TimeProvider time, long epoch) {
        return (int)((time.currentTimeMillis() - epoch) / (long)this.length());
    }

    @Override
    public long toIndex(int cycle, long sequenceNumber) {
        return ((long)cycle << this.cycleShift) + (sequenceNumber & this.sequenceMask);
    }

    @Override
    public long toSequenceNumber(long index) {
        return index & this.sequenceMask;
    }

    @Override
    public int toCycle(long index) {
        return Maths.toUInt31((long)(index >> this.cycleShift));
    }

    static {
        VALUES = RollCycles.values();
    }
}

