/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.Objects;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.queue.impl.single.MetaDataField;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class SCQMeta
implements Metadata {
    @NotNull
    private SCQRoll roll;
    private int deltaCheckpointInterval;
    private int sourceId;

    @UsedViaReflection
    SCQMeta(@NotNull WireIn wire) {
        this.roll = (SCQRoll)Objects.requireNonNull(wire.read((WireKey)MetaDataField.roll).typedMarshallable());
        this.deltaCheckpointInterval = wire.bytes().readRemaining() > 0L ? wire.read((WireKey)MetaDataField.deltaCheckpointInterval).int32() : -1;
        this.sourceId = wire.bytes().readRemaining() > 0L ? wire.read((WireKey)MetaDataField.sourceId).int32() : 0;
    }

    SCQMeta(@NotNull SCQRoll roll, int deltaCheckpointInterval, int sourceId) {
        this.roll = roll;
        this.deltaCheckpointInterval = deltaCheckpointInterval;
        this.sourceId = sourceId;
    }

    @NotNull
    public SCQRoll roll() {
        return this.roll;
    }

    public int deltaCheckpointInterval() {
        return this.deltaCheckpointInterval;
    }

    public int sourceId() {
        return this.sourceId;
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)MetaDataField.roll).typedMarshallable((WriteMarshallable)this.roll).write((WireKey)MetaDataField.deltaCheckpointInterval).int32(this.deltaCheckpointInterval).write((WireKey)MetaDataField.sourceId).int32(this.sourceId);
    }

    @Override
    public <T extends Metadata> void overrideFrom(T metadata) {
        if (!(metadata instanceof SCQMeta)) {
            throw new IllegalStateException("Expected SCQMeta, got " + metadata.getClass());
        }
        SCQMeta other = (SCQMeta)metadata;
        SCQRoll roll = other.roll;
        if (roll.epoch() != this.roll.epoch()) {
            Jvm.warn().on(this.getClass(), "Overriding roll epoch from existing metadata, was " + this.roll.epoch() + ", overriding to " + roll.epoch());
            this.roll.epoch(roll.epoch());
        }
        if (roll.length() != this.roll.length()) {
            Jvm.warn().on(this.getClass(), "Overriding roll length from existing metadata, was " + this.roll.length() + ", overriding to " + roll.length());
            this.roll.length(roll.length());
            this.roll.format(roll.format());
        }
        if (roll.rollTime() != null && !Objects.equals(roll.rollTime(), this.roll.rollTime())) {
            Jvm.warn().on(this.getClass(), "Overriding roll time from existing metadata, was " + this.roll.rollTime() + ", overriding to " + roll.rollTime());
            this.roll.rollTime(roll.rollTime());
        }
        if (roll.rollTimeZone() != null && !Objects.equals(roll.rollTimeZone(), this.roll.rollTimeZone())) {
            Jvm.warn().on(this.getClass(), "Overriding roll time zone from existing metadata, was " + this.roll.rollTimeZone() + ", overriding to " + roll.rollTimeZone());
            this.roll.rollTimeZone(roll.rollTimeZone());
        }
        if (other.sourceId != 0 && this.sourceId != 0 && other.sourceId != this.sourceId) {
            Jvm.warn().on(this.getClass(), "inconsistency with of source ids, existing sourceid=" + other.sourceId + ", requested sourceid=" + this.sourceId);
        }
    }
}

