/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.TSQueueLock;
import net.openhft.chronicle.queue.impl.single.TableStoreWriteLock;
import net.openhft.chronicle.queue.impl.table.AbstractTSQueueLock;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import net.openhft.chronicle.threads.BusyTimedPauser;
import org.jetbrains.annotations.NotNull;

public class QueueUnlockMain {
    public static void main(String[] args) {
        QueueUnlockMain.unlock(args[0]);
    }

    private static void unlock(@NotNull String dir) {
        File storeFilePath;
        File path = new File(dir);
        if (!path.isDirectory()) {
            System.err.println("Path argument must be a queue directory");
            System.exit(1);
        }
        if (!(storeFilePath = new File(path, "metadata.cq4t")).exists()) {
            System.err.println("Metadata file not found, nothing to unlock");
            System.exit(0);
        }
        TableStore<Metadata.NoMeta> store = SingleTableBuilder.binary(storeFilePath, Metadata.NoMeta.INSTANCE).readOnly(false).validateMetadata(false).build();
        TSQueueLock queueLock = new TSQueueLock(store, BusyTimedPauser::new, 0L);
        TableStoreWriteLock writeLock = new TableStoreWriteLock(store, BusyTimedPauser::new, 0L);
        QueueUnlockMain.forceUnlock(queueLock);
        QueueUnlockMain.forceUnlock(writeLock);
        System.out.println("Done");
    }

    private static void forceUnlock(AbstractTSQueueLock lock) {
        try {
            Method forceUnlock = AbstractTSQueueLock.class.getDeclaredMethod("forceUnlock", new Class[0]);
            Jvm.setAccessible((AccessibleObject)forceUnlock);
            forceUnlock.invoke((Object)lock, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    static {
        SingleChronicleQueueBuilder.addAliases();
    }
}

