/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public class SimpleStoreRecovery
extends AbstractMarshallable
implements StoreRecovery {
    @Override
    public long recoverAndWriteHeader(@NotNull Wire wire, long timeoutMS, @NotNull LongValue lastPosition, Sequence sequence) throws UnrecoverableTimeoutException {
        Jvm.warn().on(this.getClass(), "Clearing an incomplete header so a header can be written");
        wire.bytes().writeInt(0);
        wire.pauser().reset();
        try {
            return wire.writeHeaderOfUnknownLength(timeoutMS, TimeUnit.MILLISECONDS, lastPosition, sequence);
        }
        catch (EOFException | TimeoutException e) {
            throw new UnrecoverableTimeoutException(e);
        }
    }
}

