/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.CycleCalculator;
import net.openhft.chronicle.queue.DefaultCycleCalculator;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.WireStoreFactory;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.chronicle.threads.TimeoutPauser;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChronicleQueueBuilder<B extends ChronicleQueueBuilder, Q extends ChronicleQueue>
implements ChronicleQueueBuilder<B, Q>,
Marshallable {
    private static final String MESSAGE = "Only supported in Chronicle Queue Enterprise";
    protected File path;
    protected Long blockSize;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractChronicleQueueBuilder.class);
    public static final String DEFAULT_ROLL_CYCLE_PROPERTY = "net.openhft.queue.builder.defaultRollCycle";
    private static final String DEFAULT_EPOCH_PROPERTY = "net.openhft.queue.builder.defaultEpoch";
    protected WireType wireType;
    protected RollCycle rollCycle;
    protected Long epoch;
    public BufferMode writeBufferMode;
    public BufferMode readBufferMode;
    private Boolean enableRingBufferMonitoring;
    @Nullable
    protected EventLoop eventLoop;
    protected CycleCalculator cycleCalculator;
    private Long bufferCapacity;
    private Integer indexSpacing;
    private Integer indexCount;
    @NotNull
    private Consumer<BytesRingBufferStats> onRingBufferStats = NoBytesRingBufferStats.NONE;
    private TimeProvider timeProvider = SystemTimeProvider.INSTANCE;
    private Supplier<TimingPauser> pauserSupplier = () -> new TimeoutPauser(500000);
    private Long timeoutMS;
    protected WireStoreFactory storeFactory;
    private Integer sourceId;
    private StoreRecoveryFactory recoverySupplier = TimedStoreRecovery.FACTORY;
    private StoreFileListener storeFileListener;
    protected Boolean readOnly;
    private Boolean strongAppenders;

    protected AbstractChronicleQueueBuilder() {
    }

    @Override
    public boolean hasBlockSize() {
        return this.blockSize != null;
    }

    public AbstractChronicleQueueBuilder(File path) {
        this.path = path;
    }

    private RollCycle loadDefaultRollCycle() {
        if (null == System.getProperty(DEFAULT_ROLL_CYCLE_PROPERTY)) {
            return RollCycles.DAILY;
        }
        String rollCycleProperty = System.getProperty(DEFAULT_ROLL_CYCLE_PROPERTY);
        String[] rollCyclePropertyParts = rollCycleProperty.split(":");
        if (rollCyclePropertyParts.length > 0) {
            try {
                Class<?> rollCycleClass = Class.forName(rollCyclePropertyParts[0]);
                if (Enum.class.isAssignableFrom(rollCycleClass)) {
                    if (rollCyclePropertyParts.length < 2) {
                        LOGGER.warn("Default roll cycle configured as enum, but enum value not specified: " + rollCycleProperty);
                    } else {
                        Class<?> eClass = rollCycleClass;
                        Enum instance = ObjectUtils.valueOf(eClass, (String)rollCyclePropertyParts[1]);
                        if (instance instanceof RollCycle) {
                            return (RollCycle)((Object)instance);
                        }
                        LOGGER.warn("Configured default rollcycle is not a subclass of RollCycle");
                    }
                } else {
                    Object instance = ObjectUtils.newInstance(rollCycleClass);
                    if (instance instanceof RollCycle) {
                        return (RollCycle)instance;
                    }
                    LOGGER.warn("Configured default rollcycle is not a subclass of RollCycle");
                }
            }
            catch (ClassNotFoundException ignored) {
                LOGGER.warn("Default roll cycle class: " + rollCyclePropertyParts[0] + " was not found");
            }
        }
        return RollCycles.DAILY;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger((String)this.getClass().getName());
    }

    @Override
    @NotNull
    public CycleCalculator cycleCalculator() {
        return this.cycleCalculator == null ? DefaultCycleCalculator.INSTANCE : this.cycleCalculator;
    }

    @Override
    public B path(File path) {
        this.path = path;
        return (B)this;
    }

    @Override
    public B rollTime(@NotNull LocalTime time, ZoneId zoneId) {
        this.epoch = TimeUnit.SECONDS.toMillis(time.toSecondOfDay());
        return (B)this;
    }

    @Override
    @NotNull
    public B onRingBufferStats(@NotNull Consumer<BytesRingBufferStats> onRingBufferStats) {
        this.onRingBufferStats = onRingBufferStats;
        return (B)this;
    }

    @Override
    @NotNull
    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats == null ? NoBytesRingBufferStats.NONE : this.onRingBufferStats;
    }

    @Override
    @NotNull
    public File path() {
        return this.path;
    }

    @Override
    public B blockSize(long blockSize) {
        this.blockSize = Math.max(65536L, blockSize);
        return (B)this;
    }

    @Override
    @NotNull
    public B blockSize(int blockSize) {
        return this.blockSize((long)blockSize);
    }

    @Override
    public long blockSize() {
        long bs = this.blockSize == null ? (OS.is64Bit() ? 0x4000000L : 65536L) : this.blockSize;
        long minSize = Math.max(65536L, 32L * (long)this.indexCount());
        return Math.max(minSize, bs);
    }

    @Override
    @NotNull
    public B wireType(@NotNull WireType wireType) {
        this.wireType = wireType;
        return (B)this;
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType == null ? WireType.BINARY_LIGHT : this.wireType;
    }

    @Override
    @NotNull
    public B rollCycle(@NotNull RollCycle rollCycle) {
        this.rollCycle = rollCycle;
        return (B)this;
    }

    @Override
    public long bufferCapacity() {
        long bufferCapacity = this.bufferCapacity == null ? 0L : this.bufferCapacity;
        Long blockSize = this.blockSize();
        return Math.min(blockSize / 4L, bufferCapacity == -1L ? 0x200000L : Math.max(4096L, bufferCapacity));
    }

    @Override
    @NotNull
    public B bufferCapacity(long bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
        return (B)this;
    }

    @Override
    @NotNull
    public B epoch(long epoch) {
        this.epoch = epoch;
        return (B)this;
    }

    @Override
    public long epoch() {
        return this.epoch == null ? Long.getLong(DEFAULT_EPOCH_PROPERTY, 0L) : this.epoch;
    }

    @Override
    @NotNull
    public RollCycle rollCycle() {
        RollCycle defaultRollCycle = this.loadDefaultRollCycle();
        return this.rollCycle == null ? defaultRollCycle : this.rollCycle;
    }

    @Override
    @Deprecated
    @NotNull
    public B buffered(boolean isBuffered) {
        this.writeBufferMode = isBuffered ? BufferMode.Asynchronous : BufferMode.None;
        return (B)this;
    }

    @Override
    @Deprecated
    public boolean buffered() {
        return this.writeBufferMode == BufferMode.Asynchronous;
    }

    @Override
    @NotNull
    public BufferMode writeBufferMode() {
        return this.wireType() == WireType.DELTA_BINARY ? BufferMode.None : (this.writeBufferMode == null ? BufferMode.None : this.writeBufferMode);
    }

    @Override
    public B writeBufferMode(BufferMode writeBufferMode) {
        this.writeBufferMode = writeBufferMode;
        return (B)this;
    }

    @Override
    public BufferMode readBufferMode() {
        return this.readBufferMode == null ? BufferMode.None : this.readBufferMode;
    }

    @Override
    public B readBufferMode(BufferMode readBufferMode) {
        this.readBufferMode = readBufferMode;
        return (B)this;
    }

    @Override
    @NotNull
    public EventLoop eventLoop() {
        return this.eventLoop == null ? new EventGroup(true) : this.eventLoop;
    }

    @Override
    @NotNull
    public B eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        return (B)this;
    }

    public boolean enableRingBufferMonitoring() {
        return this.enableRingBufferMonitoring == null ? false : this.enableRingBufferMonitoring;
    }

    public B enableRingBufferMonitoring(boolean enableRingBufferMonitoring) {
        this.enableRingBufferMonitoring = enableRingBufferMonitoring;
        return (B)this;
    }

    @Override
    public B indexCount(int indexCount) {
        this.indexCount = Maths.nextPower2((int)indexCount, (int)8);
        return (B)this;
    }

    @Override
    public int indexCount() {
        return this.indexCount == null || this.indexCount <= 0 ? this.rollCycle().defaultIndexCount() : this.indexCount.intValue();
    }

    @Override
    public B indexSpacing(int indexSpacing) {
        this.indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        return (B)this;
    }

    @Override
    public int indexSpacing() {
        return this.indexSpacing == null || this.indexSpacing <= 0 ? this.rollCycle().defaultIndexSpacing() : this.indexSpacing.intValue();
    }

    public TimeProvider timeProvider() {
        return this.timeProvider == null ? SystemTimeProvider.INSTANCE : this.timeProvider;
    }

    public B timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return (B)this;
    }

    public Supplier<TimingPauser> pauserSupplier() {
        return this.pauserSupplier;
    }

    @Override
    public B pauserSupplier(Supplier<TimingPauser> pauser) {
        this.pauserSupplier = pauser;
        return (B)this;
    }

    public B timeoutMS(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return (B)this;
    }

    public long timeoutMS() {
        return this.timeoutMS == null ? 10000L : this.timeoutMS;
    }

    @Override
    public B storeFileListener(StoreFileListener storeFileListener) {
        this.storeFileListener = storeFileListener;
        return (B)this;
    }

    @Override
    public StoreFileListener storeFileListener() {
        return this.storeFileListener == null ? (cycle, file) -> {
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), "File released " + file);
            }
        } : this.storeFileListener;
    }

    @Override
    public boolean hasPretouchIntervalMillis() {
        return false;
    }

    public B sourceId(int sourceId) {
        if (sourceId < 0) {
            throw new IllegalArgumentException("Invalid source Id, must be positive");
        }
        this.sourceId = sourceId;
        return (B)this;
    }

    public int sourceId() {
        return this.sourceId == null ? 0 : this.sourceId;
    }

    public StoreRecoveryFactory recoverySupplier() {
        return this.recoverySupplier;
    }

    public B recoverySupplier(StoreRecoveryFactory recoverySupplier) {
        this.recoverySupplier = recoverySupplier;
        return (B)this;
    }

    @Override
    public boolean readOnly() {
        return this.readOnly == Boolean.TRUE && !OS.isWindows();
    }

    @Override
    public B readOnly(boolean readOnly) {
        if (OS.isWindows() && readOnly) {
            Jvm.warn().on(AbstractChronicleQueueBuilder.class, "Read-only mode is not supported on Windows\u00ae platforms, defaulting to read/write.");
        } else {
            this.readOnly = readOnly;
        }
        return (B)this;
    }

    @NotNull
    public AbstractChronicleQueueBuilder encryptSupplier(Supplier<Cipher> encryptSupplier) {
        throw new UnsupportedOperationException(MESSAGE);
    }

    @NotNull
    public AbstractChronicleQueueBuilder decryptSupplier(Supplier<Cipher> decryptSupplier) {
        throw new UnsupportedOperationException(MESSAGE);
    }

    protected void preBuild() {
        this.initializeMetadata();
    }

    protected abstract void initializeMetadata();

    @Override
    public B strongAppenders(boolean strongAppenders) {
        this.strongAppenders = strongAppenders;
        return (B)this;
    }

    @Override
    public boolean strongAppenders() {
        return this.strongAppenders == Boolean.TRUE;
    }

    @Override
    public B clone() {
        try {
            return (B)((ChronicleQueueBuilder)super.clone());
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static enum NoBytesRingBufferStats implements Consumer<BytesRingBufferStats>
    {
        NONE;


        @Override
        public void accept(BytesRingBufferStats bytesRingBufferStats) {
        }
    }
}

