/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.Arrays;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;

public final class ReferenceTracker {
    private static final int CACHE_SIZE = 64;
    private static final int INDEX_MASK = 63;
    private final TableStore<?> backingStore;
    private final ReverseCharSequenceIntegerEncoder encoder = new ReverseCharSequenceIntegerEncoder();
    private final CachedLongValue[] cache = new CachedLongValue[64];

    public ReferenceTracker(TableStore<?> backingStore) {
        this.backingStore = backingStore;
        Arrays.setAll(this.cache, i -> new CachedLongValue());
    }

    private static int mask(int cycle) {
        return cycle & 0x3F;
    }

    public synchronized void acquired(int cycle) {
        this.acquireLongValue(cycle).addAtomicValue(1L);
    }

    public synchronized void released(int cycle) {
        LongValue longValue = this.acquireLongValue(cycle);
        if (longValue != null) {
            longValue.addAtomicValue(-1L);
        }
    }

    public long referenceCount(int cycle) {
        return this.acquireLongValue(cycle).getVolatileValue();
    }

    private LongValue acquireLongValue(int cycle) {
        CachedLongValue cachedValue = this.cache[ReferenceTracker.mask(cycle)];
        if (cachedValue.cycle != cycle) {
            this.encoder.encode(cycle);
            cachedValue.cycle = cycle;
            cachedValue.value = this.backingStore.doWithExclusiveLock(this::safelyGetLongValue);
            if (cachedValue.value.getVolatileValue() == Long.MIN_VALUE) {
                cachedValue.value.compareAndSwapValue(Long.MIN_VALUE, 0L);
            }
        }
        if (cachedValue.value == null) {
            Jvm.warn().on(this.getClass(), "cachedValue.value was null");
        }
        return cachedValue.value;
    }

    private LongValue safelyGetLongValue(TableStore tableStore) {
        return tableStore.acquireValueFor(this.encoder);
    }

    static final class ReverseCharSequenceIntegerEncoder
    implements CharSequence {
        private final char[] data = new char[Integer.toString(Integer.MAX_VALUE).length()];
        private int length;
        private int indexOffset;

        ReverseCharSequenceIntegerEncoder() {
        }

        private static void validate(int value) {
            if (value < 0) {
                throw new UnsupportedOperationException();
            }
        }

        void encode(int value) {
            ReverseCharSequenceIntegerEncoder.validate(value);
            this.length = 0;
            while (value != 0) {
                this.data[this.length++] = (char)(48 + value % 10);
                value /= 10;
            }
            this.handleZero();
            this.indexOffset = this.length - 1;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.data[this.indexOffset - index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }

        private void handleZero() {
            if (this.length == 0) {
                this.length = 1;
                this.data[0] = 48;
            }
        }
    }

    private static final class CachedLongValue {
        private int cycle = -1;
        private LongValue value;

        private CachedLongValue() {
        }
    }
}

