/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.text.ParseException;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.annotation.Nullable;
import net.openhft.chronicle.queue.RollDetails;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStoreSupplier;
import org.jetbrains.annotations.NotNull;

public class WireStorePool {
    @NotNull
    private final WireStoreSupplier supplier;
    @NotNull
    private final Map<RollDetails, WireStore> stores;
    private final StoreFileListener storeFileListener;

    private WireStorePool(@NotNull WireStoreSupplier supplier, StoreFileListener storeFileListener) {
        this.supplier = supplier;
        this.storeFileListener = storeFileListener;
        this.stores = new ConcurrentHashMap<RollDetails, WireStore>();
    }

    @NotNull
    public static WireStorePool withSupplier(@NotNull WireStoreSupplier supplier, StoreFileListener storeFileListener) {
        return new WireStorePool(supplier, storeFileListener);
    }

    public void close() {
        this.stores.entrySet().forEach(e -> ((WireStore)e.getValue()).release());
    }

    @Nullable
    public synchronized WireStore acquire(int cycle, long epoch, boolean createIfAbsent) {
        RollDetails rollDetails = new RollDetails(cycle, epoch);
        WireStore store = this.stores.get((Object)rollDetails);
        if (store != null && store.tryReserve()) {
            return store;
        }
        store = this.supplier.acquire(cycle, createIfAbsent);
        if (store != null) {
            this.stores.put(rollDetails, store);
            this.storeFileListener.onAcquired(cycle, store.file());
        }
        return store;
    }

    public int nextCycle(int currentCycle, @NotNull TailerDirection direction) throws ParseException {
        return this.supplier.nextCycle(currentCycle, direction);
    }

    public synchronized void release(@NotNull WireStore store) {
        store.release();
        if (store.refCount() <= 0L) {
            for (Map.Entry<RollDetails, WireStore> entry : this.stores.entrySet()) {
                if (entry.getValue() != store) continue;
                this.stores.remove((Object)entry.getKey());
                this.storeFileListener.onReleased(entry.getKey().cycle(), store.file());
                break;
            }
        }
    }

    public NavigableSet<Long> listCyclesBetween(int lowerCycle, int upperCycle) throws ParseException {
        return this.supplier.cycles(lowerCycle, upperCycle);
    }
}

