/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.Optional;
import java.util.function.LongSupplier;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;

class PretoucherState {
    private static final int HEAD_ROOM = 0x100000;
    private final LongSupplier posSupplier;
    private final int minHeadRoom;
    private long lastTouchedPage = 0L;
    private long lastTouchedPos = 0L;
    private int lastBytesHashcode = -1;
    private long averageMove = 0L;

    public PretoucherState(LongSupplier posSupplier) {
        this(posSupplier, 0x100000);
    }

    public PretoucherState(LongSupplier posSupplier, int minHeadRoom) {
        this.posSupplier = posSupplier;
        this.minHeadRoom = minHeadRoom;
    }

    static File getFile(MappedBytes bytes) {
        return Optional.ofNullable(bytes).map(MappedBytes::mappedFile).map(MappedFile::file).orElse(new File("none"));
    }

    public void pretouch(MappedBytes bytes) {
        long pos = this.posSupplier.getAsLong();
        if (this.lastBytesHashcode != System.identityHashCode(bytes)) {
            this.lastTouchedPage = pos - pos % (long)OS.pageSize();
            this.lastTouchedPos = pos;
            this.lastBytesHashcode = System.identityHashCode(bytes);
            String message = PretoucherState.getFile(bytes) + " - Reset pretoucher to pos " + pos + " as the underlying MappedBytes changed.";
            this.debug(message);
        } else {
            this.averageMove = (pos - this.lastTouchedPage) / 4L + this.averageMove * 3L / 4L;
            long neededHeadRoom = Math.max((long)this.minHeadRoom, this.averageMove * 4L);
            long neededEnd = pos + neededHeadRoom;
            if (this.lastTouchedPage < neededEnd) {
                Thread thread = Thread.currentThread();
                int count = 0;
                int pretouch = 0;
                while (this.lastTouchedPage < neededEnd && !thread.isInterrupted()) {
                    if (this.touchPage(bytes, this.lastTouchedPage)) {
                        ++pretouch;
                    }
                    ++count;
                    this.lastTouchedPage += (long)OS.pageSize();
                }
                if (pretouch < count) {
                    this.debug("pretouch for only " + pretouch + " of " + count);
                }
                long pos2 = this.posSupplier.getAsLong();
                if (Jvm.isDebugEnabled(this.getClass())) {
                    String message = PretoucherState.getFile(bytes) + ": Advanced " + (pos - this.lastTouchedPos) / 1024L + " KB between pretouch() and " + (pos2 - pos) / 1024L + " KB while mapping of " + neededHeadRoom / 1024L + " KB.";
                    this.debug(message);
                }
                this.lastTouchedPos = pos;
            }
        }
    }

    protected void debug(String message) {
        Jvm.debug().on(this.getClass(), message);
    }

    protected boolean touchPage(MappedBytes bytes, long offset) {
        return bytes.readVolatileLong(offset) == 0L;
    }
}

