/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.wire.WireDumper;

public class DumpQueueMain {
    static final String FILE = System.getProperty("file");

    public static void main(String[] args) throws FileNotFoundException {
        DumpQueueMain.dump(args[0]);
    }

    public static void dump(String path) throws FileNotFoundException {
        File path2 = new File(path);
        PrintStream out = FILE == null ? System.out : new PrintStream(new File(FILE));
        long upperLimit = Long.MAX_VALUE;
        DumpQueueMain.dump(path2, out, upperLimit);
    }

    public static void dump(File path, PrintStream out, long upperLimit) {
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            if (files == null) {
                System.err.println("Directory not found " + path);
            }
            for (File file : files) {
                DumpQueueMain.dumpFile(file, out, upperLimit);
            }
        } else {
            DumpQueueMain.dumpFile(path, out, upperLimit);
        }
    }

    public static void dumpFile(File file, PrintStream out, long upperLimit) {
        if (file.getName().endsWith(".cq4")) {
            try (MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)0x400000L);){
                bytes.readLimit(bytes.realCapacity());
                StringBuilder sb = new StringBuilder();
                WireDumper dumper = WireDumper.of((Bytes)bytes);
                while (bytes.readRemaining() >= 4L) {
                    sb.setLength(0);
                    boolean last = dumper.dumpOne(sb);
                    out.println(sb);
                    if (last) {
                        break;
                    }
                    if (bytes.readPosition() <= upperLimit) continue;
                    out.println("# limit reached.");
                    return;
                }
            }
            catch (IOException ioe) {
                System.err.println("Failed to read " + file + " " + ioe);
            }
        }
    }
}

