/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.StreamCorruptedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

class SCQIndexing
implements Demarshallable,
WriteMarshallable,
Closeable {
    private final int indexCount;
    private final int indexCountBits;
    private final int indexSpacing;
    private final int indexSpacingBits;
    private final LongValue index2Index;
    private final LongValue nextEntryToIndex;
    private final ThreadLocal<LongArrayValues> index2indexArray;
    private final ThreadLocal<LongArrayValues> indexArray;
    private final WriteMarshallable index2IndexTemplate;
    private final WriteMarshallable indexTemplate;
    LongValue writePosition;

    @UsedViaReflection
    private SCQIndexing(@NotNull WireIn wire) {
        this(wire.read((WireKey)IndexingFields.indexCount).int32(), wire.read((WireKey)IndexingFields.indexSpacing).int32(), wire.read((WireKey)IndexingFields.index2Index).int64ForBinding(wire.newLongReference()), wire.read((WireKey)IndexingFields.lastIndex).int64ForBinding(wire.newLongReference()), () -> ((WireIn)wire).newLongArrayReference());
    }

    SCQIndexing(@NotNull WireType wireType, int indexCount, int indexSpacing) {
        this(indexCount, indexSpacing, (LongValue)wireType.newLongReference().get(), (LongValue)wireType.newLongReference().get(), wireType.newLongArrayReference());
    }

    public SCQIndexing(int indexCount, int indexSpacing, LongValue index2Index, LongValue nextEntryToIndex, Supplier<LongArrayValues> longArraySupplier) {
        this.indexCount = indexCount;
        this.indexCountBits = Maths.intLog2((long)indexCount);
        this.indexSpacing = indexSpacing;
        this.indexSpacingBits = Maths.intLog2((long)indexSpacing);
        this.index2Index = index2Index;
        this.nextEntryToIndex = nextEntryToIndex;
        this.index2indexArray = ThreadLocal.withInitial(longArraySupplier);
        this.indexArray = ThreadLocal.withInitial(longArraySupplier);
        this.index2IndexTemplate = w -> w.writeEventName(() -> "index2index").int64array((long)indexCount);
        this.indexTemplate = w -> w.writeEventName(() -> "index").int64array((long)indexCount);
    }

    public long toAddress0(long index) {
        long siftedIndex = index >> this.indexSpacingBits + this.indexCountBits;
        long mask = (long)this.indexCount - 1L;
        long maskedShiftedIndex = mask & siftedIndex;
        return maskedShiftedIndex;
    }

    long toAddress1(long index) {
        long siftedIndex = index >> this.indexSpacingBits;
        long mask = (long)this.indexCount - 1L;
        return mask & siftedIndex;
    }

    public void close() {
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)IndexingFields.indexCount).int64((long)this.indexCount).write((WireKey)IndexingFields.indexSpacing).int64((long)this.indexSpacing).write((WireKey)IndexingFields.index2Index).int64forBinding(0L, this.index2Index).write((WireKey)IndexingFields.lastIndex).int64forBinding(0L, this.nextEntryToIndex);
    }

    long indexToIndex(StoreRecovery recovery, @NotNull Wire wire, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        long index2Index = this.index2Index.getVolatileValue();
        return index2Index > 0L ? index2Index : this.acquireIndex2Index(recovery, wire, timeoutMS);
    }

    long acquireIndex2Index(StoreRecovery recovery, Wire wire, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        try {
            return this.acquireIndex2Index0(recovery, wire, timeoutMS);
        }
        catch (TimeoutException te) {
            return recovery.recoverIndex2Index(this.index2Index, () -> this.acquireIndex2Index0(recovery, wire, timeoutMS), timeoutMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long acquireIndex2Index0(StoreRecovery recovery, Wire wire, long timeoutMS) throws EOFException, TimeoutException, UnrecoverableTimeoutException, StreamCorruptedException {
        long start = System.currentTimeMillis();
        try {
            do {
                long index2Index;
                if ((index2Index = this.index2Index.getVolatileValue()) == -1L) {
                    wire.pauser().pause(timeoutMS, TimeUnit.MILLISECONDS);
                    continue;
                }
                if (index2Index != 0L) {
                    long l = index2Index;
                    return l;
                }
                if (!this.index2Index.compareAndSwapValue(0L, -1L)) continue;
                long index = 0L;
                try {
                    index = this.newIndex(recovery, wire, true, timeoutMS);
                }
                finally {
                    this.index2Index.setOrderedValue(index);
                }
                long l = index;
                return l;
            } while (System.currentTimeMillis() < start + timeoutMS);
        }
        finally {
            wire.pauser().reset();
        }
        throw new TimeoutException("index2index NOT_COMPLETE for too long.");
    }

    @NotNull
    private LongArrayValues array(@NotNull WireIn w, @NotNull LongArrayValues using, boolean index2index) {
        String name;
        StringBuilder sb = Wires.acquireStringBuilder();
        ValueIn valueIn = w.readEventName(sb);
        String string = name = index2index ? "index2index" : "index";
        if (!name.contentEquals(sb)) {
            throw new IllegalStateException("expecting index, was " + sb);
        }
        valueIn.int64array(using, (Object)this, (o1, o2) -> {});
        return using;
    }

    long newIndex(StoreRecovery recovery, @NotNull Wire wire, boolean index2index, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        long writePosition = this.writePosition.getValue();
        wire.bytes().writePosition(writePosition);
        long position = recovery.writeHeader(wire, 0, timeoutMS);
        WriteMarshallable writer = index2index ? this.index2IndexTemplate : this.indexTemplate;
        writer.writeMarshallable((WireOut)wire);
        wire.updateHeader(position, true);
        this.writePosition.setMaxValue(wire.bytes().writePosition());
        return position;
    }

    long newIndex(StoreRecovery recovery, Wire wire, LongArrayValues index2Index, long index2, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException, TimeoutException {
        try {
            long pos;
            if (index2Index.compareAndSet(index2, 0L, -1L)) {
                long pos2 = this.newIndex(recovery, wire, false, timeoutMS);
                if (pos2 < 0L) {
                    throw new IllegalStateException("pos: " + pos2);
                }
                if (index2Index.compareAndSet(index2, -1L, pos2)) {
                    index2Index.setMaxUsed(index2 + 1L);
                    return pos2;
                }
                throw new IllegalStateException("Index " + index2 + " in index2index was altered");
            }
            while ((pos = index2Index.getVolatileValueAt(index2)) == -1L) {
                wire.pauser().pause(timeoutMS, TimeUnit.MILLISECONDS);
            }
            wire.pauser().reset();
            return pos;
        }
        catch (Exception e) {
            index2Index.compareAndSet(index2, -1L, 0L);
            throw e;
        }
    }

    ScanResult moveToIndex(StoreRecovery recovery, @NotNull Wire wire, long index, long timeoutMS) throws UnrecoverableTimeoutException, StreamCorruptedException {
        try {
            ScanResult scanResult = this.moveToIndex0(recovery, wire, index, timeoutMS);
            if (scanResult != null) {
                return scanResult;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return this.moveToIndexFromTheStart(wire, index);
    }

    private ScanResult moveToIndexFromTheStart(@NotNull Wire wire, long index) {
        try {
            wire.bytes().readPosition(0L);
            if (wire.readDataHeader()) {
                return this.linearScan(wire, index, 0L, wire.bytes().readPosition());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return ScanResult.NOT_FOUND;
    }

    ScanResult moveToIndex0(StoreRecovery recovery, @NotNull Wire wire, long index, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        LongArrayValues index2index = this.getIndex2index(recovery, wire, timeoutMS);
        Bytes bytes = wire.bytes();
        ((Bytes)bytes.writeLimit(bytes.capacity())).readLimit(bytes.capacity());
        long secondaryAddress = 0L;
        long startIndex = index & (long)(~(this.indexSpacing - 1));
        for (long primaryOffset = this.toAddress0(index); primaryOffset >= 0L && (secondaryAddress = index2index.getValueAt(primaryOffset)) == 0L; --primaryOffset) {
            startIndex -= (long)(this.indexCount * this.indexSpacing);
        }
        if (secondaryAddress <= 0L) {
            return null;
        }
        bytes.readPosition(secondaryAddress);
        wire.readMetaDataHeader();
        LongArrayValues array = this.indexArray.get();
        LongArrayValues array1 = this.array((WireIn)wire, array, false);
        long secondaryOffset = this.toAddress1(index);
        do {
            long fromAddress;
            if ((fromAddress = array1.getValueAt(secondaryOffset)) == 0L) {
                startIndex -= (long)this.indexSpacing;
                continue;
            }
            if (index == startIndex) {
                ((Bytes)bytes.readLimit(bytes.capacity())).readPosition(fromAddress);
                return ScanResult.FOUND;
            }
            return this.linearScan(wire, index, startIndex, fromAddress);
        } while (--secondaryOffset >= 0L);
        return null;
    }

    private ScanResult linearScan(@NotNull Wire wire, long toIndex, long fromKnownIndex, long knownAddress) {
        Bytes bytes = wire.bytes();
        long end = this.writePosition.getValue();
        ((Bytes)bytes.readLimit(bytes.capacity())).readPosition(knownAddress);
        long i = fromKnownIndex;
        while (true) {
            block6: {
                block5: {
                    try {
                        if (!wire.readDataHeader()) break block5;
                        if (i == toIndex) {
                            return ScanResult.FOUND;
                        }
                        if (bytes.readPosition() > end) {
                            return ScanResult.NOT_REACHED;
                        }
                        bytes.readSkip((long)Wires.lengthOf((int)bytes.readInt()));
                        break block6;
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                }
                return i == toIndex ? ScanResult.NOT_FOUND : ScanResult.NOT_REACHED;
            }
            ++i;
        }
    }

    private long linearScanByPosition(@NotNull Wire wire, long toPosition, long fromKnownIndex, long knownAddress) throws EOFException {
        Bytes bytes = wire.bytes();
        ((Bytes)bytes.readLimit(this.writePosition.getValue())).readPosition(knownAddress);
        long i = fromKnownIndex;
        while (bytes.readPosition() < toPosition) {
            WireIn.HeaderType headerType = wire.readDataHeader(true);
            int header = bytes.readInt();
            bytes.readSkip((long)Wires.lengthOf((int)header));
            switch (headerType) {
                case NONE: {
                    if (toPosition == Long.MAX_VALUE) {
                        return i < 0L ? i : i - 1L;
                    }
                    long pos = bytes.readPosition();
                    if (toPosition == pos) {
                        return i;
                    }
                    throw new EOFException();
                }
                case META_DATA: {
                    break;
                }
                case DATA: {
                    ++i;
                }
            }
        }
        if (bytes.readPosition() == toPosition) {
            return i;
        }
        throw new IllegalArgumentException("position not the start of a message");
    }

    LongArrayValues getIndex2index(StoreRecovery recovery, Wire wire, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        LongArrayValues values = this.index2indexArray.get();
        if (((Byteable)values).bytesStore() != null || timeoutMS == 0L) {
            return values;
        }
        long indexToIndex0 = this.indexToIndex(recovery, wire, timeoutMS);
        wire.bytes().readLimit(wire.bytes().capacity());
        try (DocumentContext context = wire.readingDocument(indexToIndex0);){
            if (!context.isPresent() || !context.isMetaData()) {
                SingleChronicleQueueStore.dumpStore(wire);
                throw new IllegalStateException("document present=" + context.isPresent() + ", metaData=" + context.isMetaData());
            }
            LongArrayValues longArrayValues = this.array((WireIn)wire, values, true);
            return longArrayValues;
        }
    }

    public long indexForPosition(StoreRecovery recovery, Wire wire, long position, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        LongArrayValues index2indexArr = this.getIndex2index(recovery, wire, timeoutMS);
        long lastKnownAddress = 0L;
        long lastKnownIndex = 0L;
        if (((Byteable)index2indexArr).bytesStore() == null) {
            return this.linearScanByPosition(wire, position, lastKnownIndex, lastKnownAddress);
        }
        LongArrayValues indexArr = this.indexArray.get();
        Bytes bytes = wire.bytes();
        for (int index2 = 0; index2 < this.indexCount; ++index2) {
            long secondaryAddress = this.getSecondaryAddress(recovery, wire, timeoutMS, index2indexArr, index2);
            bytes.readLimit(bytes.capacity());
            try (DocumentContext context = wire.readingDocument(secondaryAddress);){
                if (!context.isPresent() || !context.isMetaData()) {
                    throw new IllegalStateException("document present=" + context.isPresent() + ", metaData=" + context.isMetaData());
                }
                LongArrayValues array1 = this.array((WireIn)wire, indexArr, false);
                long posN = array1.getValueAt((long)(this.indexCount - 1));
                if (posN > 0L && posN < position) {
                    lastKnownAddress = posN;
                    lastKnownIndex = ((long)index2 + 1L << this.indexCountBits) - 1L << this.indexSpacingBits;
                    continue;
                }
                for (int index1 = 0; index1 < this.indexCount; ++index1) {
                    long nextIndex;
                    ScanResult scanResult;
                    long pos = array1.getValueAt((long)index1);
                    if (pos != 0L) {
                        lastKnownAddress = pos;
                        lastKnownIndex = ((long)index2 << this.indexCountBits + this.indexSpacingBits) + (long)(index1 << this.indexSpacingBits);
                        continue;
                    }
                    if (lastKnownIndex < 0L) {
                        scanResult = this.firstScan(wire);
                        nextIndex = 0L;
                    } else {
                        nextIndex = lastKnownIndex + (long)this.indexSpacing;
                        scanResult = this.linearScan(wire, nextIndex, lastKnownIndex, lastKnownAddress);
                    }
                    if (scanResult == ScanResult.FOUND) {
                        long nextPosition;
                        lastKnownAddress = nextPosition = bytes.readPosition();
                        array1.setOrderedValueAt((long)index1, lastKnownAddress);
                        array1.setMaxUsed((long)(index1 + 1));
                        if (nextPosition == position) {
                            this.nextEntryToIndex.setMaxValue(nextIndex + 1L);
                            long l = nextIndex;
                            return l;
                        }
                        lastKnownIndex = nextIndex;
                        continue;
                    }
                    long ret = this.linearScanByPosition(wire, position, lastKnownIndex, lastKnownAddress);
                    this.nextEntryToIndex.setMaxValue(ret + 1L);
                    long l = ret;
                    return l;
                }
                continue;
            }
        }
        throw new AssertionError();
    }

    long getSecondaryAddress(StoreRecovery recovery, Wire wire, long timeoutMS, LongArrayValues index2indexArr, int index2) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        try {
            return this.getSecondaryAddress1(recovery, wire, timeoutMS, index2indexArr, index2);
        }
        catch (TimeoutException e) {
            wire.pauser().reset();
            return recovery.recoverSecondaryAddress(index2indexArr, index2, () -> this.getSecondaryAddress1(recovery, wire, timeoutMS, index2indexArr, index2), timeoutMS);
        }
    }

    long getSecondaryAddress1(StoreRecovery recovery, Wire wire, long timeoutMS, LongArrayValues index2indexArr, int index2) throws EOFException, TimeoutException, UnrecoverableTimeoutException, StreamCorruptedException {
        long secondaryAddress = index2indexArr.getValueAt((long)index2);
        if (secondaryAddress == 0L) {
            secondaryAddress = this.newIndex(recovery, wire, index2indexArr, index2, timeoutMS);
            if (secondaryAddress > wire.bytes().capacity()) {
                throw new IllegalStateException("sa: " + secondaryAddress);
            }
            long sa = index2indexArr.getValueAt((long)index2);
            if (sa != secondaryAddress) {
                throw new AssertionError();
            }
        } else if (secondaryAddress == -1L) {
            secondaryAddress = this.getSecondaryAddress0(wire, timeoutMS, index2indexArr, index2);
        } else if (secondaryAddress > wire.bytes().capacity()) {
            throw new IllegalStateException("sa: " + secondaryAddress);
        }
        return secondaryAddress;
    }

    private long getSecondaryAddress0(Wire wire, long timeoutMS, LongArrayValues index2indexArr, int index2) throws TimeoutException {
        long secondaryAddress;
        while ((secondaryAddress = index2indexArr.getVolatileValueAt((long)index2)) == -1L) {
            wire.pauser().pause(timeoutMS, TimeUnit.MILLISECONDS);
        }
        if (secondaryAddress > wire.bytes().capacity()) {
            throw new IllegalStateException("sa0: " + secondaryAddress);
        }
        wire.pauser().reset();
        return secondaryAddress;
    }

    @NotNull
    private ScanResult firstScan(Wire wire) {
        try {
            wire.bytes().readPosition(0L);
            return wire.readDataHeader() ? ScanResult.FOUND : ScanResult.NOT_REACHED;
        }
        catch (EOFException e) {
            return ScanResult.NOT_FOUND;
        }
    }

    public void setPositionForIndex(StoreRecovery recovery, Wire wire, long index, long position, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        if ((index & (long)this.indexSpacingBits) != 0L) {
            assert (false);
            return;
        }
        if (position > wire.bytes().capacity()) {
            throw new IllegalArgumentException("pos: " + position);
        }
        LongArrayValues index2indexArr = this.getIndex2index(recovery, wire, timeoutMS);
        if (((Byteable)index2indexArr).bytesStore() == null) {
            assert (false);
            return;
        }
        LongArrayValues indexArr = this.indexArray.get();
        Bytes bytes = wire.bytes();
        int index2 = (int)(index >>> this.indexCountBits + this.indexSpacingBits);
        if (index2 >= this.indexCount) {
            throw new IllegalStateException("Unable to index " + index);
        }
        long secondaryAddress = this.getSecondaryAddress(recovery, wire, timeoutMS, index2indexArr, index2);
        if (secondaryAddress > bytes.capacity()) {
            throw new IllegalStateException("sa2: " + secondaryAddress);
        }
        bytes.readLimit(bytes.capacity());
        try (DocumentContext context = wire.readingDocument(secondaryAddress);){
            int index3;
            if (!context.isPresent() || !context.isMetaData()) {
                throw new IllegalStateException("document present=" + context.isPresent() + ", metaData=" + context.isMetaData());
            }
            LongArrayValues array1 = this.array((WireIn)wire, indexArr, false);
            long posN = array1.getValueAt((long)(index3 = (int)(index >>> this.indexSpacingBits & (long)(this.indexCount - 1))));
            if (posN == 0L) {
                array1.setValueAt((long)index3, position);
            } else if (posN != position) {
                System.out.println("posN: " + posN + " position: " + position);
            }
        }
    }

    static enum IndexingFields implements WireKey
    {
        indexCount,
        indexSpacing,
        index2Index,
        lastIndex;

    }
}

