/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.WireStoreFactory;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ChronicleQueueBuilder<B extends ChronicleQueueBuilder<B, Q>, Q extends ChronicleQueue>
extends Cloneable {
    public static SingleChronicleQueueBuilder single(String basePath) {
        return SingleChronicleQueueBuilder.binary(basePath);
    }

    public static SingleChronicleQueueBuilder singleText(String basePath) {
        return SingleChronicleQueueBuilder.text(new File(basePath));
    }

    @NotNull
    public Q build();

    @NotNull
    public B onRingBufferStats(@NotNull Consumer<BytesRingBufferStats> var1);

    public Consumer<BytesRingBufferStats> onRingBufferStats();

    @NotNull
    public File path();

    @NotNull
    public B blockSize(int var1);

    public long blockSize();

    @NotNull
    public B wireType(@NotNull WireType var1);

    @NotNull
    public WireType wireType();

    @NotNull
    public B rollCycle(@NotNull RollCycle var1);

    public long bufferCapacity();

    @NotNull
    public B bufferCapacity(long var1);

    @NotNull
    public B epoch(long var1);

    public long epoch();

    @NotNull
    public RollCycle rollCycle();

    @NotNull
    public B onThrowable(@NotNull Consumer<Throwable> var1);

    @NotNull
    public B buffered(boolean var1);

    public boolean buffered();

    @Nullable
    public EventLoop eventLoop();

    @NotNull
    public B eventLoop(EventLoop var1);

    @NotNull
    public B bufferCapacity(int var1);

    public B indexCount(int var1);

    public int indexCount();

    public B indexSpacing(int var1);

    public int indexSpacing();

    public WireStoreFactory storeFactory();
}

