/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.service;

import java.util.List;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.service.ServiceWrapper;
import net.openhft.chronicle.queue.service.ServiceWrapperBuilder;
import net.openhft.chronicle.wire.MethodReader;

public class EventLoopServiceWrapper<O>
implements ServiceWrapper,
EventHandler {
    protected final MethodReader[] serviceIn;
    private final HandlerPriority priority;
    private final ChronicleQueue[] inputQueues;
    private final ChronicleQueue outputQueue;
    private final O serviceOut;
    private final boolean createdEventLoop;
    private final Object[] serviceImpl;
    private volatile boolean closed = false;
    private EventLoop eventLoop;

    public EventLoopServiceWrapper(ServiceWrapperBuilder<O> builder) {
        this.priority = builder.priority();
        this.outputQueue = ((SingleChronicleQueueBuilder)SingleChronicleQueueBuilder.binary(builder.outputPath()).sourceId(builder.outputSourceId())).build();
        this.serviceOut = this.outputQueue.createAppender().methodWriterBuilder(builder.outClass()).recordHistory(builder.outputSourceId() != 0).get();
        this.serviceImpl = builder.getServiceFunctions().stream().map(f -> f.apply(this.serviceOut)).toArray();
        List<String> paths = builder.inputPath();
        this.serviceIn = new MethodReader[paths.size()];
        this.inputQueues = new ChronicleQueue[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            this.inputQueues[i] = ((SingleChronicleQueueBuilder)SingleChronicleQueueBuilder.binary(paths.get(i)).sourceId(builder.inputSourceId())).build();
            this.serviceIn[i] = this.inputQueues[i].createTailer().afterLastWritten(this.outputQueue).methodReader(this.serviceImpl);
        }
        this.eventLoop = builder.eventLoop();
        this.eventLoop.addHandler((EventHandler)this);
        this.createdEventLoop = builder.createdEventLoop();
        if (this.createdEventLoop) {
            this.eventLoop.start();
        }
    }

    @Override
    public ChronicleQueue[] inputQueues() {
        return this.inputQueues;
    }

    @Override
    public ChronicleQueue outputQueue() {
        return this.outputQueue;
    }

    public boolean action() throws InvalidEventHandlerException, InterruptedException {
        if (this.isClosed()) {
            Closeable.closeQuietly((Object)this.serviceImpl);
            Closeable.closeQuietly((Object)this.serviceIn);
            Closeable.closeQuietly((Object)this.outputQueue);
            Closeable.closeQuietly((Object)this.inputQueues);
            throw new InvalidEventHandlerException();
        }
        boolean busy = false;
        for (MethodReader reader : this.serviceIn) {
            busy |= reader.readOne();
        }
        return busy;
    }

    public HandlerPriority priority() {
        return this.priority;
    }

    public void close() {
        this.closed = true;
        EventLoop eventLoop = this.eventLoop;
        this.eventLoop = null;
        if (this.createdEventLoop && eventLoop != null) {
            eventLoop.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

