/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptHistory;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WriteMarshallable;

class MethodWriterInvocationHandler
implements InvocationHandler {
    private final ExcerptAppender appender;
    private final Map<Method, Class[]> parameterMap = new ConcurrentHashMap<Method, Class[]>();
    private boolean recordHistory = false;

    MethodWriterInvocationHandler(ExcerptAppender appender) {
        this.appender = appender;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        try (DocumentContext context = this.appender.writingDocument();){
            Wire wire = context.wire();
            if (this.recordHistory) {
                wire.write((CharSequence)"history").marshallable((WriteMarshallable)ExcerptHistory.get());
            }
            ValueOut valueOut = wire.writeEventName((CharSequence)method.getName());
            Class[] parameterTypes = this.parameterMap.get(method);
            if (parameterTypes == null) {
                parameterTypes = method.getParameterTypes();
                this.parameterMap.put(method, parameterTypes);
            }
            switch (parameterTypes.length) {
                case 0: {
                    valueOut.text((CharSequence)"");
                    return ObjectUtils.defaultValue(method.getReturnType());
                }
                case 1: {
                    valueOut.object(parameterTypes[0], args[0]);
                    return ObjectUtils.defaultValue(method.getReturnType());
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    public void recordHistroy(boolean recordHistory) {
        this.recordHistory = recordHistory;
    }
}

