/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.CycleCalculator;
import net.openhft.chronicle.queue.DefaultCycleCalculator;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.WireStoreFactory;
import net.openhft.chronicle.queue.impl.single.RollCycleRetriever;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.queue.impl.single.TimedStoreRecovery;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimeoutPauser;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChronicleQueueBuilder<B extends ChronicleQueueBuilder>
implements ChronicleQueueBuilder<B> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractChronicleQueueBuilder.class);
    public static final String DEFAULT_ROLL_CYCLE_PROPERTY = "net.openhft.queue.builder.defaultRollCycle";
    public static final String DEFAULT_EPOCH_PROPERTY = "net.openhft.queue.builder.defaultEpoch";
    protected final File path;
    protected long blockSize;
    @NotNull
    protected WireType wireType;
    @NotNull
    protected RollCycle rollCycle;
    protected long epoch;
    protected BufferMode writeBufferMode = BufferMode.None;
    protected BufferMode readBufferMode = BufferMode.None;
    @Nullable
    protected EventLoop eventLoop;
    @NotNull
    protected CycleCalculator cycleCalculator = DefaultCycleCalculator.INSTANCE;
    private long bufferCapacity;
    private int indexSpacing;
    private int indexCount;
    @NotNull
    private Consumer<BytesRingBufferStats> onRingBufferStats = NoBytesRingBufferStats.NONE;
    private TimeProvider timeProvider = SystemTimeProvider.INSTANCE;
    private Supplier<Pauser> pauserSupplier = () -> new TimeoutPauser(500000);
    private long timeoutMS = 10000L;
    private WireStoreFactory storeFactory;
    private int sourceId = 0;
    private StoreRecoveryFactory recoverySupplier = TimedStoreRecovery.FACTORY;
    private StoreFileListener storeFileListener;
    private boolean readOnly = false;
    private boolean rollCycleSet = false;
    private boolean progressOnContention = false;

    public AbstractChronicleQueueBuilder(File path) {
        this.rollCycle = this.loadDefaultRollCycle();
        this.blockSize = OS.is64Bit() ? 0x4000000L : 65536L;
        this.path = path;
        this.wireType = WireType.BINARY_LIGHT;
        this.epoch = Long.getLong(DEFAULT_EPOCH_PROPERTY, 0L);
        this.bufferCapacity = -1L;
        this.indexSpacing = -1;
        this.indexCount = -1;
        this.storeFileListener = (cycle, file) -> {
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), "File released " + file);
            }
        };
    }

    private RollCycle loadDefaultRollCycle() {
        if (null == System.getProperty(DEFAULT_ROLL_CYCLE_PROPERTY)) {
            return RollCycles.DAILY;
        }
        String rollCycleProperty = System.getProperty(DEFAULT_ROLL_CYCLE_PROPERTY);
        String[] rollCyclePropertyParts = rollCycleProperty.split(":");
        if (rollCyclePropertyParts.length > 0) {
            try {
                Class<?> rollCycleClass = Class.forName(rollCyclePropertyParts[0]);
                if (Enum.class.isAssignableFrom(rollCycleClass)) {
                    if (rollCyclePropertyParts.length < 2) {
                        LOGGER.warn("Default roll cycle configured as enum, but enum value not specified: " + rollCycleProperty);
                    } else {
                        Class<?> eClass = rollCycleClass;
                        Enum instance = ObjectUtils.valueOf(eClass, (String)rollCyclePropertyParts[1]);
                        if (instance instanceof RollCycle) {
                            return (RollCycle)((Object)instance);
                        }
                        LOGGER.warn("Configured default rollcycle is not a subclass of RollCycle");
                    }
                } else {
                    Object instance = ObjectUtils.newInstance(rollCycleClass);
                    if (instance instanceof RollCycle) {
                        return (RollCycle)instance;
                    }
                    LOGGER.warn("Configured default rollcycle is not a subclass of RollCycle");
                }
            }
            catch (ClassNotFoundException ignored) {
                LOGGER.warn("Default roll cycle class: " + rollCyclePropertyParts[0] + " was not found");
            }
        }
        return RollCycles.DAILY;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger((String)this.getClass().getName());
    }

    @Override
    @NotNull
    public CycleCalculator cycleCalculator() {
        return this.cycleCalculator;
    }

    @Override
    public B rollTime(@NotNull LocalTime time, ZoneId zoneId) {
        this.epoch = TimeUnit.SECONDS.toMillis(time.toSecondOfDay());
        return (B)this;
    }

    @Override
    @NotNull
    public B onRingBufferStats(@NotNull Consumer<BytesRingBufferStats> onRingBufferStats) {
        this.onRingBufferStats = onRingBufferStats;
        return (B)this;
    }

    @Override
    @NotNull
    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats;
    }

    @Override
    @NotNull
    public File path() {
        return this.path;
    }

    @Override
    @NotNull
    public B blockSize(int blockSize) {
        this.blockSize = Math.max(65536, blockSize);
        return (B)this;
    }

    @Override
    public long blockSize() {
        long minSize = Math.max(65536L, 32L * (long)this.indexCount());
        return Math.max(minSize, this.blockSize);
    }

    @Override
    @NotNull
    public B wireType(@NotNull WireType wireType) {
        this.wireType = wireType;
        return (B)this;
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    @Override
    @NotNull
    public B rollCycle(@NotNull RollCycle rollCycle) {
        this.rollCycle = rollCycle;
        this.rollCycleSet = true;
        return (B)this;
    }

    @Override
    public long bufferCapacity() {
        return Math.min(this.blockSize / 4L, this.bufferCapacity == -1L ? 0x200000L : Math.max(4096L, this.bufferCapacity));
    }

    @Override
    @NotNull
    public B bufferCapacity(long bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
        return (B)this;
    }

    @Override
    @NotNull
    public B epoch(long epoch) {
        this.epoch = epoch;
        return (B)this;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    @NotNull
    public RollCycle rollCycle() {
        return this.rollCycle;
    }

    @Override
    @Deprecated
    @NotNull
    public B buffered(boolean isBuffered) {
        this.writeBufferMode = isBuffered ? BufferMode.Asynchronous : BufferMode.None;
        return (B)this;
    }

    @Override
    @Deprecated
    public boolean buffered() {
        return this.writeBufferMode == BufferMode.Asynchronous;
    }

    @Override
    @NotNull
    public BufferMode writeBufferMode() {
        return this.wireType() == WireType.DELTA_BINARY ? BufferMode.None : this.writeBufferMode;
    }

    @Override
    public B writeBufferMode(BufferMode writeBufferMode) {
        this.writeBufferMode = writeBufferMode;
        return (B)this;
    }

    @Override
    public BufferMode readBufferMode() {
        return this.readBufferMode;
    }

    @Override
    public B readBufferMode(BufferMode readBufferMode) {
        this.readBufferMode = readBufferMode;
        return (B)this;
    }

    @Override
    @Nullable
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @Override
    @NotNull
    public B eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        return (B)this;
    }

    @Override
    public B indexCount(int indexCount) {
        this.indexCount = Maths.nextPower2((int)indexCount, (int)8);
        return (B)this;
    }

    @Override
    public int indexCount() {
        return this.indexCount <= 0 ? this.rollCycle.defaultIndexCount() : this.indexCount;
    }

    @Override
    public B indexSpacing(int indexSpacing) {
        this.indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        return (B)this;
    }

    @Override
    public int indexSpacing() {
        return this.indexSpacing <= 0 ? this.rollCycle.defaultIndexSpacing() : this.indexSpacing;
    }

    public TimeProvider timeProvider() {
        return this.timeProvider;
    }

    public B timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return (B)this;
    }

    public Supplier<Pauser> pauserSupplier() {
        return this.pauserSupplier;
    }

    public B pauserSupplier(Supplier<Pauser> pauser) {
        this.pauserSupplier = pauser;
        return (B)this;
    }

    public B timeoutMS(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return (B)this;
    }

    public long timeoutMS() {
        return this.timeoutMS;
    }

    public void storeFactory(WireStoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    @Override
    public WireStoreFactory storeFactory() {
        return this.storeFactory;
    }

    @Override
    public B storeFileListener(StoreFileListener storeFileListener) {
        this.storeFileListener = storeFileListener;
        return (B)this;
    }

    @Override
    public StoreFileListener storeFileListener() {
        return this.storeFileListener;
    }

    public B sourceId(int sourceId) {
        if (sourceId < 0) {
            throw new IllegalArgumentException("Invalid source Id, must be positive");
        }
        this.sourceId = sourceId;
        return (B)this;
    }

    public int sourceId() {
        return this.sourceId;
    }

    public StoreRecoveryFactory recoverySupplier() {
        return this.recoverySupplier;
    }

    public B recoverySupplier(StoreRecoveryFactory recoverySupplier) {
        this.recoverySupplier = recoverySupplier;
        return (B)this;
    }

    @Override
    public boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public B readOnly(boolean readOnly) {
        if (OS.isWindows() && readOnly) {
            Jvm.warn().on(AbstractChronicleQueueBuilder.class, "Read-only mode is not supported on Windows\u00ae platforms, defaulting to read/write.");
            this.readOnly = false;
        } else {
            this.readOnly = readOnly;
        }
        return (B)this;
    }

    @Override
    public boolean progressOnContention() {
        return this.progressOnContention;
    }

    @Override
    public B progressOnContention(boolean progressOnContention) {
        this.progressOnContention = progressOnContention;
        return (B)this;
    }

    @NotNull
    public AbstractChronicleQueueBuilder encryptSupplier(Supplier<Cipher> encryptSupplier) {
        throw new UnsupportedOperationException("Encryption supported in Chronicle Queue Enterprise");
    }

    @NotNull
    public AbstractChronicleQueueBuilder decryptSupplier(Supplier<Cipher> decryptSupplier) {
        throw new UnsupportedOperationException("Encryption supported in Chronicle Queue Enterprise");
    }

    protected void preBuild() {
        this.assignRollCycleFromExistingQueueFile();
    }

    private void assignRollCycleFromExistingQueueFile() {
        Optional<RollCycle> existingRollCycle = RollCycleRetriever.getRollCycle(this.path.toPath(), this.wireType, this.blockSize);
        existingRollCycle.ifPresent(rc -> {
            if (this.rollCycleSet && rc != this.rollCycle) {
                throw new IllegalArgumentException(String.format("Trying to create queue with roll cycle %s, but existing queue files use %s", this.rollCycle, rc));
            }
            if (rc != this.rollCycle) {
                this.rollCycle = rc;
            }
        });
    }

    static enum NoBytesRingBufferStats implements Consumer<BytesRingBufferStats>
    {
        NONE;


        @Override
        public void accept(BytesRingBufferStats bytesRingBufferStats) {
        }
    }
}

