/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.IOException;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.AbstractChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Excerpts {
    private static final Logger LOG = LoggerFactory.getLogger(Excerpts.class);

    public static class StoreTailer
    implements ExcerptTailer {
        @NotNull
        private final AbstractChronicleQueue queue;
        private Wire wire;
        private long cycle;
        private long index;
        private WireStore store;
        private long nextPrefetch = OS.pageSize();

        public StoreTailer(@NotNull AbstractChronicleQueue queue) {
            this.queue = queue;
            this.cycle = -1L;
            this.toStart();
        }

        public String toString() {
            return "StoreTailer{index sequence=" + ChronicleQueue.toSequenceNumber(this.index) + ", index cycle=" + ChronicleQueue.toCycle(this.index) + ", store=" + this.store + ", queue=" + this.queue + '}';
        }

        @Override
        public boolean readDocument(@NotNull ReadMarshallable marshaller) {
            return this.readAtIndex(marshaller, ReadMarshallable::readMarshallable);
        }

        @Override
        public boolean readBytes(@NotNull Bytes using) {
            return this.readAtIndex(using, (t, w) -> t.write((BytesStore)w.bytes()));
        }

        @Override
        public boolean readBytes(@NotNull ReadBytesMarshallable using) {
            return this.readAtIndex(using, (t, w) -> t.readMarshallable(w.bytes()));
        }

        private <T> boolean readAtIndex(@NotNull T t, @NotNull BiConsumer<T, Wire> c) {
            long cycle = this.cycle;
            long index = this.index;
            if (this.store == null) {
                long firstIndex = this.queue.firstIndex();
                if (index == -1L) {
                    return false;
                }
                this.moveToIndex(firstIndex);
            }
            if (this.readAt(t, c)) {
                this.index = ChronicleQueue.index(cycle, ChronicleQueue.toSequenceNumber(index) + 1L);
                return true;
            }
            return false;
        }

        private <T> boolean readAt(@NotNull T t, @NotNull BiConsumer<T, Wire> c) {
            do {
                long roll = Long.MIN_VALUE;
                this.wire.bytes().readLimit(this.wire.bytes().capacity());
                while (this.wire.bytes().readVolatileInt(this.wire.bytes().readPosition()) != 0) {
                    DocumentContext documentContext = this.wire.readingDocument();
                    Throwable throwable = null;
                    try {
                        if (!documentContext.isPresent()) {
                            boolean bl = false;
                            return bl;
                        }
                        if (documentContext.isData()) {
                            c.accept(t, this.wire);
                            boolean bl = true;
                            return bl;
                        }
                        StringBuilder sb = Wires.acquireStringBuilder();
                        ValueIn vi = this.wire.readEventName(sb);
                        if (!"roll".contentEquals(sb)) continue;
                        roll = vi.int32();
                        break;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (documentContext == null) continue;
                        if (throwable != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        documentContext.close();
                    }
                }
                if (roll == Long.MIN_VALUE) {
                    return false;
                }
                this.cycle(roll);
            } while (this.store != null);
            return false;
        }

        @Override
        public long index() {
            if (this.store == null) {
                throw new IllegalArgumentException("This tailer is not bound to any cycle");
            }
            return ChronicleQueue.index(this.cycle, this.index);
        }

        @Override
        public boolean moveToIndex(long index) {
            long expectedCycle;
            if (LOG.isDebugEnabled()) {
                LOG.debug(SingleChronicleQueueStore.IndexOffset.toBinaryString(index));
                LOG.debug(SingleChronicleQueueStore.IndexOffset.toScale());
            }
            if ((expectedCycle = ChronicleQueue.toCycle(index)) != this.cycle) {
                this.cycle(expectedCycle);
            }
            this.cycle = expectedCycle;
            Bytes bytes = this.wire.bytes();
            long sequenceNumber = ChronicleQueue.toSequenceNumber(index);
            if (sequenceNumber == -1L) {
                bytes.readPosition(0L);
                this.index = ChronicleQueue.index(this.cycle, sequenceNumber);
                return true;
            }
            long position = this.store.moveToIndex(this.wire, ChronicleQueue.toSequenceNumber(index));
            if (position == -1L) {
                return false;
            }
            bytes.readPosition(position);
            bytes.readLimit(bytes.realCapacity());
            this.index = ChronicleQueue.index(this.cycle, sequenceNumber - 1L);
            return true;
        }

        @Override
        @NotNull
        public ExcerptTailer toStart() {
            long index = this.queue.firstIndex();
            if (ChronicleQueue.toSequenceNumber(index) == -1L) {
                this.cycle(ChronicleQueue.toCycle(index));
                this.wire.bytes().readPosition(0L);
                return this;
            }
            if (!this.moveToIndex(index)) {
                throw new IllegalStateException("unable to move to the start, cycle=" + this.cycle);
            }
            return this;
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() throws IOException {
            if (!this.moveToIndex(this.queue.lastIndex())) {
                throw new IllegalStateException("unable to move to the start");
            }
            return this;
        }

        @NotNull
        private StoreTailer cycle(long cycle) {
            if (this.cycle != cycle) {
                if (null != this.store) {
                    this.queue.release(this.store);
                }
                this.cycle = cycle;
                this.store = this.queue.storeForCycle(cycle, this.queue.epoch());
                this.wire = (Wire)this.queue.wireType().apply((Object)this.store.mappedBytes());
                this.moveToIndex(ChronicleQueue.index(cycle, -1L));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("tailer=" + ((MappedBytes)this.wire.bytes()).mappedFile().file().getAbsolutePath());
                }
            }
            return this;
        }

        @Override
        public void prefetch() {
            long position = this.wire.bytes().readPosition();
            if (position < this.nextPrefetch) {
                return;
            }
            long prefetch = OS.mapAlign((long)position) + (long)OS.pageSize();
            this.wire.bytes().compareAndSwapInt(prefetch, -1, -1);
            this.nextPrefetch = prefetch + (long)OS.pageSize();
        }
    }

    public static class StoreAppender
    implements ExcerptAppender {
        @NotNull
        private final AbstractChronicleQueue queue;
        private long index = -1L;
        private Wire wire;
        private long cycle;
        private WireStore store;
        private long nextPrefetch = OS.pageSize();

        public StoreAppender(@NotNull AbstractChronicleQueue queue) {
            this.queue = queue;
            long lastIndex = this.queue.lastIndex();
            long l = this.cycle = lastIndex == -1L ? queue.cycle() : ChronicleQueue.toCycle(lastIndex);
            if (this.cycle < 0L) {
                throw new IllegalArgumentException("You can not have a cycle that starts before Epoch. cycle=" + this.cycle);
            }
            this.store = queue.storeForCycle(this.cycle, queue.epoch());
            this.index = this.store.sequenceNumber();
            MappedBytes mappedBytes = this.store.mappedBytes();
            if (LOG.isDebugEnabled()) {
                LOG.debug("appender file=" + mappedBytes.mappedFile().file().getAbsolutePath());
            }
            this.wire = (Wire)this.queue.wireType().apply((Object)mappedBytes);
        }

        @Override
        public long writeDocument(@NotNull WriteMarshallable writer) {
            long position;
            WireStore store = this.store();
            do {
                long readPosition = this.wire.bytes().readPosition();
                boolean isMetaData = (this.wire.bytes().readInt(readPosition) & 0x40000000) != 0;
                position = WireInternal.writeWireOrAdvanceIfNotEmpty((WireOut)this.wire, (boolean)false, (WriteMarshallable)writer);
                if (position == 0L || isMetaData) continue;
                ++this.index;
            } while (position < 0L);
            ++this.index;
            store.writePosition(this.wire.bytes().writePosition());
            store.storeIndexLocation(this.wire, position, this.index);
            return ChronicleQueue.index(store.cycle(), this.index);
        }

        public long writeBytes(@NotNull Bytes bytes) {
            long position;
            WireStore store = this.store();
            do {
                long readPosition = this.wire.bytes().readPosition();
                boolean isMetaData = (this.wire.bytes().readInt(readPosition) & 0x40000000) != 0;
                position = WireInternal.writeWireOrAdvanceIfNotEmpty((WireOut)this.wire, (boolean)false, (Bytes)bytes);
                if (position == 0L || isMetaData) continue;
                ++this.index;
            } while (position < 0L);
            ++this.index;
            store.writePosition(this.wire.bytes().writePosition());
            store.storeIndexLocation(this.wire, position, this.index);
            return ChronicleQueue.index(store.cycle(), this.index);
        }

        @Override
        public long writeBytes(@NotNull WriteBytesMarshallable marshallable) {
            return this.writeDocument(w -> marshallable.writeMarshallable(w.bytes()));
        }

        @Override
        public long index() {
            if (this.index == -1L) {
                throw new IllegalStateException();
            }
            return ChronicleQueue.index(this.cycle(), this.index);
        }

        @Override
        public long cycle() {
            return this.store.cycle();
        }

        @NotNull
        public ChronicleQueue queue() {
            return this.queue;
        }

        public boolean consumeBytes(BytesConsumer consumer) throws InterruptedException {
            Bytes bytes = this.wire.bytes();
            long start = bytes.writePosition();
            bytes.writeInt(Integer.MIN_VALUE);
            if (!consumer.accept(bytes)) {
                bytes.writeSkip(-4L);
                bytes.writeInt(bytes.writePosition(), 0);
                return false;
            }
            long len = bytes.writePosition() - start - 4L;
            if (len == 0L) {
                bytes.writeSkip(-4L);
                bytes.writeInt(bytes.writePosition(), 0);
                return false;
            }
            bytes.writeInt(start, Wires.toIntU30((long)len, (String)"Document length %,d out of 30-bit int range."));
            this.store().writePosition(bytes.writePosition()).storeIndexLocation(this.wire, start, ++this.index);
            return true;
        }

        @ForceInline
        private WireStore store() {
            if (this.cycle != this.queue.cycle()) {
                long nextCycle = this.queue.cycle();
                if (this.store != null) {
                    while (!this.store.appendRollMeta(this.wire, nextCycle)) {
                        Thread.yield();
                    }
                    this.queue.release(this.store);
                }
                this.cycle = nextCycle;
                this.store = this.queue.storeForCycle(this.cycle, this.queue.epoch());
                this.wire = (Wire)this.queue().wireType().apply((Object)this.store.mappedBytes());
            }
            return this.store;
        }

        @Override
        public void prefetch() {
            long position = this.wire.bytes().writePosition();
            if (position < this.nextPrefetch) {
                return;
            }
            long prefetch = OS.mapAlign((long)position);
            this.wire.bytes().compareAndSwapInt(prefetch, -1, -1);
            this.nextPrefetch = prefetch + (long)OS.pageSize();
        }
    }

    @FunctionalInterface
    public static interface BytesConsumer {
        public boolean accept(Bytes<?> var1) throws InterruptedException;
    }
}

