/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.Closeable;
import java.io.IOException;
import net.openhft.chronicle.queue.Excerpt;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public interface ChronicleQueue
extends Closeable {
    public static final long MINUS_1_40BIT = ChronicleQueue.toSequenceNumber(-1L);

    @NotNull
    public String name();

    @NotNull
    public Excerpt createExcerpt();

    @NotNull
    public ExcerptTailer createTailer() throws IOException;

    @NotNull
    public ExcerptAppender createAppender();

    public long size();

    public void clear();

    public long firstIndex();

    public long lastIndex();

    @NotNull
    public WireType wireType();

    public static long toSequenceNumber(long index) {
        long l = index & 0xFFFFFFFFFFL;
        return l == MINUS_1_40BIT ? -1L : l;
    }

    public static long toCycle(long index) {
        int result = (int)(index >> 40);
        if (result > 0x1000000) {
            throw new IllegalStateException("cycle value is too large, it must fit into 24bits, either use a larger rollType of increase the roll offset.");
        }
        if (result < 0) {
            throw new IllegalStateException("Invalid cycle=" + result + ", cycles can not be negative" + ".");
        }
        return result;
    }

    public static long index(long cycle, long sequenceNumber) {
        return (cycle << 40) + (sequenceNumber & 0xFFFFFFFFFFL);
    }
}

