/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.internal;

import java.net.InetSocketAddress;
import java.security.Security;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.network.TCPRegistry;
import org.jetbrains.annotations.NotNull;

public class AddressCache {
    private static final String NETWORK_ADDRESS_CACHE_TTL = "networkaddress.cache.ttl";
    private static final int NEVER_EXPIRE = -1;
    private final Map<String, CacheEntry> cachedAddresses = new ConcurrentHashMap<String, CacheEntry>();

    public InetSocketAddress lookup(String description) {
        CacheEntry cacheEntry = this.cachedAddresses.get(description);
        return cacheEntry != null ? cacheEntry.address() : null;
    }

    public void add(String description, String hostname, int port) {
        this.cachedAddresses.put(description, new CacheEntry(hostname, port));
    }

    public void clear() {
        this.cachedAddresses.clear();
    }

    private static final class CacheEntry {
        @NotNull
        private final String hostname;
        private final int port;
        private InetSocketAddress inetSocketAddress;
        private long expiryTime;

        public CacheEntry(@NotNull String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public synchronized InetSocketAddress address() {
            if (this.isCachingEnabled()) {
                if (this.inetSocketAddress == null || this.expiryTime >= 0L && System.currentTimeMillis() > this.expiryTime) {
                    this.inetSocketAddress = TCPRegistry.createInetSocketAddress(this.hostname, this.port);
                    this.expiryTime = this.calculateExpiryTime();
                }
                return this.inetSocketAddress;
            }
            return TCPRegistry.createInetSocketAddress(this.hostname, this.port);
        }

        private long calculateExpiryTime() {
            String cacheTTL = Security.getProperty(AddressCache.NETWORK_ADDRESS_CACHE_TTL);
            if (cacheTTL != null) {
                long parsedCacheTTL = Long.parseLong(cacheTTL);
                return parsedCacheTTL < 0L ? -1L : System.currentTimeMillis() + 1000L * parsedCacheTTL;
            }
            return -1L;
        }

        private boolean isCachingEnabled() {
            String cacheTTL = Security.getProperty(AddressCache.NETWORK_ADDRESS_CACHE_TTL);
            return cacheTTL == null || Long.parseLong(cacheTTL) != 0L;
        }
    }
}

