/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster.handlers;

import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.threads.Timer;
import net.openhft.chronicle.core.threads.VanillaEventHandler;
import net.openhft.chronicle.network.ConnectionListener;
import net.openhft.chronicle.network.cluster.AbstractSubHandler;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.network.cluster.HeartbeatEventHandler;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HeartbeatHandler<T extends ClusteredNetworkContext<T>>
extends AbstractSubHandler<T>
implements Demarshallable,
WriteMarshallable,
HeartbeatEventHandler {
    private static final int MINIMUM_HEARTBEAT_TIMEOUT_MS = 1000;
    private static final int MINIMUM_HEARTBEAT_INTERVAL_MS = 500;
    private final long heartbeatIntervalMs;
    private final long heartbeatTimeoutMs;
    private final AtomicBoolean hasHeartbeats = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile long lastTimeMessageReceived;
    private volatile boolean hasTimedOut = false;
    @Nullable
    private ConnectionListener connectionListener;
    @Nullable
    private Timer timer;

    @UsedViaReflection
    public HeartbeatHandler(@NotNull WireIn w) {
        this(w.read("heartbeatTimeoutMs").int64(), w.read("heartbeatIntervalMs").int64());
        this.onMessageReceived();
    }

    private HeartbeatHandler(long heartbeatTimeoutMs, long heartbeatIntervalMs) {
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        HeartbeatHandler.validateHeartbeatParameters(this.heartbeatTimeoutMs, this.heartbeatIntervalMs);
    }

    private static void validateHeartbeatParameters(long heartbeatTimeoutMs, long heartbeatIntervalMs) {
        if (heartbeatTimeoutMs <= heartbeatIntervalMs) {
            throw new IllegalArgumentException("Heartbeat timeout must be greater than heartbeat interval, please fix this in your configuration, (heartbeatIntervalMs=" + heartbeatIntervalMs + ", heartbeatTimeoutMs=" + heartbeatTimeoutMs + ")");
        }
        if (heartbeatTimeoutMs < 1000L) {
            throw new IllegalArgumentException("heartbeatTimeoutMs=" + heartbeatTimeoutMs + ", this is too small (minimum=" + 1000 + ")");
        }
        if (heartbeatIntervalMs < 500L) {
            throw new IllegalArgumentException("heartbeatIntervalMs=" + heartbeatIntervalMs + ", this is too small (minimum=" + 500 + ")");
        }
    }

    public static WriteMarshallable heartbeatHandler(long heartbeatTimeoutMs, long heartbeatIntervalMs, long cid) {
        HeartbeatHandler.validateHeartbeatParameters(heartbeatTimeoutMs, heartbeatIntervalMs);
        return new WriteHeartbeatHandler(cid, heartbeatTimeoutMs, heartbeatIntervalMs);
    }

    @Override
    public void onInitialize(@NotNull WireOut outWire) {
        if (((ClusteredNetworkContext)this.nc()).eventLoop().isClosing()) {
            return;
        }
        if (((ClusteredNetworkContext)this.nc()).isAcceptor()) {
            HeartbeatHandler.heartbeatHandler(this.heartbeatTimeoutMs, this.heartbeatIntervalMs, this.cid()).writeMarshallable(outWire);
        }
        @NotNull HeartbeatHandler.HeartbeatMessage heartbeatMessage = new HeartbeatMessage();
        this.connectionListener = ((ClusteredNetworkContext)this.nc()).acquireConnectionListener();
        this.timer = new Timer(((ClusteredNetworkContext)this.nc()).eventLoop());
        this.startPeriodicHeartbeatCheck();
        this.startPeriodicallySendingHeartbeats(heartbeatMessage);
    }

    private void startPeriodicallySendingHeartbeats(WriteMarshallable heartbeatMessage) {
        @NotNull HeartbeatHandler.PeriodicallySendingHeartbeatsHandler task = new PeriodicallySendingHeartbeatsHandler(heartbeatMessage);
        this.timer.scheduleAtFixedRate((VanillaEventHandler)task, this.heartbeatIntervalMs, this.heartbeatIntervalMs, ((ClusteredNetworkContext)this.nc()).periodicPriority());
    }

    @Override
    public boolean isClosed() {
        return this.closable().isClosed();
    }

    public void writeMarshallable(@NotNull WireOut w) {
        w.write((CharSequence)"heartbeatTimeoutMs").int64(this.heartbeatTimeoutMs);
        assert (this.heartbeatIntervalMs > 0L);
        w.write((CharSequence)"heartbeatIntervalMs").int64(this.heartbeatIntervalMs);
    }

    @Override
    public void onRead(@NotNull WireIn inWire, @NotNull WireOut outWire) {
        if (inWire.isEmpty()) {
            return;
        }
        inWire.read("heartbeat").text();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.connectionListener != null) {
                try {
                    this.connectionListener.onDisconnected(this.localIdentifier(), this.remoteIdentifier(), ((ClusteredNetworkContext)this.nc()).isAcceptor());
                }
                catch (Exception e) {
                    Jvm.error().on(this.getClass(), "Exception thrown by ConnectionListener#onDisconnected", (Throwable)e);
                }
            }
            this.lastTimeMessageReceived = Long.MAX_VALUE;
        }
    }

    @Override
    public void onMessageReceived() {
        this.lastTimeMessageReceived = System.currentTimeMillis();
    }

    @Override
    public boolean hasTimedOut() {
        return this.hasTimedOut;
    }

    private VanillaEventHandler heartbeatCheck() {
        return new HeartbeatCheckHandler();
    }

    private void startPeriodicHeartbeatCheck() {
        this.timer.scheduleAtFixedRate(this.heartbeatCheck(), 0L, this.heartbeatTimeoutMs, ((ClusteredNetworkContext)this.nc()).periodicPriority());
    }

    private boolean hasReceivedHeartbeat() {
        boolean result;
        long currentTimeMillis = System.currentTimeMillis();
        boolean bl = result = this.lastTimeMessageReceived + this.heartbeatTimeoutMs >= currentTimeMillis;
        if (!result) {
            Jvm.warn().on(this.getClass(), Integer.toHexString(this.hashCode()) + " missed heartbeat, lastTimeMessageReceived=" + this.lastTimeMessageReceived + ", currentTimeMillis=" + currentTimeMillis);
        }
        return result;
    }

    public String name() {
        return "rid=" + this.remoteIdentifier() + ", lid=" + this.localIdentifier();
    }

    public String toString() {
        return "HeartbeatHandler{" + this.name() + "}";
    }

    class HeartbeatMessage
    implements WriteMarshallable {
        HeartbeatMessage() {
        }

        public void writeMarshallable(@NotNull WireOut w) {
            w.writeDocument(true, d -> d.write((WireKey)CoreFields.cid).int64(HeartbeatHandler.this.cid()));
            w.writeDocument(false, d -> d.write((CharSequence)"heartbeat").text(""));
        }

        public String toString() {
            return "HeartbeatMessage{" + HeartbeatHandler.this.cid() + "}";
        }
    }

    class PeriodicallySendingHeartbeatsHandler
    implements VanillaEventHandler {
        private final WriteMarshallable heartbeatMessage;

        public PeriodicallySendingHeartbeatsHandler(WriteMarshallable heartbeatMessage) {
            this.heartbeatMessage = heartbeatMessage;
        }

        public boolean action() throws InvalidEventHandlerException {
            if (HeartbeatHandler.this.isClosed()) {
                throw InvalidEventHandlerException.reusable();
            }
            WireOutPublisher wireOutPublisher = ((ClusteredNetworkContext)HeartbeatHandler.this.nc()).wireOutPublisher();
            if (wireOutPublisher.isEmpty()) {
                wireOutPublisher.publish(this.heartbeatMessage);
            }
            return true;
        }

        public String toString() {
            return "PeriodicallySendingHeartbeatsHandler{" + HeartbeatHandler.this.name() + "}";
        }
    }

    class HeartbeatCheckHandler
    implements VanillaEventHandler {
        HeartbeatCheckHandler() {
        }

        public boolean action() throws InvalidEventHandlerException {
            boolean prev;
            if (HeartbeatHandler.this.isClosed()) {
                throw InvalidEventHandlerException.reusable();
            }
            boolean hasHeartbeats = HeartbeatHandler.this.hasReceivedHeartbeat();
            if (hasHeartbeats != (prev = HeartbeatHandler.this.hasHeartbeats.getAndSet(hasHeartbeats))) {
                if (!hasHeartbeats) {
                    HeartbeatHandler.this.hasTimedOut = true;
                    throw InvalidEventHandlerException.reusable();
                }
                try {
                    if (HeartbeatHandler.this.connectionListener != null) {
                        HeartbeatHandler.this.connectionListener.onConnected(HeartbeatHandler.this.localIdentifier(), HeartbeatHandler.this.remoteIdentifier(), ((ClusteredNetworkContext)HeartbeatHandler.this.nc()).isAcceptor());
                    }
                }
                catch (RuntimeException e) {
                    Jvm.error().on(HeartbeatCheckHandler.class, "Exception thrown by ConnectionListener#onConnected", (Throwable)e);
                }
            }
            return true;
        }

        public String toString() {
            return "HeartbeatCheckHandler{" + HeartbeatHandler.this.name() + "}";
        }
    }

    private static class WriteHeartbeatHandler
    implements WriteMarshallable {
        private final long cid;
        private final long heartbeatTimeoutMs;
        private final long heartbeatIntervalMs;

        public WriteHeartbeatHandler(long cid, long heartbeatTimeoutMs, long heartbeatIntervalMs) {
            this.cid = cid;
            this.heartbeatTimeoutMs = heartbeatTimeoutMs;
            this.heartbeatIntervalMs = heartbeatIntervalMs;
        }

        public void writeMarshallable(@NotNull WireOut w) {
            w.writeDocument(true, d -> d.writeEventName((WireKey)CoreFields.csp).text("/").writeEventName((WireKey)CoreFields.cid).int64(this.cid).writeEventName((WireKey)CoreFields.handler).typedMarshallable(new HeartbeatHandler(this.heartbeatTimeoutMs, this.heartbeatIntervalMs)));
        }

        public String toString() {
            return "WriteHeartbeatHandler{cid=" + this.cid + '}';
        }
    }
}

