/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.ConnectionStrategy;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.network.tcp.ChronicleSocket;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChronicleSocketChannelBuilder {
    @NotNull
    private final InetSocketAddress socketAddress;
    private int tcpBufferSize = Jvm.getInteger((String)"tcp.client.buffer.size", (Integer)TcpChannelHub.TCP_BUFFER);
    private int socketConnectionTimeoutMs = Jvm.getInteger((String)"client.timeout", (Integer)500);
    @Nullable
    private InetSocketAddress localBinding;
    private boolean tcpNoDelay = !TcpEventHandler.DISABLE_TCP_NODELAY;

    public ChronicleSocketChannelBuilder(@NotNull InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    public ChronicleSocketChannelBuilder tcpBufferSize(int tcpBufferSize) {
        this.tcpBufferSize = tcpBufferSize;
        return this;
    }

    public ChronicleSocketChannelBuilder socketConnectionTimeoutMs(int socketConnectionTimeoutMs) {
        this.socketConnectionTimeoutMs = socketConnectionTimeoutMs;
        return this;
    }

    public ChronicleSocketChannelBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public ChronicleSocketChannelBuilder localBinding(InetSocketAddress localBinding) {
        this.localBinding = localBinding;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public ChronicleSocketChannel open() throws IOException {
        ChronicleSocketChannel chronicleSocketChannel;
        boolean failed;
        Selector selector;
        ChronicleSocketChannel result;
        block16: {
            ChronicleSocketChannel chronicleSocketChannel2;
            block15: {
                ChronicleSocketChannel chronicleSocketChannel3;
                block14: {
                    result = ChronicleSocketChannelFactory.wrap();
                    selector = null;
                    failed = true;
                    try {
                        if (this.localBinding != null) {
                            result.bind(this.localBinding);
                        }
                        result.configureBlocking(false);
                        ChronicleSocket socket = result.socket();
                        socket.setTcpNoDelay(this.tcpNoDelay);
                        socket.setReceiveBufferSize(this.tcpBufferSize);
                        socket.setSendBufferSize(this.tcpBufferSize);
                        socket.setSoTimeout(0);
                        socket.setSoLinger(false, 0);
                        result.connect(this.socketAddress);
                        selector = Selector.open();
                        result.register(selector, 8);
                        int select = selector.select(this.socketConnectionTimeoutMs);
                        if (select == 0) {
                            if (Jvm.isDebugEnabled(ConnectionStrategy.class)) {
                                Jvm.debug().on(ConnectionStrategy.class, "Timed out attempting to connect to " + this.socketAddress);
                            }
                            chronicleSocketChannel3 = null;
                            Closeable.closeQuietly((Object)selector);
                            if (!failed) return chronicleSocketChannel3;
                            break block14;
                        }
                        if (!result.finishConnect()) {
                            chronicleSocketChannel2 = null;
                            Closeable.closeQuietly((Object)selector);
                            break block15;
                        }
                        failed = false;
                        chronicleSocketChannel = result;
                        Closeable.closeQuietly((Object)selector);
                        break block16;
                    }
                    catch (Exception e) {
                        ChronicleSocketChannel chronicleSocketChannel4 = null;
                        return chronicleSocketChannel4;
                    }
                }
                Closeable.closeQuietly((Object)result);
                return chronicleSocketChannel3;
            }
            if (!failed) return chronicleSocketChannel2;
            Closeable.closeQuietly((Object)result);
            return chronicleSocketChannel2;
        }
        if (!failed) return chronicleSocketChannel;
        Closeable.closeQuietly((Object)result);
        return chronicleSocketChannel;
        finally {
            Closeable.closeQuietly(selector);
            if (failed) {
                Closeable.closeQuietly((Object)result);
            }
        }
    }
}

