/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.tcp;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.network.tcp.FastJ8SocketChannel;

public class UnsafeFastJ8SocketChannel
extends FastJ8SocketChannel {
    public UnsafeFastJ8SocketChannel(SocketChannel socketChannel) {
        super(socketChannel);
        this.singleThreadedCheckDisabled(true);
    }

    @Override
    int read0(ByteBuffer buf) throws IOException {
        return this.readInternal(buf);
    }

    @Override
    public int write(ByteBuffer buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (this.isBlocking() || this.isClosed() || !IOTools.isDirectBuffer((ByteBuffer)buf)) {
            return super.write(buf);
        }
        return this.writeInternal(buf);
    }

    private int writeInternal(ByteBuffer buf) throws IOException {
        int pos = buf.position();
        int lim = buf.limit();
        int len = lim <= pos ? 0 : lim - pos;
        int res = OS.write0((FileDescriptor)this.fd, (long)(IOTools.addressFor((ByteBuffer)buf) + (long)pos), (int)len);
        if (res > 0) {
            buf.position(pos + res);
        }
        if (res == -3 && this.socketChannel.isOpen()) {
            return 0;
        }
        if ((res = IOTools.normaliseIOStatus((int)res)) < 0) {
            this.open = false;
        }
        if (res <= 0 && !this.socketChannel.isOpen()) {
            throw new AsynchronousCloseException();
        }
        return res;
    }
}

