/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.internal.lookuptable;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiConsumer;
import net.openhft.chronicle.network.HostnamePortLookupTable;

public class ProcessLocalHostnamePortLookupTable
implements HostnamePortLookupTable,
Closeable {
    private final Map<String, InetSocketAddress> aliases = new ConcurrentSkipListMap<String, InetSocketAddress>();

    @Override
    public InetSocketAddress lookup(String description) {
        return this.aliases.get(description);
    }

    @Override
    public void clear() {
        this.aliases.clear();
    }

    @Override
    public Set<String> aliases() {
        return this.aliases.keySet();
    }

    @Override
    public void put(String description, InetSocketAddress address) {
        this.aliases.put(description, address);
    }

    @Override
    public void forEach(BiConsumer<String, InetSocketAddress> consumer) {
        this.aliases.forEach(consumer);
    }

    @Override
    public void close() throws IOException {
        this.clear();
    }
}

