/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.internal.lookuptable;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.network.HostnamePortLookupTable;
import net.openhft.chronicle.wire.JSONWire;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class FileBasedHostnamePortLookupTable
implements HostnamePortLookupTable,
Closeable,
ReferenceOwner {
    private static final long MINIMUM_INITIAL_FILE_SIZE_BYTES = 524288L;
    private static final long LOCK_TIMEOUT_MS = 10000L;
    private static final int DELETE_TABLE_FILE_TIMEOUT_MS = 1000;
    private static final int PID = Jvm.getProcessId();
    private static final String DEFAULT_FILE_NAME = "shared_hostname_mappings";
    private final JSONWire sharedTableWire;
    private final MappedBytes sharedTableBytes;
    private final File sharedTableFile;
    private final long actualBytesSize;
    private final ConcurrentSkipListMap<String, ProcessScopedMapping> allMappings = new ConcurrentSkipListMap();

    public FileBasedHostnamePortLookupTable() {
        this(DEFAULT_FILE_NAME);
    }

    public FileBasedHostnamePortLookupTable(String fileName) {
        this.sharedTableFile = new File(fileName);
        try {
            if (this.sharedTableFile.createNewFile() && !this.sharedTableFile.canWrite()) {
                throw new IllegalStateException("Cannot write to existing shared mapping file " + this.sharedTableFile);
            }
            long pagesForMinimum = (long)Math.ceil(8.0);
            this.actualBytesSize = pagesForMinimum * 65536L;
            this.sharedTableBytes = MappedBytes.mappedBytes((File)this.sharedTableFile, (long)this.actualBytesSize, (long)65536L, (boolean)false);
            this.sharedTableBytes.disableThreadSafetyCheck(true);
            this.sharedTableWire = new JSONWire((Bytes)this.sharedTableBytes);
            this.sharedTableWire.consumePadding();
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating shared mapping file", e);
        }
    }

    @Override
    public synchronized InetSocketAddress lookup(String description) {
        return this.lockFileAndDo(() -> {
            this.readFromTable();
            ProcessScopedMapping mapping = this.allMappings.get(description);
            return mapping != null ? mapping.inetSocketAddress() : null;
        }, true);
    }

    @Override
    public synchronized void clear() {
        this.lockFileAndDo(() -> {
            this.readFromTable();
            this.allMappings.keySet().forEach((? super T key) -> {
                if (this.allMappings.get(key).pid == PID) {
                    this.allMappings.remove(key);
                }
            });
            this.writeToTable();
        }, false);
    }

    @Override
    public synchronized Set<String> aliases() {
        return this.lockFileAndDo(() -> {
            this.readFromTable();
            return this.allMappings.keySet();
        }, true);
    }

    @Override
    public synchronized void put(String description, InetSocketAddress address) {
        this.lockFileAndDo(() -> {
            this.readFromTable();
            ProcessScopedMapping newMapping = new ProcessScopedMapping(PID, address);
            ProcessScopedMapping oldValue = this.allMappings.put(description, newMapping);
            if (oldValue != null) {
                Jvm.error().on(FileBasedHostnamePortLookupTable.class, String.format("Over-wrote hostname mapping for %s, old value=%s, new value=%s", description, oldValue, newMapping));
            }
            this.writeToTable();
        }, false);
    }

    @Override
    public synchronized void forEach(BiConsumer<String, InetSocketAddress> consumer) {
        this.lockFileAndDo(() -> {
            this.readFromTable();
            this.allMappings.forEach((? super K description, ? super V mapping) -> consumer.accept((String)description, mapping.inetSocketAddress()));
        }, true);
    }

    private void writeToTable() {
        assert (this.sharedTableWire.startUse());
        this.sharedTableBytes.reserve((ReferenceOwner)this);
        try {
            this.sharedTableWire.clear();
            this.sharedTableWire.writeAllAsMap(String.class, ProcessScopedMapping.class, this.allMappings);
            this.zeroOutRemainingBytes((int)this.sharedTableBytes.writePosition());
        }
        finally {
            this.sharedTableBytes.release((ReferenceOwner)this);
            assert (this.sharedTableWire.endUse());
        }
    }

    private void zeroOutRemainingBytes(int fromIndex) {
        this.sharedTableBytes.readLimit(this.sharedTableBytes.realCapacity());
        int i = fromIndex;
        while ((long)i < this.actualBytesSize) {
            this.sharedTableBytes.readPosition((long)i);
            if (this.sharedTableBytes.readByte() == 0) break;
            this.sharedTableBytes.writeByte((long)i, (byte)0);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromTable() {
        StringBuilder sb = Wires.acquireStringBuilder();
        ProcessScopedMapping reusableMapping = new ProcessScopedMapping();
        assert (this.sharedTableWire.startUse());
        this.sharedTableBytes.reserve((ReferenceOwner)this);
        try {
            this.sharedTableBytes.readPosition(0L);
            this.sharedTableBytes.readLimit(this.sharedTableBytes.realCapacity());
            HashSet<String> readMappings = new HashSet<String>();
            while (true) {
                ValueIn valueIn = this.sharedTableWire.readEventName(sb);
                if (sb.length() == 0) break;
                valueIn.object((Object)reusableMapping, ProcessScopedMapping.class);
                String name = sb.toString();
                readMappings.add(name);
                this.insertOrUpdateEntry(name, reusableMapping);
            }
            HashSet existingKeys = new HashSet(this.allMappings.keySet());
            for (String key : existingKeys) {
                if (readMappings.contains(key)) continue;
                this.allMappings.remove(key);
            }
        }
        finally {
            this.sharedTableBytes.release((ReferenceOwner)this);
            assert (this.sharedTableWire.endUse());
        }
    }

    private void insertOrUpdateEntry(String name, ProcessScopedMapping mapping) {
        ProcessScopedMapping existingMapping = this.allMappings.get(name);
        if (existingMapping == null || !existingMapping.equals(mapping)) {
            this.allMappings.put(name, new ProcessScopedMapping(mapping.pid, mapping.hostname, mapping.port));
        }
    }

    private void lockFileAndDo(Runnable runnable, boolean shared) {
        this.lockFileAndDo(() -> {
            runnable.run();
            return null;
        }, shared);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T> T lockFileAndDo(Supplier<T> supplier, boolean shared) {
        long timeoutAt = System.currentTimeMillis() + 10000L;
        long startMs = System.currentTimeMillis();
        Exception lastThrown = null;
        int count = 1;
        while (System.currentTimeMillis() < timeoutAt) {
            block22: {
                try {
                    Throwable throwable = null;
                    try (FileLock fileLock = this.sharedTableBytes.mappedFile().tryLock(0L, Long.MAX_VALUE, shared);){
                        T t;
                        if (fileLock == null) break block22;
                        try {
                            T t2 = supplier.get();
                            long elapsedMs = System.currentTimeMillis() - startMs;
                            if (elapsedMs > 100L) {
                                Jvm.warn().on(this.getClass(), "Took " + (double)elapsedMs / 1000.0 + " seconds to obtain the lock on " + this.sharedTableFile, (Throwable)lastThrown);
                            }
                            t = t2;
                        }
                        catch (OverlappingFileLockException e2) {
                            try {
                                throw new RuntimeException("Attempted to resize the underlying bytes, increase the MINIMUM_INITIAL_FILE_SIZE_BYTES or make this work with resizing!", e2);
                            }
                            catch (Throwable e2) {
                                throwable = e2;
                                throw e2;
                            }
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                        }
                        return t;
                    }
                }
                catch (IOException | OverlappingFileLockException e) {
                    lastThrown = e;
                }
            }
            int delay = Math.min(250, count * count);
            Time.sleep((long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
            ++count;
        }
        if (Jvm.isDebugEnabled(FileBasedHostnamePortLookupTable.class)) {
            long elapsedMs = System.currentTimeMillis() - startMs;
            String message = "Failed to acquire lock on the shared mappings file. Retrying, file=" + this.sharedTableFile + ", count=" + count + ", elapsed=" + elapsedMs + " ms";
            Jvm.debug().on(FileBasedHostnamePortLookupTable.class, message, (Throwable)lastThrown);
        }
        RuntimeException re = new RuntimeException("Couldn't acquire lock on shared mapping file " + this.sharedTableFile);
        re.initCause(lastThrown);
        throw re;
    }

    @Override
    public synchronized void close() throws IOException {
        net.openhft.chronicle.core.io.Closeable.closeQuietly((Object[])new Object[]{this.sharedTableWire, this.sharedTableBytes});
        long endTime = System.currentTimeMillis() + 1000L;
        while (this.sharedTableFile.exists()) {
            this.sharedTableFile.delete();
            if (System.currentTimeMillis() <= endTime) continue;
            Jvm.warn().on(FileBasedHostnamePortLookupTable.class, "Error deleting the shared lookup table");
            break;
        }
    }

    static class ProcessScopedMapping
    implements ReadMarshallable,
    WriteMarshallable {
        private int pid;
        private String hostname;
        private int port;
        private InetSocketAddress address;

        public ProcessScopedMapping() {
        }

        public ProcessScopedMapping(int pid, InetSocketAddress address) {
            if (address == null) {
                throw new IllegalArgumentException("Address must not be null");
            }
            this.pid = pid;
            this.hostname = address.getHostName();
            this.port = address.getPort();
            this.address = address;
        }

        public ProcessScopedMapping(int pid, String hostname, int port) {
            this.pid = pid;
            this.hostname = hostname;
            this.port = port;
        }

        public InetSocketAddress inetSocketAddress() {
            if (this.address == null) {
                this.address = new InetSocketAddress(this.hostname, this.port);
            }
            return this.address;
        }

        public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
            this.pid = wire.read("pid").int32();
            this.hostname = wire.read("hostname").text();
            this.port = wire.read("port").readInt();
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write((CharSequence)"pid").int32(this.pid).write((CharSequence)"hostname").text(this.hostname).write((CharSequence)"port").int32(this.port);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessScopedMapping that = (ProcessScopedMapping)o;
            return this.pid == that.pid && this.port == that.port && this.hostname.equals(that.hostname);
        }

        public int hashCode() {
            return Objects.hash(this.pid, this.hostname, this.port);
        }
    }
}

