/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;

public enum LoggingNetworkStatsListener implements NetworkStatsListener
{
    INSTANCE;


    public void networkContext(NetworkContext networkContext) {
        this.throwExceptionIfClosed();
    }

    @Override
    public void onNetworkStats(long writeBps, long readBps, long socketPollCountPerSecond) {
        this.throwExceptionIfClosed();
        if (Jvm.isDebugEnabled(LoggingNetworkStatsListener.class)) {
            Jvm.debug().on(LoggingNetworkStatsListener.class, String.format("networkStats: writeBps %d, readBps %d, pollCount/sec %d", writeBps, readBps, socketPollCountPerSecond));
        }
    }

    @Override
    public void onHostPort(String hostName, int port) {
        this.throwExceptionIfClosed();
        if (Jvm.isDebugEnabled(LoggingNetworkStatsListener.class)) {
            Jvm.debug().on(LoggingNetworkStatsListener.class, String.format("onHostPort %s, %d", hostName, port));
        }
    }

    @Override
    public void onRoundTripLatency(long latencyNanos) {
        this.throwExceptionIfClosed();
        if (Jvm.isDebugEnabled(LoggingNetworkStatsListener.class)) {
            Jvm.debug().on(LoggingNetworkStatsListener.class, String.format("onRoundTripLatency %d", latencyNanos));
        }
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }
}

