/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaWireOutPublisher
extends AbstractCloseable
implements WireOutPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaWireOutPublisher.class);
    private final Bytes<ByteBuffer> bytes = Bytes.elasticByteBuffer((int)TcpChannelHub.TCP_BUFFER);
    private Wire wire;

    public VanillaWireOutPublisher(@NotNull WireType wireType) {
        WireType wireType0 = wireType == WireType.DELTA_BINARY ? WireType.BINARY : wireType;
        this.wire = (Wire)wireType0.apply(this.bytes);
        this.wire.usePadding(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyAction(@NotNull Bytes<?> bytes) {
        if (this.bytes.readRemaining() > 0L) {
            Object object = this.lock();
            synchronized (object) {
                if (YamlLogging.showServerWrites()) {
                    this.logBuffer();
                }
                if (bytes.writePosition() > (long)TcpChannelHub.TCP_BUFFER) {
                    return;
                }
                bytes.write(this.bytes);
                this.bytes.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logBuffer() {
        long pos = this.bytes.readPosition();
        try {
            while (this.wire.bytes().readRemaining() > 0L) {
                DocumentContext dc = this.wire.readingDocument();
                Throwable throwable = null;
                try {
                    Bytes bytes = this.wire.bytes();
                    if (!dc.isPresent()) {
                        bytes.readPosition(bytes.readLimit());
                        return;
                    }
                    LOG.info("Server Sends async event:\n" + Wires.fromSizePrefixedBlobs((DocumentContext)dc));
                    bytes.readPosition(bytes.readLimit());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                }
            }
            return;
        }
        finally {
            this.bytes.readPosition(pos);
        }
    }

    @Override
    public void applyAction(@NotNull WireOut outWire) {
        this.applyAction(outWire.bytes());
    }

    @Override
    public boolean canTakeMoreData() {
        this.throwExceptionIfClosed();
        Object object = this.lock();
        synchronized (object) {
            boolean bl;
            assert (this.wire.startUse());
            try {
                boolean bl2 = bl = this.wire.bytes().writePosition() < (long)TcpChannelHub.TCP_SAFE_SIZE;
            }
            catch (Throwable throwable) {
                assert (this.wire.endUse());
                throw throwable;
            }
            assert (this.wire.endUse());
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, @NotNull WriteMarshallable event) {
        try {
            this.throwExceptionIfClosed();
        }
        catch (ClosedIllegalStateException ise) {
            Jvm.debug().on(this.getClass(), "message ignored as closed", (Throwable)ise);
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            block13: {
                assert (this.wire.startUse());
                try {
                    long start = this.wire.bytes().writePosition();
                    event.writeMarshallable((WireOut)this.wire);
                    if (!YamlLogging.showServerWrites()) break block13;
                    long rp = this.wire.bytes().readPosition();
                    long rl = this.wire.bytes().readLimit();
                    long wl = this.wire.bytes().writeLimit();
                    try {
                        long len = this.wire.bytes().writePosition() - start;
                        this.wire.bytes().readPositionRemaining(start, len);
                        String message = Wires.fromSizePrefixedBlobs((WireIn)this.wire);
                        LOG.info("Server is about to send async event:" + message);
                    }
                    finally {
                        ((Bytes)((Bytes)this.wire.bytes().writeLimit(wl)).readLimit(rl)).readPosition(rp);
                    }
                }
                finally {
                    assert (this.wire.endUse());
                }
            }
        }
    }

    private Object lock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performClose() {
        Object object = this.lock();
        synchronized (object) {
            this.bytes.releaseLast();
            this.wire = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wireType(@NotNull WireType wireType) {
        WireType wireType0;
        this.throwExceptionIfClosedInSetter();
        WireType wireType2 = wireType0 = wireType == WireType.DELTA_BINARY ? WireType.BINARY : wireType;
        if (WireType.valueOf((Wire)this.wire) == wireType0) {
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            this.wire = (Wire)wireType0.apply(this.bytes);
            this.wire.usePadding(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock();
        synchronized (object) {
            this.wire.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock();
        synchronized (object) {
            return this.bytes.isEmpty();
        }
    }

    @NotNull
    public String toString() {
        return "VanillaWireOutPublisher{, closed=" + this.isClosed() + ", " + this.wire.getClass().getSimpleName() + "=" + this.bytes + '}';
    }

    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }
}

