/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Cluster<T extends ClusteredNetworkContext<T>, C extends ClusterContext<C, T>>
extends SimpleCloseable
implements Marshallable {
    @NotNull
    public final Map<String, HostDetails> hostDetails = new ConcurrentSkipListMap<String, HostDetails>();
    private C context;

    public C clusterContext() {
        return this.context;
    }

    public void clusterContext(@NotNull C clusterContext) {
        this.throwExceptionIfClosed();
        this.context = clusterContext;
    }

    public synchronized void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        this.hostDetails.clear();
        if (wire.isEmpty()) {
            return;
        }
        while (!wire.isEmpty()) {
            StringBuilder sb = Wires.acquireStringBuilder();
            @NotNull ValueIn valueIn = wire.readEventName(sb);
            if ("context".contentEquals(sb)) {
                this.context = (ClusterContext)((Object)valueIn.object(ClusterContext.class));
                assert (this.context != null);
                continue;
            }
            valueIn.marshallable(details -> {
                @NotNull HostDetails hd = new HostDetails();
                hd.readMarshallable(details);
                this.hostDetails.put(sb.toString(), hd);
            });
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((CharSequence)"context").typedMarshallable(this.context);
        for (Map.Entry<String, HostDetails> entry2 : this.hostDetails.entrySet()) {
            wire.writeEventName(entry2::getKey).marshallable((WriteMarshallable)entry2.getValue());
        }
    }

    @Nullable
    public HostDetails findHostDetails(int id) {
        this.throwExceptionIfClosed();
        for (HostDetails hd : this.hostDetails.values()) {
            if (hd.hostId() != id) continue;
            return hd;
        }
        return null;
    }

    @NotNull
    public Collection<HostDetails> hostDetails() {
        this.throwExceptionIfClosed();
        return this.hostDetails.values();
    }

    protected synchronized void performClose() {
        Closeable.closeQuietly((Object[])new Object[]{this.context, this.hostDetails});
        this.hostDetails.clear();
    }

    public synchronized void start(int localHostId) {
        Optional<HostDetails> acceptOn = this.hostDetails.values().stream().filter(hd -> hd.hostId() == localHostId).findAny();
        if (!acceptOn.isPresent()) {
            throw new IllegalArgumentException("Cannot start cluster member as provided hostid=" + localHostId + " is not found in the cluster");
        }
        if (this.context == null) {
            throw new IllegalStateException("Cannot start cluster member as the cluster context is null");
        }
        ((ClusterContext)((Object)this.context)).localIdentifier((byte)localHostId);
        this.hostDetails.values().stream().filter(hd -> hd.hostId() != localHostId).forEach(arg_0 -> this.context.connect(arg_0));
        ((ClusterContext)((Object)this.context)).eventLoop().start();
        ((ClusterContext)((Object)this.context)).accept(acceptOn.get());
    }
}

