/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.lang.reflect.Constructor;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.logger.LoggerFactoryUtil;
import net.openhft.chronicle.network.connection.WireOutConsumer;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface WireOutPublisher
extends Closeable {
    public static final Logger LOG = LoggerFactoryUtil.initialize((Logger)LoggerFactory.getLogger(WireOutPublisher.class));

    @Deprecated
    public static WireOutPublisher newThrottledWireOutPublisher(int periodMs, @NotNull WireOutPublisher delegate) {
        try {
            Class<?> aClass = Class.forName("software.chronicle.enterprise.throttle.ThrottledWireOutPublisher");
            @NotNull Constructor<?> constructor = aClass.getConstructors()[0];
            return (WireOutPublisher)constructor.newInstance(periodMs, delegate);
        }
        catch (Exception e) {
            Jvm.warn().on(WireOutPublisher.class, "To use this feature please install Chronicle-Engine-Enterprise");
            throw Jvm.rethrow((Throwable)e);
        }
    }

    default public void applyAction(@NotNull Bytes<?> out) {
        throw new UnsupportedOperationException();
    }

    default public void applyAction(@NotNull WireOut out) {
        this.applyAction(out.bytes());
    }

    default public void addWireConsumer(WireOutConsumer wireOutConsumer) {
        throw new UnsupportedOperationException();
    }

    default public boolean removeBytesConsumer(WireOutConsumer wireOutConsumer) {
        throw new UnsupportedOperationException();
    }

    default public boolean canTakeMoreData() {
        return false;
    }

    public void put(@Nullable Object var1, WriteMarshallable var2);

    default public boolean isClosed() {
        throw new UnsupportedOperationException();
    }

    default public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    default public void close() {
        throw new UnsupportedOperationException();
    }

    default public void wireType(WireType wireType) {
        throw new UnsupportedOperationException();
    }

    default public void clear() {
        throw new UnsupportedOperationException();
    }

    default public void publish(WriteMarshallable event) {
        this.put("", event);
    }
}

