/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ConnectionDroppedException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.core.logger.LoggerFactoryUtil;
import net.openhft.chronicle.core.util.ThrowingSupplier;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.network.connection.TryLock;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.WriteValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatelessClient<E extends ParameterizeWireKey>
extends SimpleCloseable
implements Closeable {
    private static final WriteValue NOOP = out -> {};
    private static final Logger LOG = LoggerFactoryUtil.initialize((Logger)LoggerFactory.getLogger(AbstractStatelessClient.class));
    @NotNull
    protected final TcpChannelHub hub;
    @NotNull
    protected final String csp;
    private final long cid;
    private final ThreadLocal<OneParameterWriteValue> oneParameterWriteValueTL;
    private final Map<Class<?>, Function<ValueIn, ?>> consumerInFunctionMap;
    private final ThreadLocal<ConsumerInUsingFunction<?>> consumerInFunctionUsingTL;

    protected AbstractStatelessClient(@NotNull TcpChannelHub hub, long cid, @NotNull String csp) {
        this.cid = cid;
        this.csp = csp;
        this.hub = hub;
        this.oneParameterWriteValueTL = ThreadLocal.withInitial(() -> new OneParameterWriteValue());
        this.consumerInFunctionMap = new ConcurrentHashMap();
        this.consumerInFunctionUsingTL = ThreadLocal.withInitial(() -> new ConsumerInUsingFunction());
    }

    protected WriteValue toParameters(@NotNull E eventId, @Nullable Object arg) {
        OneParameterWriteValue oneParameterWriteValue = this.oneParameterWriteValueTL.get();
        oneParameterWriteValue.arg(arg);
        return oneParameterWriteValue;
    }

    protected WriteValue toParameters(@NotNull E eventId, Object ... args) {
        if (args == null || args.length == 0) {
            return NOOP;
        }
        if (args.length == 1) {
            return this.toParameters(eventId, args[0]);
        }
        return out -> out.marshallable(m -> {
            @NotNull WireKey[] paramNames = eventId.params();
            for (int i = 0; i < paramNames.length; ++i) {
                @NotNull ValueOut vo = m.write(paramNames[i]);
                vo.object(args[i]);
            }
        });
    }

    @Nullable
    protected <R> R proxyReturnWireTypedObject(@NotNull E eventId, @Nullable R usingValue, @NotNull Class<R> resultType, Object ... args) {
        Function<ValueIn, R> consumerIn = this.consumerInFunction(usingValue, resultType);
        return this.proxyReturnWireConsumerInOut((WireKey)eventId, CoreFields.reply, this.toParameters(eventId, args), (Function)consumerIn);
    }

    @Nullable
    protected <R> R proxyReturnTypedObject(@NotNull E eventId, @Nullable R usingValue, @NotNull Class<R> resultType, Object ... args) {
        Function<ValueIn, R> consumerIn = this.consumerInFunction(usingValue, resultType);
        return this.proxyReturnWireConsumerInOut((WireKey)eventId, CoreFields.reply, this.toParameters(eventId, args), (Function)consumerIn);
    }

    @Nullable
    protected <R> R proxyReturnTypedObject(@NotNull E eventId, @Nullable R usingValue, @NotNull Class<R> resultType) {
        Function<ValueIn, R> consumerIn = this.consumerInFunction(usingValue, resultType);
        return this.proxyReturnWireConsumerInOut((WireKey)eventId, CoreFields.reply, NOOP, (Function)consumerIn);
    }

    @Nullable
    protected <R> R proxyReturnTypedObject(@NotNull E eventId, @Nullable R usingValue, @NotNull Class<R> resultType, @NotNull Object arg) {
        Function<ValueIn, R> consumerIn = this.consumerInFunction(usingValue, resultType);
        return this.proxyReturnWireConsumerInOut((WireKey)eventId, CoreFields.reply, this.toParameters(eventId, arg), (Function)consumerIn);
    }

    @NotNull
    private <R> Function<ValueIn, R> consumerInFunction(@Nullable R usingValue, @NotNull Class<R> resultType) {
        if (resultType == CharSequence.class && usingValue != null) {
            return f -> {
                f.textTo((StringBuilder)usingValue);
                return usingValue;
            };
        }
        if (usingValue == null) {
            Function consumerInFunction = this.consumerInFunctionMap.computeIfAbsent(resultType, c -> f -> f.object(c));
            return consumerInFunction;
        }
        ConsumerInUsingFunction<?> consumerInUsingFunctionThreadLocal = this.consumerInFunctionUsingTL.get();
        ((ConsumerInUsingFunction)consumerInUsingFunctionThreadLocal).using(usingValue);
        ((ConsumerInUsingFunction)consumerInUsingFunctionThreadLocal).resultType(resultType);
        return consumerInUsingFunctionThreadLocal;
    }

    protected <T> T attempt(@NotNull ThrowingSupplier<T, TimeoutException> s) {
        @Nullable ConnectionDroppedException t = null;
        @Nullable TimeoutException te = null;
        for (int i = 1; i <= 20; ++i) {
            try {
                return (T)s.get();
            }
            catch (ConnectionDroppedException e) {
                t = e;
            }
            catch (TimeoutException e) {
                te = e;
            }
            Jvm.pause((long)(i * 25));
        }
        if (t != null) {
            throw t;
        }
        throw new ConnectionDroppedException((Throwable)te);
    }

    protected long proxyReturnLong(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, ValueIn::int64);
    }

    protected int proxyReturnInt(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, ValueIn::int32);
    }

    protected int proxyReturnInt(@NotNull E eventId, Object ... args) {
        return this.proxyReturnWireConsumerInOut((WireKey)eventId, CoreFields.reply, this.toParameters(eventId, args), (Function)ValueIn::int32);
    }

    protected byte proxyReturnByte(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, ValueIn::int8);
    }

    protected byte proxyReturnByte(@NotNull WireKey reply, @NotNull WireKey eventId) {
        return this.proxyReturnWireConsumerInOut(eventId, reply, null, ValueIn::int8);
    }

    protected int proxyReturnUint16(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, ValueIn::uint16);
    }

    protected <T> T proxyReturnWireConsumer(@NotNull WireKey eventId, @NotNull Function<ValueIn, T> consumer) {
        long startTime = System.currentTimeMillis();
        return this.attempt(() -> this.readWire(this.sendEvent(startTime, eventId, null), startTime, CoreFields.reply, consumer));
    }

    protected <T> T proxyReturnWireConsumerInOut(@NotNull WireKey eventId, @NotNull WireKey reply, @Nullable WriteValue consumerOut, @NotNull Function<ValueIn, T> consumerIn) {
        long startTime = System.currentTimeMillis();
        return this.attempt(() -> this.readWire(this.sendEvent(startTime, eventId, consumerOut), startTime, reply, consumerIn));
    }

    protected void proxyReturnVoid(@NotNull WireKey eventId, @Nullable WriteValue consumer) {
        long startTime = System.currentTimeMillis();
        this.attempt(() -> this.readWire(this.sendEvent(startTime, eventId, consumer), startTime, CoreFields.reply, v -> v.marshallable(ReadMarshallable.DISCARD)));
    }

    protected void proxyReturnVoid(@NotNull WireKey eventId) {
        this.proxyReturnVoid(eventId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sendEvent(long startTime, @NotNull WireKey eventId, @Nullable WriteValue consumer) {
        long tid;
        if (this.hub.outBytesLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot view map while debugging");
        }
        try {
            boolean success = this.hub.outBytesLock().tryLock(10L, TimeUnit.SECONDS);
            if (!success) {
                throw new IORuntimeException("failed to obtain write lock");
            }
        }
        catch (InterruptedException e) {
            throw new IORuntimeException((Throwable)e);
        }
        try {
            tid = this.writeMetaDataStartTime(startTime);
            Wire wire = this.hub.outWire();
            try (DocumentContext dc = wire.writingDocument();){
                @NotNull ValueOut valueOut = wire.writeEventName(eventId);
                if (consumer == null) {
                    valueOut.marshallable(WriteMarshallable.EMPTY);
                } else {
                    consumer.writeValue(valueOut);
                }
            }
            this.hub.writeSocket((WireOut)wire, true, false);
        }
        finally {
            this.hub.outBytesLock().unlock();
        }
        return tid;
    }

    protected boolean sendEventAsync(@NotNull WireKey eventId, @Nullable WriteValue consumer, boolean reattemptUponFailure) {
        if (!reattemptUponFailure && !this.hub.isOpen()) {
            return false;
        }
        if (!reattemptUponFailure) {
            this.hub.lock(() -> this.quietSendEventAsyncWithoutLock(eventId, consumer));
            return true;
        }
        this.attempt(() -> {
            this.hub.lock2(() -> this.quietSendEventAsyncWithoutLock(eventId, consumer), true, TryLock.LOCK);
            return true;
        });
        return false;
    }

    protected boolean sendBytes(@NotNull Bytes bytes, boolean reattemptUponFailure) {
        if (reattemptUponFailure) {
            this.hub.lock(this.hub::checkConnection);
        } else if (!this.hub.isOpen()) {
            return false;
        }
        if (!reattemptUponFailure) {
            this.hub.lock(() -> this.quietSendBytesAsyncWithoutLock(bytes));
            return true;
        }
        this.attempt(() -> {
            this.hub.lock(() -> this.quietSendBytesAsyncWithoutLock(bytes));
            return true;
        });
        return false;
    }

    private void quietSendEventAsyncWithoutLock(@NotNull WireKey eventId, WriteValue consumer) {
        try {
            this.sendEventAsyncWithoutLock(eventId, consumer);
        }
        catch (ConnectionDroppedException e) {
            if (LOG.isDebugEnabled()) {
                Jvm.warn().on(this.getClass(), "", (Throwable)e);
            } else {
                LOG.info(e.toString());
            }
        }
        catch (IORuntimeException e) {
            LOG.trace("socket is not currently connected.", (Throwable)e);
        }
    }

    private void quietSendBytesAsyncWithoutLock(@NotNull Bytes bytes) {
        try {
            this.sendBytesAsyncWithoutLock(bytes);
        }
        catch (ConnectionDroppedException e) {
            if (Jvm.isDebug()) {
                Jvm.debug().on(this.getClass(), (Throwable)e);
            }
        }
        catch (IORuntimeException e) {
            Jvm.debug().on(this.getClass(), "socket is not currently connected.", (Throwable)e);
        }
    }

    private void sendBytesAsyncWithoutLock(@NotNull Bytes bytes) {
        this.writeAsyncMetaData();
        this.hub.outWire().bytes().write((BytesStore)bytes);
        this.hub.writeSocket((WireOut)this.hub.outWire(), true, false);
    }

    private void sendEventAsyncWithoutLock(@NotNull WireKey eventId, @Nullable WriteValue consumer) {
        this.writeAsyncMetaData();
        this.hub.outWire().writeDocument(false, wireOut -> {
            @NotNull ValueOut valueOut = wireOut.writeEventName(eventId);
            if (consumer == null) {
                valueOut.marshallable(WriteMarshallable.EMPTY);
            } else {
                consumer.writeValue(valueOut);
            }
        });
        this.hub.writeSocket((WireOut)this.hub.outWire(), true, false);
    }

    private long writeMetaDataStartTime(long startTime) {
        return this.hub.writeMetaDataStartTime(startTime, this.hub.outWire(), this.csp, this.cid);
    }

    protected void writeMetaDataForKnownTID(long tid) {
        this.hub.writeMetaDataForKnownTID(tid, this.hub.outWire(), this.csp, this.cid, false);
    }

    private void writeAsyncMetaData() {
        this.hub.writeAsyncHeader(this.hub.outWire(), this.csp, this.cid);
    }

    private void checkIsData(@NotNull Wire wireIn) {
        @NotNull Bytes bytes = wireIn.bytes();
        int dataLen = bytes.readVolatileInt();
        if (!Wires.isData((int)dataLen)) {
            throw new IllegalStateException("expecting a data blob, from ->" + Bytes.toString((Bytes)bytes, (long)0L, (long)bytes.readLimit()));
        }
    }

    protected boolean readBoolean(long tid, long startTime) throws ConnectionDroppedException, TimeoutException {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        Wire wireIn = this.hub.proxyReply(timeoutTime, tid);
        this.checkIsData(wireIn);
        return this.readReply((WireIn)wireIn, CoreFields.reply, ValueIn::bool);
    }

    private long readLong(long tid, long startTime) throws ConnectionDroppedException, TimeoutException {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        Wire wireIn = this.hub.proxyReply(timeoutTime, tid);
        this.checkIsData(wireIn);
        return this.readReply((WireIn)wireIn, CoreFields.reply, ValueIn::int64);
    }

    private <R> R readReply(@NotNull WireIn wireIn, @NotNull WireKey replyId, @NotNull Function<ValueIn, R> function) {
        StringBuilder eventName = Wires.acquireStringBuilder();
        @NotNull ValueIn event = wireIn.read(eventName);
        if (replyId.contentEquals((CharSequence)eventName)) {
            return function.apply(event);
        }
        if (CoreFields.exception.contentEquals(eventName)) {
            throw Jvm.rethrow((Throwable)event.throwable(true));
        }
        throw new UnsupportedOperationException("unknown event=" + eventName);
    }

    protected boolean proxyReturnBooleanWithArgs(@NotNull E eventId, Object ... args) {
        long startTime = System.currentTimeMillis();
        return (Boolean)this.attempt(() -> this.readBoolean(this.sendEvent(startTime, (WireKey)eventId, this.toParameters(eventId, args)), startTime));
    }

    protected long proxyReturnLongWithArgs(@NotNull E eventId, Object ... args) {
        long startTime = System.currentTimeMillis();
        return (Long)this.attempt(() -> this.readLong(this.sendEvent(startTime, (WireKey)eventId, this.toParameters(eventId, args)), startTime));
    }

    protected boolean proxyReturnBooleanWithSequence(@NotNull E eventId, @NotNull Collection sequence) {
        long startTime = System.currentTimeMillis();
        return (Boolean)this.attempt(() -> this.readBoolean(this.sendEvent(startTime, (WireKey)eventId, out -> sequence.forEach(arg_0 -> ((ValueOut)out).object(arg_0))), startTime));
    }

    protected boolean proxyReturnBoolean(@NotNull WireKey eventId) {
        long startTime = System.currentTimeMillis();
        return (Boolean)this.attempt(() -> this.readBoolean(this.sendEvent(startTime, eventId, null), startTime));
    }

    private <T> T readWire(long tid, long startTime, @NotNull WireKey reply, @NotNull Function<ValueIn, T> c) throws ConnectionDroppedException, TimeoutException {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        Wire wire = this.hub.proxyReply(timeoutTime, tid);
        this.checkIsData(wire);
        return this.readReply((WireIn)wire, reply, c);
    }

    protected int readInt(long tid, long startTime) throws ConnectionDroppedException, TimeoutException {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        Wire wireIn = this.hub.proxyReply(timeoutTime, tid);
        this.checkIsData(wireIn);
        return wireIn.read((WireKey)CoreFields.reply).int32();
    }

    protected void performClose() {
        this.hub.close();
    }

    private static final class ConsumerInUsingFunction<R>
    implements Function<ValueIn, R> {
        private Class<?> resultType;
        private R using;

        private ConsumerInUsingFunction() {
        }

        private void using(R using) {
            this.using = using;
        }

        private void resultType(Class<?> resultType) {
            this.resultType = resultType;
        }

        @Override
        public R apply(ValueIn valueIn) {
            return (R)valueIn.object(this.using, this.resultType);
        }
    }

    private static final class OneParameterWriteValue
    implements WriteValue {
        private Object arg;

        private OneParameterWriteValue() {
        }

        public void writeValue(@NotNull ValueOut out) {
            out.object(this.arg);
        }

        private void arg(Object arg) {
            this.arg = arg;
        }
    }
}

