/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.FastJ8SocketChannel;
import net.openhft.chronicle.network.tcp.UnsafeFastJ8SocketChannel;
import net.openhft.chronicle.network.tcp.VanillaSocketChannel;
import org.jetbrains.annotations.NotNull;

public enum ChronicleSocketChannelFactory {

    public static boolean FAST_JAVA8_IO = ChronicleSocketChannelFactory.isFastJava8IO();

    private static boolean isFastJava8IO() {
        boolean fastJava8IO;
        boolean bl = fastJava8IO = Jvm.getBoolean((String)"fastJava8IO") && !Jvm.isJava9Plus() && OS.isLinux();
        if (fastJava8IO) {
            System.out.println("FastJava8IO: enabled");
        }
        return fastJava8IO;
    }

    public static ChronicleSocketChannel wrap() throws IOException {
        return ChronicleSocketChannelFactory.wrap(false, SocketChannel.open());
    }

    public static ChronicleSocketChannel wrap(InetSocketAddress socketAddress) throws IOException {
        return ChronicleSocketChannelFactory.wrap(false, SocketChannel.open(socketAddress));
    }

    public static ChronicleSocketChannel wrap(boolean isNative, InetSocketAddress socketAddress) throws IOException {
        SocketChannel sc = SocketChannel.open(socketAddress);
        return ChronicleSocketChannelFactory.wrap(isNative, sc);
    }

    public static ChronicleSocketChannel wrap(@NotNull SocketChannel sc) {
        return ChronicleSocketChannelFactory.wrap(false, sc);
    }

    public static ChronicleSocketChannel wrap(boolean isNative, @NotNull SocketChannel sc) {
        return isNative ? ChronicleSocketChannelFactory.newNativeInstance(sc) : (FAST_JAVA8_IO ? ChronicleSocketChannelFactory.newFastInstance(sc) : ChronicleSocketChannelFactory.newInstance(sc));
    }

    public static ChronicleSocketChannel wrapUnsafe(@NotNull SocketChannel sc) {
        return FAST_JAVA8_IO ? ChronicleSocketChannelFactory.newFastUnsafeInstance(sc) : ChronicleSocketChannelFactory.newInstance(sc);
    }

    @NotNull
    private static ChronicleSocketChannel newInstance(@NotNull SocketChannel sc) {
        return new VanillaSocketChannel(sc);
    }

    @NotNull
    private static ChronicleSocketChannel newFastInstance(@NotNull SocketChannel sc) {
        return new FastJ8SocketChannel(sc);
    }

    private static ChronicleSocketChannel newNativeInstance(@NotNull SocketChannel sc) {
        try {
            return (ChronicleSocketChannel)Class.forName("software.chronicle.network.impl.NativeChronicleSocketChannel").newInstance();
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @NotNull
    private static ChronicleSocketChannel newFastUnsafeInstance(@NotNull SocketChannel sc) {
        return new UnsafeFastJ8SocketChannel(sc);
    }
}

