/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Handshaker {
    private static final int HANDSHAKE_BUFFER_CAPACITY = 32768;
    private static final Logger LOGGER = LoggerFactory.getLogger(Handshaker.class);
    private final ByteBuffer applicationData = ByteBuffer.allocateDirect(32768);
    private final ByteBuffer networkData = ByteBuffer.allocateDirect(32768);
    private final ByteBuffer peerApplicationData = ByteBuffer.allocateDirect(32768);
    private final ByteBuffer peerNetworkData = ByteBuffer.allocateDirect(32768);

    Handshaker() {
    }

    private static String socketToString(ChronicleSocketChannel channel) {
        return channel.socket().getLocalPort() + "->" + ((InetSocketAddress)channel.socket().getRemoteSocketAddress()).getPort();
    }

    void performHandshake(SSLEngine engine, ChronicleSocketChannel channel) throws IOException {
        while (!channel.finishConnect()) {
            Thread.yield();
        }
        LOGGER.debug("{} is client: {}", (Object)Handshaker.socketToString(channel), (Object)engine.getUseClientMode());
        engine.beginHandshake();
        SSLEngineResult.HandshakeStatus status = engine.getHandshakeStatus();
        long underflowCount = 0L;
        boolean reportedInitialStatus = false;
        SSLEngineResult.HandshakeStatus lastStatus = status;
        block15: while (status != SSLEngineResult.HandshakeStatus.FINISHED && status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (!reportedInitialStatus) {
                LOGGER.debug("{} initial status {}", (Object)Handshaker.socketToString(channel), (Object)status);
                reportedInitialStatus = true;
            }
            if (status != lastStatus) {
                LOGGER.debug("{} status change to {}", (Object)Handshaker.socketToString(channel), (Object)status);
                lastStatus = status;
            }
            block1 : switch (status) {
                case NEED_UNWRAP: {
                    int read = channel.read(this.peerNetworkData);
                    if (read < 0) {
                        throw new IOException("Channel closed");
                    }
                    if (read == 0 && (this.peerNetworkData.remaining() == 0 || this.peerNetworkData.remaining() == this.peerNetworkData.capacity())) {
                        ++underflowCount;
                        continue block15;
                    }
                    this.peerNetworkData.flip();
                    int dataReceived = this.peerNetworkData.remaining();
                    LOGGER.debug("{} Received {} from handshake peer", (Object)Handshaker.socketToString(channel), (Object)dataReceived);
                    SSLEngineResult result = engine.unwrap(this.peerNetworkData, this.peerApplicationData);
                    this.peerNetworkData.compact();
                    switch (result.getStatus()) {
                        case OK: {
                            break block1;
                        }
                        case BUFFER_UNDERFLOW: {
                            if ((underflowCount & 0xFFFFL) == 0L) {
                                LOGGER.debug("Not enough data read from remote end ({})", (Object)dataReceived);
                            }
                            ++underflowCount;
                            break block1;
                        }
                    }
                    LOGGER.error("Bad handshake status: {}/{}", (Object)result.getStatus(), (Object)result.getHandshakeStatus());
                    break;
                }
                case NEED_WRAP: {
                    this.networkData.clear();
                    SSLEngineResult result = engine.wrap(this.applicationData, this.networkData);
                    switch (result.getStatus()) {
                        case OK: {
                            this.networkData.flip();
                            int remaining = this.networkData.remaining();
                            while (this.networkData.hasRemaining()) {
                                if (channel.write(this.networkData) >= 0) continue;
                                throw new IOException("Channel closed");
                            }
                            LOGGER.debug("{} Wrote {} to handshake peer", (Object)Handshaker.socketToString(channel), (Object)remaining);
                            break block1;
                        }
                    }
                    throw new UnsupportedOperationException(result.getStatus().toString());
                }
                case NEED_TASK: {
                    Runnable delegatedTask;
                    while ((delegatedTask = engine.getDelegatedTask()) != null) {
                        try {
                            delegatedTask.run();
                            LOGGER.debug("Ran task {}", (Object)delegatedTask);
                        }
                        catch (RuntimeException e) {
                            LOGGER.error("Delegated task threw exception", (Throwable)e);
                        }
                    }
                    break;
                }
            }
            status = engine.getHandshakeStatus();
        }
    }
}

