/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.tcp.ChronicleSocket;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannelFactory;
import net.openhft.chronicle.network.tcp.ChronicleSocketFactory;
import net.openhft.chronicle.network.tcp.ISocketChannel;
import org.jetbrains.annotations.NotNull;

public class ChronicleSocketChannelImpl
implements ChronicleSocketChannel {
    private final SocketChannel sc;

    ChronicleSocketChannelImpl(SocketChannel sc) {
        this.sc = sc;
    }

    @Override
    @NotNull
    public ChronicleSocketChannel socketChannel() {
        return ChronicleSocketChannelFactory.wrap(this.sc);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.sc.read(byteBuffer);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.sc.write(byteBuffer);
    }

    @Override
    public long write(ByteBuffer[] byteBuffers) throws IOException {
        return this.sc.write(byteBuffers);
    }

    @Override
    public void configureBlocking(boolean blocking) throws IOException {
        SocketChannel sc1 = this.sc;
        if (sc1 != null) {
            sc1.configureBlocking(blocking);
        }
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        return (InetSocketAddress)this.sc.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IOException {
        return (InetSocketAddress)this.sc.getRemoteAddress();
    }

    @Override
    public boolean isOpen() {
        return this.sc.isOpen();
    }

    @Override
    public boolean isBlocking() {
        return this.sc.isBlocking();
    }

    @Override
    public ChronicleSocket socket() {
        SocketChannel sc1 = this.sc;
        if (sc1 == null) {
            return null;
        }
        return ChronicleSocketFactory.toChronicleSocket(sc1.socket());
    }

    @Override
    public void connect(InetSocketAddress socketAddress) throws IOException {
        this.sc.connect(socketAddress);
    }

    @Override
    public void register(Selector selector, int opConnect) throws ClosedChannelException {
        this.sc.register(selector, opConnect);
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.sc.finishConnect();
    }

    @Override
    public void setOption(SocketOption<Boolean> soReuseaddr, boolean b) throws IOException {
        this.sc.setOption((SocketOption)soReuseaddr, (Object)b);
    }

    @Override
    public ISocketChannel toISocketChannel() {
        return ISocketChannel.wrap(this.socketChannel());
    }

    @Override
    public void close() {
        Closeable.closeQuietly((Object)this.sc);
    }
}

