/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.tcp.ChronicleServerSocket;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannelFactory;

public class ChronicleServerSocketFactory {
    public static ChronicleServerSocketChannel open() throws IOException {
        final ServerSocketChannel ssc = ServerSocketChannel.open();
        return new ChronicleServerSocketChannel(){

            public boolean isClosed() {
                throw new UnsupportedOperationException("todo");
            }

            @Override
            public ChronicleSocketChannel accept() throws IOException {
                ssc.configureBlocking(true);
                SocketChannel accept = ssc.accept();
                return ChronicleSocketChannelFactory.wrap(accept);
            }

            @Override
            public boolean isOpen() {
                return ssc.isOpen();
            }

            @Override
            public ChronicleServerSocket socket() {
                return new ChronicleServerSocket(){

                    @Override
                    public int getLocalPort() {
                        return ssc.socket().getLocalPort();
                    }

                    @Override
                    public void close() {
                        Closeable.closeQuietly((Object)ssc.socket());
                    }

                    @Override
                    public void setReuseAddress(boolean b) throws SocketException {
                        ssc.socket().setReuseAddress(b);
                    }

                    @Override
                    public SocketAddress getLocalSocketAddress() {
                        return ssc.socket().getLocalSocketAddress();
                    }
                };
            }

            @Override
            public void close() {
                Closeable.closeQuietly((Object)ssc);
            }

            @Override
            public void bind(InetSocketAddress address) throws IOException {
                ssc.bind(address);
            }

            @Override
            public SocketAddress getLocalAddress() throws IOException {
                return ssc.getLocalAddress();
            }

            @Override
            public void setOption(SocketOption<Boolean> soReuseaddr, boolean b) throws IOException {
                ssc.setOption((SocketOption)soReuseaddr, (Object)b);
            }

            @Override
            public void configureBlocking(boolean configureBlocking) throws IOException {
                ssc.configureBlocking(configureBlocking);
            }
        };
    }
}

