/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import org.jetbrains.annotations.NotNull;

public class RemoteConnector<T extends NetworkContext<T>>
implements Closeable {
    @NotNull
    private final ThrowingFunction<T, TcpEventHandler<T>, IOException> tcpHandlerSupplier;
    private final Integer tcpBufferSize;
    private volatile boolean closed;
    @NotNull
    private volatile List<Closeable> closeables = new ArrayList<Closeable>();

    public RemoteConnector(@NotNull ThrowingFunction<T, TcpEventHandler<T>, IOException> tcpEventHandlerFactory) {
        this.tcpBufferSize = Integer.getInteger("tcp.client.buffer.size", TcpChannelHub.TCP_BUFFER);
        this.tcpHandlerSupplier = tcpEventHandlerFactory;
    }

    private static void closeSocket(SocketChannel socketChannel) {
        Closeable.closeQuietly((Object)socketChannel);
    }

    public void connect(@NotNull String remoteHostPort, @NotNull EventLoop eventLoop, @NotNull T nc, long retryInterval) {
        InetSocketAddress address = TCPRegistry.lookup(remoteHostPort);
        RCEventHandler handler = new RCEventHandler(this, remoteHostPort, nc, eventLoop, address, retryInterval);
        eventLoop.addHandler((EventHandler)handler);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Closeable.closeQuietly(this.closeables);
    }

    SocketChannel openSocketChannel(InetSocketAddress socketAddress) throws IOException {
        SocketChannel result = SocketChannel.open(socketAddress);
        result.configureBlocking(false);
        Socket socket = result.socket();
        if (!TcpEventHandler.DISABLE_TCP_NODELAY) {
            socket.setTcpNoDelay(true);
        }
        socket.setReceiveBufferSize(this.tcpBufferSize);
        socket.setSendBufferSize(this.tcpBufferSize);
        socket.setSoTimeout(0);
        socket.setSoLinger(false, 0);
        return result;
    }

    private class RCEventHandler
    implements EventHandler,
    Closeable {
        private final InetSocketAddress address;
        private final AtomicLong nextPeriod = new AtomicLong();
        private final String remoteHostPort;
        private final T nc;
        private final EventLoop eventLoop;
        private final long retryInterval;
        private volatile boolean closed;
        final /* synthetic */ RemoteConnector this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        RCEventHandler(String nc, T eventLoop, EventLoop address, InetSocketAddress retryInterval, long l2) {
            void remoteHostPort;
            this.this$0 = (RemoteConnector)l;
            this.remoteHostPort = remoteHostPort;
            this.nc = nc;
            this.eventLoop = eventLoop;
            this.address = address;
            this.retryInterval = (long)retryInterval;
        }

        @NotNull
        public HandlerPriority priority() {
            return HandlerPriority.BLOCKING;
        }

        public boolean action() throws InvalidEventHandlerException {
            TcpEventHandler eventHandler;
            SocketChannel sc;
            if (this.closed || this.eventLoop.isClosed()) {
                throw new InvalidEventHandlerException();
            }
            long time = System.currentTimeMillis();
            if (time <= this.nextPeriod.get()) {
                long sleepMillis;
                if (this.priority() == HandlerPriority.BLOCKING && (sleepMillis = this.nextPeriod.get() - time) > 10L) {
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(sleepMillis - 10L));
                }
                return false;
            }
            this.nextPeriod.set(time + this.retryInterval);
            try {
                sc = this.this$0.openSocketChannel(this.address);
                if (sc == null) {
                    return false;
                }
                this.nc.socketChannel(sc);
                this.nc.isAcceptor(false);
                NetworkStatsListener.notifyHostPort(sc, this.nc.networkStatsListener());
                if (!this.nc.socketChannel().isOpen()) {
                    throw new InvalidEventHandlerException();
                }
                eventHandler = (TcpEventHandler)this.this$0.tcpHandlerSupplier.apply(this.nc);
            }
            catch (AlreadyConnectedException e) {
                Jvm.debug().on(this.getClass(), (Throwable)e);
                throw new InvalidEventHandlerException();
            }
            catch (IOException | IORuntimeException e) {
                this.nextPeriod.set(System.currentTimeMillis() + this.retryInterval);
                return false;
            }
            if (this.closed || this.eventLoop.isClosed() || Thread.currentThread().isInterrupted()) {
                Closeable.closeQuietly((Object)eventHandler);
            } else {
                this.eventLoop.addHandler((EventHandler)eventHandler);
                this.this$0.closeables.add(() -> RemoteConnector.closeSocket(sc));
            }
            throw new InvalidEventHandlerException();
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + "{remoteHostPort=" + this.remoteHostPort + ", closed=" + this.closed + "}";
        }

        public void close() {
            this.closed = true;
        }

        public void notifyClosing() {
            this.closed = true;
        }
    }
}

