/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.util.function.Supplier;

public enum TcpHandlerBias implements Supplier<BiasController>
{
    READ{

        @Override
        public BiasController get() {
            return new ReadBiasController();
        }
    }
    ,
    FAIR{

        @Override
        public BiasController get() {
            return new FairBiasController();
        }
    }
    ,
    WRITE{

        @Override
        public BiasController get() {
            return new WriteBiasController();
        }
    };


    private static class FairBiasController
    implements BiasController {
        private FairBiasController() {
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public boolean canWrite() {
            return true;
        }
    }

    private static class WriteBiasController
    implements BiasController {
        private int writes = 0;

        private WriteBiasController() {
        }

        @Override
        public boolean canWrite() {
            ++this.writes;
            return true;
        }

        @Override
        public boolean canRead() {
            if (this.writes >= 8) {
                this.writes = 0;
                return true;
            }
            return false;
        }
    }

    private static class ReadBiasController
    implements BiasController {
        private int reads = 0;

        private ReadBiasController() {
        }

        @Override
        public boolean canRead() {
            ++this.reads;
            return true;
        }

        @Override
        public boolean canWrite() {
            if (this.reads >= 8) {
                this.reads = 0;
                return true;
            }
            return false;
        }
    }

    static interface BiasController {
        public boolean canRead();

        public boolean canWrite();
    }
}

