/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.tcp.ISocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocket;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketFactory;
import org.jetbrains.annotations.NotNull;

public enum ChronicleSocketChannelFactory {


    public static ChronicleSocketChannel wrap() throws IOException {
        return ChronicleSocketChannelFactory.newInstance(SocketChannel.open());
    }

    public static ChronicleSocketChannel wrap(InetSocketAddress socketAddress) throws IOException {
        return ChronicleSocketChannelFactory.newInstance(SocketChannel.open(socketAddress));
    }

    public static ChronicleSocketChannel wrap(@NotNull SocketChannel sc) {
        return ChronicleSocketChannelFactory.newInstance(sc);
    }

    @NotNull
    private static ChronicleSocketChannel newInstance(final @NotNull SocketChannel sc) {
        return new ChronicleSocketChannel(){

            public boolean isClosed() {
                throw new UnsupportedOperationException("todo");
            }

            public void close() {
                Closeable.closeQuietly((Object)sc);
            }

            @Override
            public int read(ByteBuffer byteBuffer) throws IOException {
                return sc.read(byteBuffer);
            }

            @Override
            public int write(ByteBuffer byteBuffer) throws IOException {
                return sc.write(byteBuffer);
            }

            @Override
            public long write(ByteBuffer[] byteBuffers) throws IOException {
                return sc.write(byteBuffers);
            }

            @Override
            public void configureBlocking(boolean blocking) throws IOException {
                SocketChannel sc1 = sc;
                if (sc1 != null) {
                    sc1.configureBlocking(blocking);
                }
            }

            @Override
            public InetSocketAddress getLocalAddress() throws IOException {
                return (InetSocketAddress)sc.getLocalAddress();
            }

            @Override
            public InetSocketAddress getRemoteAddress() throws IOException {
                return (InetSocketAddress)sc.getRemoteAddress();
            }

            @Override
            public boolean isOpen() {
                return sc.isOpen();
            }

            @Override
            public boolean isBlocking() {
                return sc.isBlocking();
            }

            @Override
            public ChronicleSocket socket() {
                SocketChannel sc1 = sc;
                if (sc1 == null) {
                    return null;
                }
                return ChronicleSocketFactory.toChronicleSocket(sc1.socket());
            }

            @Override
            public void connect(InetSocketAddress socketAddress) throws IOException {
                sc.connect(socketAddress);
            }

            @Override
            public void register(Selector selector, int opConnect) throws ClosedChannelException {
                sc.register(selector, opConnect);
            }

            @Override
            public boolean finishConnect() throws IOException {
                return sc.finishConnect();
            }

            @Override
            public void setOption(SocketOption<Boolean> soReuseaddr, boolean b) throws IOException {
                sc.setOption((SocketOption)soReuseaddr, (Object)b);
            }

            @Override
            public ISocketChannel toISocketChannel() {
                return ISocketChannel.wrap((SocketChannel)sc);
            }
        };
    }
}

