/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.tcp.ISocketChannel;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.AcceptStrategy;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.tcp.ChronicleServerSocket;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import org.jetbrains.annotations.NotNull;

public class AcceptorEventHandler<T extends NetworkContext<T>>
extends AbstractCloseable
implements EventHandler {
    @NotNull
    private final Function<T, TcpEventHandler<T>> handlerFactory;
    @NotNull
    private final ChronicleServerSocketChannel ssc;
    @NotNull
    private final Supplier<T> ncFactory;
    private final String hostPort;
    private final AcceptStrategy acceptStrategy;
    private EventLoop eventLoop;

    public AcceptorEventHandler(@NotNull String hostPort, @NotNull Function<T, TcpEventHandler<T>> handlerFactory, @NotNull Supplier<T> ncFactory) throws IOException {
        this(hostPort, handlerFactory, ncFactory, AcceptStrategy.ACCEPT_ALL);
    }

    public AcceptorEventHandler(@NotNull String hostPort, @NotNull Function<T, TcpEventHandler<T>> handlerFactory, @NotNull Supplier<T> ncFactory, @NotNull AcceptStrategy acceptStrategy) throws IOException {
        this.handlerFactory = handlerFactory;
        this.hostPort = hostPort;
        this.ssc = TCPRegistry.acquireServerSocketChannel(this.hostPort);
        this.ncFactory = ncFactory;
        this.acceptStrategy = acceptStrategy;
    }

    public void eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public boolean action() throws InvalidEventHandlerException {
        if (!this.ssc.isOpen() || this.isClosed() || this.eventLoop.isClosed()) {
            throw new InvalidEventHandlerException();
        }
        try {
            ChronicleSocketChannel sc;
            if (Jvm.isDebugEnabled(((Object)((Object)this)).getClass())) {
                Jvm.debug().on(((Object)((Object)this)).getClass(), "accepting " + this.ssc);
            }
            if ((sc = this.acceptStrategy.accept(this.ssc)) != null) {
                if (this.isClosed() || this.eventLoop.isClosed()) {
                    Closeable.closeQuietly((Object)sc);
                    throw new InvalidEventHandlerException("closed");
                }
                NetworkContext nc = (NetworkContext)this.ncFactory.get();
                ISocketChannel isc = sc.toISocketChannel();
                nc.socketChannel(isc);
                nc.isAcceptor(true);
                NetworkStatsListener nl = nc.networkStatsListener();
                NetworkStatsListener.notifyHostPort(isc, nl);
                TcpEventHandler<T> apply = this.handlerFactory.apply(nc);
                this.eventLoop.addHandler(apply);
            }
        }
        catch (AsynchronousCloseException e) {
            this.closeSocket();
            throw new InvalidEventHandlerException((Throwable)e);
        }
        catch (ClosedChannelException e) {
            Jvm.debug().on(((Object)((Object)this)).getClass(), "ClosedChannel");
            this.closeSocket();
            if (this.isClosed()) {
                throw new InvalidEventHandlerException();
            }
            throw new InvalidEventHandlerException((Throwable)e);
        }
        catch (Exception e) {
            if (!this.isClosed() && !this.eventLoop.isClosed()) {
                ChronicleServerSocket socket = this.ssc.socket();
                if (socket != null) {
                    Jvm.warn().on(((Object)((Object)this)).getClass(), this.hostPort + ", port=" + socket.getLocalPort(), (Throwable)e);
                } else {
                    Jvm.warn().on(((Object)((Object)this)).getClass(), this.hostPort, (Throwable)e);
                }
            }
            this.closeSocket();
            throw new InvalidEventHandlerException((Throwable)e);
        }
        return false;
    }

    private void closeSocket() {
        this.ssc.socket().close();
        this.ssc.close();
    }

    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.BLOCKING;
    }

    protected void performClose() {
        this.closeSocket();
    }
}

