/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.HeartbeatListener;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.cluster.TerminationEventHandler;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaNetworkContext<T extends VanillaNetworkContext<T>>
extends AbstractCloseable
implements NetworkContext<T> {
    private SocketChannel socketChannel;
    private boolean isAcceptor = true;
    private HeartbeatListener heartbeatListener;
    private SessionDetailsProvider sessionDetails;
    @Nullable
    private TerminationEventHandler<T> terminationEventHandler;
    private long heartbeatTimeoutMs;
    private WireOutPublisher wireOutPublisher;
    private WireType wireType = WireType.TEXT;
    private Runnable socketReconnector;
    @Nullable
    private NetworkStatsListener<T> networkStatsListener;
    private ServerThreadingStrategy serverThreadingStrategy = ServerThreadingStrategy.SINGLE_THREADED;

    @Override
    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    @NotNull
    public T socketChannel(SocketChannel socketChannel) {
        this.throwExceptionIfClosed();
        this.socketChannel = socketChannel;
        return (T)this;
    }

    @Override
    public void onHandlerChanged(TcpHandler<T> handler) {
    }

    @Override
    @NotNull
    public T isAcceptor(boolean isAcceptor) {
        this.throwExceptionIfClosed();
        this.isAcceptor = isAcceptor;
        return (T)this;
    }

    @Override
    public boolean isAcceptor() {
        return this.isAcceptor;
    }

    @Override
    public synchronized WireOutPublisher wireOutPublisher() {
        return this.wireOutPublisher;
    }

    @Override
    public T wireOutPublisher(WireOutPublisher wireOutPublisher) {
        this.throwExceptionIfClosed();
        this.wireOutPublisher = wireOutPublisher;
        return (T)this;
    }

    @Override
    public WireType wireType() {
        return this.wireType;
    }

    @Override
    @NotNull
    public T wireType(WireType wireType) {
        this.throwExceptionIfClosed();
        this.wireType = wireType;
        return (T)this;
    }

    @Override
    public SessionDetailsProvider sessionDetails() {
        return this.sessionDetails;
    }

    @Override
    @NotNull
    public T sessionDetails(SessionDetailsProvider sessionDetails) {
        this.throwExceptionIfClosed();
        this.sessionDetails = sessionDetails;
        return (T)this;
    }

    @Override
    @Nullable
    public TerminationEventHandler<T> terminationEventHandler() {
        return this.terminationEventHandler;
    }

    @Override
    public void terminationEventHandler(@Nullable TerminationEventHandler<T> terminationEventHandler) {
        this.throwExceptionIfClosed();
        this.terminationEventHandler = terminationEventHandler;
    }

    @Override
    public T heartbeatTimeoutMs(long heartbeatTimeoutMs) {
        this.throwExceptionIfClosed();
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
        return (T)this;
    }

    @Override
    public long heartbeatTimeoutMs() {
        return this.heartbeatTimeoutMs;
    }

    @Override
    public HeartbeatListener heartbeatListener() {
        return this.heartbeatListener;
    }

    @Override
    public void heartbeatListener(@NotNull HeartbeatListener heartbeatListener) {
        this.throwExceptionIfClosed();
        this.heartbeatListener = heartbeatListener;
    }

    protected void performClose() {
        Closeable.closeQuietly(this.networkStatsListener);
    }

    @Override
    public Runnable socketReconnector() {
        return this.socketReconnector;
    }

    @Override
    @NotNull
    public T socketReconnector(Runnable socketReconnector) {
        this.throwExceptionIfClosed();
        this.socketReconnector = socketReconnector;
        return (T)this;
    }

    @Override
    public void networkStatsListener(@NotNull NetworkStatsListener<T> networkStatsListener) {
        this.throwExceptionIfClosed();
        this.networkStatsListener = networkStatsListener;
    }

    @Override
    @Nullable
    public NetworkStatsListener<T> networkStatsListener() {
        return this.networkStatsListener;
    }

    @Override
    public ServerThreadingStrategy serverThreadingStrategy() {
        return this.serverThreadingStrategy;
    }

    @Override
    public T serverThreadingStrategy(ServerThreadingStrategy serverThreadingStrategy) {
        this.throwExceptionIfClosed();
        this.serverThreadingStrategy = serverThreadingStrategy;
        return (T)this;
    }

    protected boolean threadSafetyCheck() {
        return true;
    }
}

