/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.cluster.ConnectionChangedNotifier;
import net.openhft.chronicle.network.cluster.HostConnector;
import net.openhft.chronicle.network.cluster.TerminationEventHandler;
import net.openhft.chronicle.wire.WriteMarshallable;

class ClusterNotifier
implements TerminationEventHandler,
ConnectionChangedNotifier {
    private final List<WriteMarshallable> bootstaps;
    private final AtomicBoolean terminated = new AtomicBoolean();
    private final ConnectionChangedNotifier connectionManager;
    private final HostConnector hostConnector;

    ClusterNotifier(ConnectionChangedNotifier connectionManager, HostConnector hostConnector, List<WriteMarshallable> bootstaps) {
        this.connectionManager = connectionManager;
        this.hostConnector = hostConnector;
        this.bootstaps = bootstaps;
    }

    public void connect() {
        this.bootstaps.forEach(this.hostConnector::bootstrap);
        if (this.hostConnector.connectUri() == null || this.hostConnector.connectUri().isEmpty()) {
            return;
        }
        this.hostConnector.connect();
    }

    public void onConnectionChanged(boolean isConnected, NetworkContext nc) {
        if (!isConnected) {
            this.onClose();
        }
        this.connectionManager.onConnectionChanged(isConnected, nc);
    }

    private void onClose() {
        if (!this.terminated.get()) {
            try {
                this.hostConnector.reconnect();
                return;
            }
            catch (IllegalStateException e) {
                Jvm.warn().on(this.getClass(), "Unable to reconnect as shutting down");
            }
        }
        Closeable.closeQuietly((Object)((Object)this.hostConnector));
    }

    public void onTerminate(NetworkContext nc) {
        this.terminated.set(true);
        this.hostConnector.close();
        this.connectionManager.onConnectionChanged(false, nc);
    }

    @Override
    public boolean isTerminated() {
        return this.terminated.get();
    }
}

